/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.imageio.stream.ImageOutputStreamImpl;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public class FileCacheImageOutputStream
extends ImageOutputStreamImpl {
    static final String IIO_TEMP_FILE_PREFIX = "iioCache";
    static final int MAX_BUFFER_LEN = 1048575;
    private OutputStream os;
    private File file;
    private RandomAccessFile raf;

    public FileCacheImageOutputStream(OutputStream stream, File cacheDir) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.0A"));
        }
        this.os = stream;
        if (cacheDir != null && !cacheDir.isDirectory()) {
            throw new IllegalArgumentException(Messages.getString("imageio.0B"));
        }
        this.file = File.createTempFile(IIO_TEMP_FILE_PREFIX, null, cacheDir);
        this.file.deleteOnExit();
        this.raf = new RandomAccessFile(this.file, "rw");
    }

    @Override
    public void close() throws IOException {
        this.flushBefore(this.raf.length());
        super.close();
        this.raf.close();
        this.file.delete();
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean isCachedFile() {
        return true;
    }

    @Override
    public boolean isCachedMemory() {
        return false;
    }

    @Override
    public void write(int b) throws IOException {
        this.flushBits();
        this.raf.write(b);
        ++this.streamPos;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.flushBits();
        this.raf.write(b, off, len);
        this.streamPos += (long)len;
    }

    @Override
    public int read() throws IOException {
        this.bitOffset = 0;
        int res = this.raf.read();
        if (res >= 0) {
            ++this.streamPos;
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.bitOffset = 0;
        int numRead = this.raf.read(b, off, len);
        if (numRead > 0) {
            this.streamPos += (long)numRead;
        }
        return numRead;
    }

    @Override
    public void flushBefore(long pos) throws IOException {
        long bytesToRead;
        long readFromPos = this.flushedPos;
        super.flushBefore(pos);
        this.raf.seek(readFromPos);
        if (bytesToRead < 1048575L) {
            byte[] buffer = new byte[(int)bytesToRead];
            this.raf.readFully(buffer);
            this.os.write(buffer);
        } else {
            int count;
            byte[] buffer = new byte[1048575];
            for (bytesToRead = pos - readFromPos; bytesToRead > 0L; bytesToRead -= (long)count) {
                count = (int)Math.min(1048575L, bytesToRead);
                this.raf.readFully(buffer, 0, count);
                this.os.write(buffer, 0, count);
            }
        }
        this.os.flush();
        if (pos != this.streamPos) {
            this.raf.seek(this.streamPos);
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < this.flushedPos) {
            throw new IndexOutOfBoundsException();
        }
        this.raf.seek(pos);
        this.streamPos = this.raf.getFilePointer();
        this.bitOffset = 0;
    }

    @Override
    public long length() {
        try {
            return this.raf.length();
        }
        catch (IOException e) {
            return -1L;
        }
    }
}

