/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import javax.imageio.stream.ImageInputStreamImpl;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public class FileCacheImageInputStream
extends ImageInputStreamImpl {
    private InputStream is;
    private File file;
    private RandomAccessFile raf;

    public FileCacheImageInputStream(InputStream stream, File cacheDir) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.0A"));
        }
        this.is = stream;
        if (cacheDir != null && !cacheDir.isDirectory()) {
            throw new IllegalArgumentException(Messages.getString("imageio.0B"));
        }
        this.file = File.createTempFile("iioCache", null, cacheDir);
        this.file.deleteOnExit();
        this.raf = new RandomAccessFile(this.file, "rw");
    }

    @Override
    public int read() throws IOException {
        this.bitOffset = 0;
        if (this.streamPos >= this.raf.length()) {
            int b = this.is.read();
            if (b < 0) {
                return -1;
            }
            this.raf.seek(this.streamPos++);
            this.raf.write(b);
            return b;
        }
        this.raf.seek(this.streamPos++);
        return this.raf.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.bitOffset = 0;
        if (this.streamPos >= this.raf.length()) {
            int nBytes = this.is.read(b, off, len);
            if (nBytes < 0) {
                return -1;
            }
            this.raf.seek(this.streamPos);
            this.raf.write(b, off, nBytes);
            this.streamPos += (long)nBytes;
            return nBytes;
        }
        this.raf.seek(this.streamPos);
        int nBytes = this.raf.read(b, off, len);
        this.streamPos += (long)nBytes;
        return nBytes;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean isCachedFile() {
        return true;
    }

    @Override
    public boolean isCachedMemory() {
        return false;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.raf.close();
        this.file.delete();
    }
}

