/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.imageio.IIOImage;
import javax.imageio.ImageTranscoder;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public abstract class ImageWriter
implements ImageTranscoder {
    protected Locale[] availableLocales;
    protected Locale locale;
    protected ImageWriterSpi originatingProvider;
    protected Object output;
    protected List<IIOWriteProgressListener> progressListeners;
    protected List<IIOWriteWarningListener> warningListeners;
    protected List<Locale> warningLocales;
    private boolean aborted;

    protected ImageWriter(ImageWriterSpi originatingProvider) {
        this.originatingProvider = originatingProvider;
    }

    @Override
    public abstract IIOMetadata convertStreamMetadata(IIOMetadata var1, ImageWriteParam var2);

    @Override
    public abstract IIOMetadata convertImageMetadata(IIOMetadata var1, ImageTypeSpecifier var2, ImageWriteParam var3);

    public ImageWriterSpi getOriginatingProvider() {
        return this.originatingProvider;
    }

    protected void processImageStarted(int imageIndex) {
        if (null != this.progressListeners) {
            for (IIOWriteProgressListener listener : this.progressListeners) {
                listener.imageStarted(this, imageIndex);
            }
        }
    }

    protected void processImageProgress(float percentageDone) {
        if (null != this.progressListeners) {
            for (IIOWriteProgressListener listener : this.progressListeners) {
                listener.imageProgress(this, percentageDone);
            }
        }
    }

    protected void processImageComplete() {
        if (null != this.progressListeners) {
            for (IIOWriteProgressListener listener : this.progressListeners) {
                listener.imageComplete(this);
            }
        }
    }

    protected void processWarningOccurred(int imageIndex, String warning) {
        if (null == warning) {
            throw new NullPointerException(Messages.getString("imageio.2A"));
        }
        if (null != this.warningListeners) {
            for (IIOWriteWarningListener listener : this.warningListeners) {
                listener.warningOccurred(this, imageIndex, warning);
            }
        }
    }

    protected void processWarningOccurred(int imageIndex, String bundle, String key) {
        if (this.warningListeners != null) {
            return;
        }
        if (bundle == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.2B"));
        }
        if (key == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.2C"));
        }
        ClassLoader contextClassloader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        int n = this.warningListeners.size();
        for (int i = 0; i < n; ++i) {
            ResourceBundle rb;
            IIOWriteWarningListener listener = this.warningListeners.get(i);
            Locale locale = this.warningLocales.get(i);
            try {
                rb = ResourceBundle.getBundle(bundle, locale, contextClassloader);
            }
            catch (MissingResourceException e) {
                try {
                    rb = ResourceBundle.getBundle(bundle, locale);
                }
                catch (MissingResourceException e1) {
                    throw new IllegalArgumentException(Messages.getString("imageio.2D"));
                }
            }
            try {
                String warning = rb.getString(key);
                listener.warningOccurred(this, imageIndex, warning);
                continue;
            }
            catch (MissingResourceException e) {
                throw new IllegalArgumentException(Messages.getString("imageio.2E"));
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(Messages.getString("imageio.2F"));
            }
        }
    }

    public void setOutput(Object output) {
        ImageWriterSpi spi;
        if (output != null && null != (spi = this.getOriginatingProvider())) {
            Class[] outTypes = spi.getOutputTypes();
            boolean supported = false;
            for (Class element : outTypes) {
                if (!element.isInstance(output)) continue;
                supported = true;
                break;
            }
            if (!supported) {
                throw new IllegalArgumentException(Messages.getString("imageio.94", output));
            }
        }
        this.output = output;
    }

    public void write(IIOImage image) throws IOException {
        this.write(null, image, null);
    }

    public void write(RenderedImage image) throws IOException {
        this.write(null, new IIOImage(image, null, null), null);
    }

    public abstract void write(IIOMetadata var1, IIOImage var2, ImageWriteParam var3) throws IOException;

    public void dispose() {
    }

    public synchronized void abort() {
        this.aborted = true;
    }

    protected synchronized boolean abortRequested() {
        return this.aborted;
    }

    protected synchronized void clearAbortRequest() {
        this.aborted = false;
    }

    public void addIIOWriteProgressListener(IIOWriteProgressListener listener) {
        if (listener == null) {
            return;
        }
        if (this.progressListeners == null) {
            this.progressListeners = new ArrayList<IIOWriteProgressListener>();
        }
        this.progressListeners.add(listener);
    }

    public void addIIOWriteWarningListener(IIOWriteWarningListener listener) {
        if (listener == null) {
            return;
        }
        if (this.warningListeners == null) {
            this.warningListeners = new ArrayList<IIOWriteWarningListener>();
            this.warningLocales = new ArrayList<Locale>();
        }
        this.warningListeners.add(listener);
        this.warningLocales.add(this.getLocale());
    }

    public Object getOutput() {
        return this.output;
    }

    private final boolean checkOutputReturnFalse() {
        if (this.getOutput() == null) {
            throw new IllegalStateException(Messages.getString("imageio.30"));
        }
        return false;
    }

    private final void unsupportedOperation() {
        if (this.getOutput() == null) {
            throw new IllegalStateException(Messages.getString("imageio.30"));
        }
        throw new UnsupportedOperationException(Messages.getString("imageio.31"));
    }

    public boolean canInsertEmpty(int imageIndex) throws IOException {
        return this.checkOutputReturnFalse();
    }

    public boolean canInsertImage(int imageIndex) throws IOException {
        return this.checkOutputReturnFalse();
    }

    public boolean canRemoveImage(int imageIndex) throws IOException {
        return this.checkOutputReturnFalse();
    }

    public boolean canReplaceImageMetadata(int imageIndex) throws IOException {
        return this.checkOutputReturnFalse();
    }

    public boolean canReplacePixels(int imageIndex) throws IOException {
        return this.checkOutputReturnFalse();
    }

    public boolean canReplaceStreamMetadata() throws IOException {
        return this.checkOutputReturnFalse();
    }

    public boolean canWriteEmpty() throws IOException {
        return this.checkOutputReturnFalse();
    }

    public boolean canWriteRasters() {
        return false;
    }

    public boolean canWriteSequence() {
        return false;
    }

    public void endInsertEmpty() throws IOException {
        this.unsupportedOperation();
    }

    public void endReplacePixels() throws IOException {
        this.unsupportedOperation();
    }

    public void endWriteEmpty() throws IOException {
        this.unsupportedOperation();
    }

    public void endWriteSequence() throws IOException {
        this.unsupportedOperation();
    }

    public Locale[] getAvailableLocales() {
        if (this.availableLocales == null) {
            return null;
        }
        return (Locale[])this.availableLocales.clone();
    }

    public abstract IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier var1, ImageWriteParam var2);

    public abstract IIOMetadata getDefaultStreamMetadata(ImageWriteParam var1);

    public Locale getLocale() {
        return this.locale;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new ImageWriteParam(this.getLocale());
    }

    public int getNumThumbnailsSupported(ImageTypeSpecifier imageType, ImageWriteParam param, IIOMetadata streamMetadata, IIOMetadata imageMetadata) {
        return 0;
    }

    public Dimension[] getPreferredThumbnailSizes(ImageTypeSpecifier imageType, ImageWriteParam param, IIOMetadata streamMetadata, IIOMetadata imageMetadata) {
        return null;
    }

    public void prepareInsertEmpty(int imageIndex, ImageTypeSpecifier imageType, int width, int height, IIOMetadata imageMetadata, List<? extends BufferedImage> thumbnails, ImageWriteParam param) throws IOException {
        this.unsupportedOperation();
    }

    public void prepareReplacePixels(int imageIndex, Rectangle region) throws IOException {
        this.unsupportedOperation();
    }

    public void prepareWriteEmpty(IIOMetadata streamMetadata, ImageTypeSpecifier imageType, int width, int height, IIOMetadata imageMetadata, List<? extends BufferedImage> thumbnails, ImageWriteParam param) throws IOException {
        this.unsupportedOperation();
    }

    public void prepareWriteSequence(IIOMetadata streamMetadata) throws IOException {
        this.unsupportedOperation();
    }

    protected void processThumbnailComplete() {
        if (this.progressListeners != null) {
            for (IIOWriteProgressListener listener : this.progressListeners) {
                listener.thumbnailComplete(this);
            }
        }
    }

    protected void processThumbnailProgress(float percentageDone) {
        if (this.progressListeners != null) {
            for (IIOWriteProgressListener listener : this.progressListeners) {
                listener.thumbnailProgress(this, percentageDone);
            }
        }
    }

    protected void processThumbnailStarted(int imageIndex, int thumbnailIndex) {
        if (this.progressListeners != null) {
            for (IIOWriteProgressListener listener : this.progressListeners) {
                listener.thumbnailStarted(this, imageIndex, thumbnailIndex);
            }
        }
    }

    protected void processWriteAborted() {
        if (this.progressListeners != null) {
            for (IIOWriteProgressListener listener : this.progressListeners) {
                listener.writeAborted(this);
            }
        }
    }

    public void removeAllIIOWriteProgressListeners() {
        this.progressListeners = null;
    }

    public void removeAllIIOWriteWarningListeners() {
        this.warningListeners = null;
        this.warningLocales = null;
    }

    public void removeIIOWriteProgressListener(IIOWriteProgressListener listener) {
        if (this.progressListeners != null && listener != null && this.progressListeners.remove(listener) && this.progressListeners.isEmpty()) {
            this.progressListeners = null;
        }
    }

    public void removeIIOWriteWarningListener(IIOWriteWarningListener listener) {
        if (this.warningListeners == null || listener == null) {
            return;
        }
        int idx = this.warningListeners.indexOf(listener);
        if (idx > -1) {
            this.warningListeners.remove(idx);
            this.warningLocales.remove(idx);
            if (this.warningListeners.isEmpty()) {
                this.warningListeners = null;
                this.warningLocales = null;
            }
        }
    }

    public void removeImage(int imageIndex) throws IOException {
        this.unsupportedOperation();
    }

    public void replaceImageMetadata(int imageIndex, IIOMetadata imageMetadata) throws IOException {
        this.unsupportedOperation();
    }

    public void replacePixels(RenderedImage image, ImageWriteParam param) throws IOException {
        this.unsupportedOperation();
    }

    public void replacePixels(Raster raster, ImageWriteParam param) throws IOException {
        this.unsupportedOperation();
    }

    public void replaceStreamMetadata(IIOMetadata streamMetadata) throws IOException {
        this.unsupportedOperation();
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            this.locale = null;
            return;
        }
        Locale[] locales = this.getAvailableLocales();
        boolean validLocale = false;
        if (locales != null) {
            for (int i = 0; i < locales.length; ++i) {
                if (!locale.equals(locales[i])) continue;
                validLocale = true;
                break;
            }
        }
        if (!validLocale) {
            throw new IllegalArgumentException(Messages.getString("imageio.32"));
        }
        this.locale = locale;
    }

    public void reset() {
        this.setOutput(null);
        this.setLocale(null);
        this.removeAllIIOWriteWarningListeners();
        this.removeAllIIOWriteProgressListeners();
        this.clearAbortRequest();
    }

    public void writeInsert(int imageIndex, IIOImage image, ImageWriteParam param) throws IOException {
        this.unsupportedOperation();
    }

    public void writeToSequence(IIOImage image, ImageWriteParam param) throws IOException {
        this.unsupportedOperation();
    }
}

