/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.Vector;

public class RenderableImageProducer
implements ImageProducer,
Runnable {
    RenderableImage rbl;
    RenderContext rc;
    Vector<ImageConsumer> consumers = new Vector();

    public RenderableImageProducer(RenderableImage rdblImage, RenderContext rc) {
        this.rbl = rdblImage;
        this.rc = rc;
    }

    public synchronized void setRenderContext(RenderContext rc) {
        this.rc = rc;
    }

    @Override
    public synchronized boolean isConsumer(ImageConsumer ic) {
        return this.consumers.contains(ic);
    }

    @Override
    public synchronized void startProduction(ImageConsumer ic) {
        this.addConsumer(ic);
        Thread t = new Thread((Runnable)this, "RenderableImageProducer thread");
        t.start();
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer ic) {
        if (ic != null) {
            this.consumers.removeElement(ic);
        }
    }

    @Override
    public synchronized void addConsumer(ImageConsumer ic) {
        if (ic != null && !this.consumers.contains(ic)) {
            this.consumers.addElement(ic);
        }
    }

    @Override
    public void run() {
        if (this.rbl == null) {
            return;
        }
        RenderedImage rd = this.rc != null ? this.rbl.createRendering(this.rc) : this.rbl.createDefaultRendering();
        ColorModel cm = rd.getColorModel();
        if (cm == null) {
            cm = ColorModel.getRGBdefault();
        }
        Raster r = rd.getData();
        int w = r.getWidth();
        int h = r.getHeight();
        for (ImageConsumer c : this.consumers) {
            c.setDimensions(w, h);
            c.setHints(30);
        }
        int[] scanLine = new int[w];
        int[] pixel = null;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                pixel = r.getPixel(x, y, pixel);
                scanLine[x] = cm.getDataElement(pixel, 0);
            }
            for (ImageConsumer c : this.consumers) {
                c.setPixels(0, y, w, 1, cm, scanLine, 0, w);
            }
        }
        for (ImageConsumer c : this.consumers) {
            c.imageComplete(3);
        }
    }
}

