/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import org.apache.harmony.awt.internal.nls.Messages;

public abstract class SampleModel {
    protected int width;
    protected int height;
    protected int numBands;
    protected int dataType;

    public SampleModel(int dataType, int w, int h, int numBands) {
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException(Messages.getString("awt.22E"));
        }
        double squre = (double)w * (double)h;
        if (squre >= 2.147483647E9) {
            throw new IllegalArgumentException(Messages.getString("awt.22F"));
        }
        if (dataType < 0 || dataType > 5 && dataType != 32) {
            throw new IllegalArgumentException(Messages.getString("awt.230"));
        }
        if (numBands < 1) {
            throw new IllegalArgumentException(Messages.getString("awt.231"));
        }
        this.dataType = dataType;
        this.width = w;
        this.height = h;
        this.numBands = numBands;
    }

    public abstract Object getDataElements(int var1, int var2, Object var3, DataBuffer var4);

    public Object getDataElements(int x, int y, int w, int h, Object obj, DataBuffer data) {
        int numDataElements = this.getNumDataElements();
        int idx = 0;
        switch (this.getTransferType()) {
            case 0: {
                byte[] bbuf = null;
                byte[] bdata = obj == null ? new byte[numDataElements * w * h] : (byte[])obj;
                for (int i = y; i < y + h; ++i) {
                    for (int j = x; j < x + w; ++j) {
                        bbuf = (byte[])this.getDataElements(j, i, bbuf, data);
                        for (int n = 0; n < numDataElements; ++n) {
                            bdata[idx++] = bbuf[n];
                        }
                    }
                }
                obj = bdata;
                break;
            }
            case 1: 
            case 2: {
                short[] sbuf = null;
                short[] sdata = obj == null ? new short[numDataElements * w * h] : (short[])obj;
                for (int i = y; i < y + h; ++i) {
                    for (int j = x; j < x + w; ++j) {
                        sbuf = (short[])this.getDataElements(j, i, sbuf, data);
                        for (int n = 0; n < numDataElements; ++n) {
                            sdata[idx++] = sbuf[n];
                        }
                    }
                }
                obj = sdata;
                break;
            }
            case 3: {
                int[] ibuf = null;
                int[] idata = obj == null ? new int[numDataElements * w * h] : (int[])obj;
                for (int i = y; i < y + h; ++i) {
                    for (int j = x; j < x + w; ++j) {
                        ibuf = (int[])this.getDataElements(j, i, ibuf, data);
                        for (int n = 0; n < numDataElements; ++n) {
                            idata[idx++] = ibuf[n];
                        }
                    }
                }
                obj = idata;
                break;
            }
            case 4: {
                float[] fbuf = null;
                float[] fdata = obj == null ? new float[numDataElements * w * h] : (float[])obj;
                for (int i = y; i < y + h; ++i) {
                    for (int j = x; j < x + w; ++j) {
                        fbuf = (float[])this.getDataElements(j, i, fbuf, data);
                        for (int n = 0; n < numDataElements; ++n) {
                            fdata[idx++] = fbuf[n];
                        }
                    }
                }
                obj = fdata;
                break;
            }
            case 5: {
                double[] dbuf = null;
                double[] ddata = obj == null ? new double[numDataElements * w * h] : (double[])obj;
                for (int i = y; i < y + h; ++i) {
                    for (int j = x; j < x + w; ++j) {
                        dbuf = (double[])this.getDataElements(j, i, dbuf, data);
                        for (int n = 0; n < numDataElements; ++n) {
                            ddata[idx++] = dbuf[n];
                        }
                    }
                }
                obj = ddata;
            }
        }
        return obj;
    }

    public abstract void setDataElements(int var1, int var2, Object var3, DataBuffer var4);

    public void setDataElements(int x, int y, int w, int h, Object obj, DataBuffer data) {
        int numDataElements = this.getNumDataElements();
        int idx = 0;
        switch (this.getTransferType()) {
            case 0: {
                byte[] bbuf = new byte[numDataElements];
                for (int i = y; i < y + h; ++i) {
                    for (int j = x; j < x + w; ++j) {
                        for (int n = 0; n < numDataElements; ++n) {
                            bbuf[n] = ((byte[])obj)[idx++];
                        }
                        this.setDataElements(j, i, bbuf, data);
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                short[] sbuf = new short[numDataElements];
                for (int i = y; i < y + h; ++i) {
                    for (int j = x; j < x + w; ++j) {
                        for (int n = 0; n < numDataElements; ++n) {
                            sbuf[n] = ((short[])obj)[idx++];
                        }
                        this.setDataElements(j, i, sbuf, data);
                    }
                }
                break;
            }
            case 3: {
                int[] ibuf = new int[numDataElements];
                for (int i = y; i < y + h; ++i) {
                    for (int j = x; j < x + w; ++j) {
                        for (int n = 0; n < numDataElements; ++n) {
                            ibuf[n] = ((int[])obj)[idx++];
                        }
                        this.setDataElements(j, i, ibuf, data);
                    }
                }
                break;
            }
            case 4: {
                float[] fbuf = new float[numDataElements];
                for (int i = y; i < y + h; ++i) {
                    for (int j = x; j < x + w; ++j) {
                        for (int n = 0; n < numDataElements; ++n) {
                            fbuf[n] = ((float[])obj)[idx++];
                        }
                        this.setDataElements(j, i, fbuf, data);
                    }
                }
                break;
            }
            case 5: {
                double[] dbuf = new double[numDataElements];
                for (int i = y; i < y + h; ++i) {
                    for (int j = x; j < x + w; ++j) {
                        for (int n = 0; n < numDataElements; ++n) {
                            dbuf[n] = ((double[])obj)[idx++];
                        }
                        this.setDataElements(j, i, dbuf, data);
                    }
                }
                break;
            }
        }
    }

    public abstract SampleModel createSubsetSampleModel(int[] var1);

    public abstract SampleModel createCompatibleSampleModel(int var1, int var2);

    public int[] getPixel(int x, int y, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int[] pixel = iArray == null ? new int[this.numBands] : iArray;
        for (int i = 0; i < this.numBands; ++i) {
            pixel[i] = this.getSample(x, y, i, data);
        }
        return pixel;
    }

    public void setPixel(int x, int y, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        for (int i = 0; i < this.numBands; ++i) {
            this.setSample(x, y, i, iArray[i], data);
        }
    }

    public float[] getPixel(int x, int y, float[] fArray, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        float[] pixel = fArray == null ? new float[this.numBands] : fArray;
        for (int i = 0; i < this.numBands; ++i) {
            pixel[i] = this.getSampleFloat(x, y, i, data);
        }
        return pixel;
    }

    public void setPixel(int x, int y, float[] fArray, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        for (int i = 0; i < this.numBands; ++i) {
            this.setSample(x, y, i, fArray[i], data);
        }
    }

    public double[] getPixel(int x, int y, double[] dArray, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        double[] pixel = dArray == null ? new double[this.numBands] : dArray;
        for (int i = 0; i < this.numBands; ++i) {
            pixel[i] = this.getSampleDouble(x, y, i, data);
        }
        return pixel;
    }

    public void setPixel(int x, int y, double[] dArray, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        for (int i = 0; i < this.numBands; ++i) {
            this.setSample(x, y, i, dArray[i], data);
        }
    }

    public abstract int getSample(int var1, int var2, int var3, DataBuffer var4);

    public float getSampleFloat(int x, int y, int b, DataBuffer data) {
        return this.getSample(x, y, b, data);
    }

    public double getSampleDouble(int x, int y, int b, DataBuffer data) {
        return this.getSample(x, y, b, data);
    }

    public int[] getPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int idx = 0;
        int[] pixels = iArray == null ? new int[w * h * this.numBands] : iArray;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                for (int n = 0; n < this.numBands; ++n) {
                    pixels[idx++] = this.getSample(j, i, n, data);
                }
            }
        }
        return pixels;
    }

    public void setPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int idx = 0;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                for (int n = 0; n < this.numBands; ++n) {
                    this.setSample(j, i, n, iArray[idx++], data);
                }
            }
        }
    }

    public float[] getPixels(int x, int y, int w, int h, float[] fArray, DataBuffer data) {
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int idx = 0;
        float[] pixels = fArray == null ? new float[w * h * this.numBands] : fArray;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                for (int n = 0; n < this.numBands; ++n) {
                    pixels[idx++] = this.getSampleFloat(j, i, n, data);
                }
            }
        }
        return pixels;
    }

    public void setPixels(int x, int y, int w, int h, float[] fArray, DataBuffer data) {
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int idx = 0;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                for (int n = 0; n < this.numBands; ++n) {
                    this.setSample(j, i, n, fArray[idx++], data);
                }
            }
        }
    }

    public double[] getPixels(int x, int y, int w, int h, double[] dArray, DataBuffer data) {
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int idx = 0;
        double[] pixels = dArray == null ? new double[w * h * this.numBands] : dArray;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                for (int n = 0; n < this.numBands; ++n) {
                    pixels[idx++] = this.getSampleDouble(j, i, n, data);
                }
            }
        }
        return pixels;
    }

    public void setPixels(int x, int y, int w, int h, double[] dArray, DataBuffer data) {
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int idx = 0;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                for (int n = 0; n < this.numBands; ++n) {
                    this.setSample(j, i, n, dArray[idx++], data);
                }
            }
        }
    }

    public abstract void setSample(int var1, int var2, int var3, int var4, DataBuffer var5);

    public int[] getSamples(int x, int y, int w, int h, int b, int[] iArray, DataBuffer data) {
        int idx = 0;
        int[] samples = iArray == null ? new int[w * h] : iArray;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                samples[idx++] = this.getSample(j, i, b, data);
            }
        }
        return samples;
    }

    public void setSamples(int x, int y, int w, int h, int b, int[] iArray, DataBuffer data) {
        int idx = 0;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                this.setSample(j, i, b, iArray[idx++], data);
            }
        }
    }

    public float[] getSamples(int x, int y, int w, int h, int b, float[] fArray, DataBuffer data) {
        int idx = 0;
        float[] samples = fArray == null ? new float[w * h] : fArray;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                samples[idx++] = this.getSampleFloat(j, i, b, data);
            }
        }
        return samples;
    }

    public void setSamples(int x, int y, int w, int h, int b, float[] fArray, DataBuffer data) {
        int idx = 0;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                this.setSample(j, i, b, fArray[idx++], data);
            }
        }
    }

    public double[] getSamples(int x, int y, int w, int h, int b, double[] dArray, DataBuffer data) {
        int idx = 0;
        double[] samples = dArray == null ? new double[w * h] : dArray;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                samples[idx++] = this.getSampleDouble(j, i, b, data);
            }
        }
        return samples;
    }

    public void setSamples(int x, int y, int w, int h, int b, double[] dArray, DataBuffer data) {
        int idx = 0;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                this.setSample(j, i, b, dArray[idx++], data);
            }
        }
    }

    public void setSample(int x, int y, int b, float s, DataBuffer data) {
        this.setSample(x, y, b, (int)s, data);
    }

    public void setSample(int x, int y, int b, double s, DataBuffer data) {
        this.setSample(x, y, b, (int)s, data);
    }

    public abstract DataBuffer createDataBuffer();

    public abstract int getSampleSize(int var1);

    public abstract int[] getSampleSize();

    public final int getWidth() {
        return this.width;
    }

    public int getTransferType() {
        return this.dataType;
    }

    public abstract int getNumDataElements();

    public final int getNumBands() {
        return this.numBands;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getDataType() {
        return this.dataType;
    }
}

