/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;

public abstract class RGBImageFilter
extends ImageFilter {
    protected ColorModel origmodel;
    protected ColorModel newmodel;
    protected boolean canFilterIndexColorModel;

    public IndexColorModel filterIndexColorModel(IndexColorModel icm) {
        int transferType = icm.getTransferType();
        int bits = icm.getPixelSize();
        int mapSize = icm.getMapSize();
        int[] colorMap = new int[mapSize];
        int[] filteredColorMap = new int[mapSize];
        icm.getRGBs(colorMap);
        int trans = -1;
        boolean hasAlpha = false;
        for (int i = 0; i < mapSize; ++i) {
            filteredColorMap[i] = this.filterRGB(-1, -1, colorMap[i]);
            int alpha = filteredColorMap[i] >>> 24;
            if (alpha == 255) continue;
            if (!hasAlpha) {
                hasAlpha = true;
            }
            if (alpha != 0 || trans >= 0) continue;
            trans = i;
        }
        return new IndexColorModel(bits, mapSize, filteredColorMap, 0, hasAlpha, trans, transferType);
    }

    public void substituteColorModel(ColorModel oldcm, ColorModel newcm) {
        this.origmodel = oldcm;
        this.newmodel = newcm;
    }

    @Override
    public void setColorModel(ColorModel model) {
        if (model instanceof IndexColorModel && this.canFilterIndexColorModel) {
            IndexColorModel icm = (IndexColorModel)model;
            IndexColorModel filteredModel = this.filterIndexColorModel(icm);
            this.substituteColorModel(model, filteredModel);
            this.consumer.setColorModel(filteredModel);
        } else {
            this.consumer.setColorModel(ColorModel.getRGBdefault());
        }
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (model == null || model == this.origmodel) {
            this.consumer.setPixels(x, y, w, h, this.newmodel, pixels, off, scansize);
        } else {
            int[] rgbPixels = new int[w];
            int sy = y;
            int pixelsOff = off;
            while (sy < y + h) {
                int sx = x;
                int idx = 0;
                while (sx < x + w) {
                    rgbPixels[idx] = model.getRGB(pixels[pixelsOff + idx]);
                    ++sx;
                    ++idx;
                }
                this.filterRGBPixels(x, sy, w, 1, rgbPixels, 0, w);
                ++sy;
                pixelsOff += scansize;
            }
        }
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        if (model == null || model == this.origmodel) {
            this.consumer.setPixels(x, y, w, h, this.newmodel, pixels, off, scansize);
        } else {
            int[] rgbPixels = new int[w];
            int sy = y;
            int pixelsOff = off;
            while (sy < y + h) {
                int sx = x;
                int idx = 0;
                while (sx < x + w) {
                    rgbPixels[idx] = model.getRGB(pixels[pixelsOff + idx] & 0xFF);
                    ++sx;
                    ++idx;
                }
                this.filterRGBPixels(x, sy, w, 1, rgbPixels, 0, w);
                ++sy;
                pixelsOff += scansize;
            }
        }
    }

    public void filterRGBPixels(int x, int y, int w, int h, int[] pixels, int off, int scansize) {
        int sy = y;
        int lineOff = off;
        while (sy < y + h) {
            int sx = x;
            int idx = 0;
            while (sx < x + w) {
                pixels[lineOff + idx] = this.filterRGB(sx, sy, pixels[lineOff + idx]);
                ++sx;
                ++idx;
            }
            ++sy;
            lineOff += scansize;
        }
        this.consumer.setPixels(x, y, w, h, ColorModel.getRGBdefault(), pixels, off, scansize);
    }

    public abstract int filterRGB(int var1, int var2, int var3);
}

