/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import org.apache.harmony.awt.internal.nls.Messages;

public class MultiPixelPackedSampleModel
extends SampleModel {
    private int pixelBitStride;
    private int scanlineStride;
    private int dataBitOffset;
    private int bitMask;
    private int dataElementSize;
    private int pixelsPerDataElement;

    public MultiPixelPackedSampleModel(int dataType, int w, int h, int numberOfBits, int scanlineStride, int dataBitOffset) {
        super(dataType, w, h, 1);
        if (dataType != 0 && dataType != 1 && dataType != 3) {
            throw new IllegalArgumentException(Messages.getString("awt.61", dataType));
        }
        this.scanlineStride = scanlineStride;
        if (numberOfBits == 0) {
            throw new RasterFormatException(Messages.getString("awt.20C"));
        }
        this.pixelBitStride = numberOfBits;
        this.dataElementSize = DataBuffer.getDataTypeSize(dataType);
        if (this.dataElementSize % this.pixelBitStride != 0) {
            throw new RasterFormatException(Messages.getString("awt.20D"));
        }
        if (dataBitOffset % numberOfBits != 0) {
            throw new RasterFormatException(Messages.getString("awt.20E"));
        }
        this.dataBitOffset = dataBitOffset;
        this.pixelsPerDataElement = this.dataElementSize / this.pixelBitStride;
        this.bitMask = (1 << numberOfBits) - 1;
    }

    public MultiPixelPackedSampleModel(int dataType, int w, int h, int numberOfBits) {
        this(dataType, w, h, numberOfBits, (numberOfBits * w + DataBuffer.getDataTypeSize(dataType) - 1) / DataBuffer.getDataTypeSize(dataType), 0);
    }

    @Override
    public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        switch (this.getTransferType()) {
            case 0: {
                byte[] bdata = obj == null ? new byte[1] : (byte[])obj;
                bdata[0] = (byte)this.getSample(x, y, 0, data);
                obj = bdata;
                break;
            }
            case 1: {
                short[] sdata = obj == null ? new short[1] : (short[])obj;
                sdata[0] = (short)this.getSample(x, y, 0, data);
                obj = sdata;
                break;
            }
            case 3: {
                int[] idata = obj == null ? new int[1] : (int[])obj;
                idata[0] = this.getSample(x, y, 0, data);
                obj = idata;
            }
        }
        return obj;
    }

    @Override
    public void setDataElements(int x, int y, Object obj, DataBuffer data) {
        this.setSample(x, y, obj, data, 1, 0);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof MultiPixelPackedSampleModel)) {
            return false;
        }
        MultiPixelPackedSampleModel model = (MultiPixelPackedSampleModel)o;
        return this.width == model.width && this.height == model.height && this.numBands == model.numBands && this.dataType == model.dataType && this.pixelBitStride == model.pixelBitStride && this.bitMask == model.bitMask && this.pixelsPerDataElement == model.pixelsPerDataElement && this.dataElementSize == model.dataElementSize && this.dataBitOffset == model.dataBitOffset && this.scanlineStride == model.scanlineStride;
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] bands) {
        if (bands != null && bands.length != 1) {
            throw new RasterFormatException(Messages.getString("awt.20F"));
        }
        return this.createCompatibleSampleModel(this.width, this.height);
    }

    @Override
    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new MultiPixelPackedSampleModel(this.dataType, w, h, this.pixelBitStride);
    }

    @Override
    public int[] getPixel(int x, int y, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int[] pixel = iArray == null ? new int[this.numBands] : iArray;
        pixel[0] = this.getSample(x, y, 0, data);
        return pixel;
    }

    @Override
    public void setPixel(int x, int y, int[] iArray, DataBuffer data) {
        this.setSample(x, y, iArray, data, 2, 0);
    }

    @Override
    public int getSample(int x, int y, int b, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height || b != 0) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int bitnum = this.dataBitOffset + x * this.pixelBitStride;
        int elem = data.getElem(y * this.scanlineStride + bitnum / this.dataElementSize);
        int shift = this.dataElementSize - (bitnum & this.dataElementSize - 1) - this.pixelBitStride;
        return elem >> shift & this.bitMask;
    }

    @Override
    public void setSample(int x, int y, int b, int s, DataBuffer data) {
        if (b != 0) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        this.setSample(x, y, null, data, 3, s);
    }

    @Override
    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int size = this.scanlineStride * this.height;
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(size + (this.dataBitOffset + 7) / 8);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(size + (this.dataBitOffset + 15) / 16);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(size + (this.dataBitOffset + 31) / 32);
            }
        }
        return dataBuffer;
    }

    public int getOffset(int x, int y) {
        return y * this.scanlineStride + (x * this.pixelBitStride + this.dataBitOffset) / this.dataElementSize;
    }

    @Override
    public int getSampleSize(int band) {
        return this.pixelBitStride;
    }

    public int getBitOffset(int x) {
        return (x * this.pixelBitStride + this.dataBitOffset) % this.dataElementSize;
    }

    @Override
    public int[] getSampleSize() {
        int[] sampleSizes = new int[]{this.pixelBitStride};
        return sampleSizes;
    }

    public int hashCode() {
        int hash = 0;
        int tmp = 0;
        hash = this.width;
        tmp = hash >>> 24;
        hash <<= 8;
        hash |= tmp;
        tmp = (hash ^= this.height) >>> 24;
        hash <<= 8;
        hash |= tmp;
        tmp = (hash ^= this.numBands) >>> 24;
        hash <<= 8;
        hash |= tmp;
        tmp = (hash ^= this.dataType) >>> 24;
        hash <<= 8;
        hash |= tmp;
        tmp = (hash ^= this.scanlineStride) >>> 24;
        hash <<= 8;
        hash |= tmp;
        tmp = (hash ^= this.pixelBitStride) >>> 24;
        hash <<= 8;
        hash |= tmp;
        tmp = (hash ^= this.dataBitOffset) >>> 24;
        hash <<= 8;
        hash |= tmp;
        tmp = (hash ^= this.bitMask) >>> 24;
        hash <<= 8;
        hash |= tmp;
        tmp = (hash ^= this.dataElementSize) >>> 24;
        hash <<= 8;
        hash |= tmp;
        return hash ^= this.pixelsPerDataElement;
    }

    @Override
    public int getTransferType() {
        if (this.pixelBitStride > 16) {
            return 3;
        }
        if (this.pixelBitStride > 8) {
            return 1;
        }
        return 0;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelBitStride() {
        return this.pixelBitStride;
    }

    @Override
    public int getNumDataElements() {
        return 1;
    }

    public int getDataBitOffset() {
        return this.dataBitOffset;
    }

    private void setSample(int x, int y, Object obj, DataBuffer data, int methodId, int s) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int bitnum = this.dataBitOffset + x * this.pixelBitStride;
        int idx = y * this.scanlineStride + bitnum / this.dataElementSize;
        int shift = this.dataElementSize - (bitnum & this.dataElementSize - 1) - this.pixelBitStride;
        int mask = ~(this.bitMask << shift);
        int elem = data.getElem(idx);
        switch (methodId) {
            case 1: {
                switch (this.getTransferType()) {
                    case 0: {
                        s = ((byte[])obj)[0] & 0xFF;
                        break;
                    }
                    case 1: {
                        s = ((short[])obj)[0] & 0xFFFF;
                        break;
                    }
                    case 3: {
                        s = ((int[])obj)[0];
                    }
                }
                break;
            }
            case 2: {
                s = ((int[])obj)[0];
            }
        }
        elem &= mask;
        data.setElem(idx, elem |= (s & this.bitMask) << shift);
    }
}

