/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;

public final class DataBufferFloat
extends DataBuffer {
    float[][] data;

    public DataBufferFloat(float[][] dataArrays, int size, int[] offsets) {
        super(4, size, dataArrays.length, offsets);
        this.data = (float[][])dataArrays.clone();
    }

    public DataBufferFloat(float[][] dataArrays, int size) {
        super(4, size, dataArrays.length);
        this.data = (float[][])dataArrays.clone();
    }

    public DataBufferFloat(float[] dataArray, int size, int offset) {
        super(4, size, 1, offset);
        this.data = new float[1][];
        this.data[0] = dataArray;
    }

    public DataBufferFloat(float[] dataArray, int size) {
        super(4, size);
        this.data = new float[1][];
        this.data[0] = dataArray;
    }

    public DataBufferFloat(int size, int numBanks) {
        super(4, size, numBanks);
        this.data = new float[numBanks][];
        int i = 0;
        while (i < numBanks) {
            this.data[i++] = new float[size];
        }
    }

    public DataBufferFloat(int size) {
        super(4, size);
        this.data = new float[1][];
        this.data[0] = new float[size];
    }

    @Override
    public void setElem(int bank, int i, int val) {
        this.data[bank][this.offsets[bank] + i] = val;
        this.notifyChanged();
    }

    @Override
    public void setElemFloat(int bank, int i, float val) {
        this.data[bank][this.offsets[bank] + i] = val;
        this.notifyChanged();
    }

    @Override
    public void setElemDouble(int bank, int i, double val) {
        this.data[bank][this.offsets[bank] + i] = (float)val;
        this.notifyChanged();
    }

    @Override
    public void setElem(int i, int val) {
        this.data[0][this.offset + i] = val;
        this.notifyChanged();
    }

    @Override
    public int getElem(int bank, int i) {
        return (int)this.data[bank][this.offsets[bank] + i];
    }

    @Override
    public float getElemFloat(int bank, int i) {
        return this.data[bank][this.offsets[bank] + i];
    }

    @Override
    public double getElemDouble(int bank, int i) {
        return this.data[bank][this.offsets[bank] + i];
    }

    @Override
    public void setElemFloat(int i, float val) {
        this.data[0][this.offset + i] = val;
        this.notifyChanged();
    }

    @Override
    public void setElemDouble(int i, double val) {
        this.data[0][this.offset + i] = (float)val;
        this.notifyChanged();
    }

    public float[] getData(int bank) {
        this.notifyTaken();
        return this.data[bank];
    }

    @Override
    public int getElem(int i) {
        return (int)this.data[0][this.offset + i];
    }

    @Override
    public float getElemFloat(int i) {
        return this.data[0][this.offset + i];
    }

    @Override
    public double getElemDouble(int i) {
        return this.data[0][this.offset + i];
    }

    public float[][] getBankData() {
        this.notifyTaken();
        return (float[][])this.data.clone();
    }

    public float[] getData() {
        this.notifyTaken();
        return this.data[0];
    }
}

