/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

public class CropImageFilter
extends ImageFilter {
    private final int X;
    private final int Y;
    private final int WIDTH;
    private final int HEIGHT;

    public CropImageFilter(int x, int y, int w, int h) {
        this.X = x;
        this.Y = y;
        this.WIDTH = w;
        this.HEIGHT = h;
    }

    @Override
    public void setProperties(Hashtable<?, ?> props) {
        Hashtable fprops = props == null ? new Hashtable() : (Hashtable)props.clone();
        String propName = "Crop Filters";
        String prop = "x=" + this.X + "; y=" + this.Y + "; width=" + this.WIDTH + "; height=" + this.HEIGHT;
        Object o = fprops.get(propName);
        if (o != null) {
            prop = o instanceof String ? (String)o + "; " + prop : o.toString() + "; " + prop;
        }
        fprops.put(propName, prop);
        this.consumer.setProperties(fprops);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int destHeight;
        int destY;
        int destWidth;
        int destX;
        if (x + w < this.X || this.X + this.WIDTH < x || y + h < this.Y || this.Y + this.HEIGHT < y) {
            return;
        }
        int newOffset = off;
        int endX = this.X + this.WIDTH;
        int endY = this.Y + this.HEIGHT;
        int srcEndX = x + w;
        int srcEndY = y + h;
        if (x <= this.X) {
            destX = 0;
            newOffset += this.X;
            destWidth = endX >= srcEndX ? srcEndX - this.X : this.WIDTH;
        } else {
            destX = x - this.X;
            destWidth = endX >= srcEndX ? w : endX - x;
        }
        if (y <= this.Y) {
            newOffset += scansize * (this.Y - y);
            destY = 0;
            destHeight = endY >= srcEndY ? srcEndY - this.Y : this.HEIGHT;
        } else {
            destY = y - this.Y;
            destHeight = endY >= srcEndY ? h : endY - y;
        }
        this.consumer.setPixels(destX, destY, destWidth, destHeight, model, pixels, newOffset, scansize);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int destHeight;
        int destY;
        int destWidth;
        int destX;
        if (x + w < this.X || this.X + this.WIDTH < x || y + h < this.Y || this.Y + this.HEIGHT < y) {
            return;
        }
        int newOffset = off;
        int endX = this.X + this.WIDTH;
        int endY = this.Y + this.HEIGHT;
        int srcEndX = x + w;
        int srcEndY = y + h;
        if (x <= this.X) {
            destX = 0;
            newOffset += this.X;
            destWidth = endX >= srcEndX ? srcEndX - this.X : this.WIDTH;
        } else {
            destX = x - this.X;
            destWidth = endX >= srcEndX ? w : endX - x;
        }
        if (y <= this.Y) {
            newOffset += scansize * (this.Y - y);
            destY = 0;
            destHeight = endY >= srcEndY ? srcEndY - this.Y : this.HEIGHT;
        } else {
            destY = y - this.Y;
            destHeight = endY >= srcEndY ? h : endY - y;
        }
        this.consumer.setPixels(destX, destY, destWidth, destHeight, model, pixels, newOffset, scansize);
    }

    @Override
    public void setDimensions(int w, int h) {
        this.consumer.setDimensions(this.WIDTH, this.HEIGHT);
    }
}

