/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.util.Arrays;
import org.apache.harmony.awt.internal.nls.Messages;

public class ComponentSampleModel
extends SampleModel {
    protected int[] bandOffsets;
    protected int[] bankIndices;
    protected int numBands;
    protected int numBanks;
    protected int scanlineStride;
    protected int pixelStride;

    public ComponentSampleModel(int dataType, int w, int h, int pixelStride, int scanlineStride, int[] bankIndices, int[] bandOffsets) {
        super(dataType, w, h, bandOffsets.length);
        if (pixelStride < 0) {
            throw new IllegalArgumentException(Messages.getString("awt.24B"));
        }
        if (scanlineStride < 0) {
            throw new IllegalArgumentException(Messages.getString("awt.24C"));
        }
        if (bankIndices.length != bandOffsets.length) {
            throw new IllegalArgumentException(Messages.getString("awt.24D"));
        }
        this.pixelStride = pixelStride;
        this.scanlineStride = scanlineStride;
        this.bandOffsets = (int[])bandOffsets.clone();
        this.bankIndices = (int[])bankIndices.clone();
        this.numBands = bandOffsets.length;
        int maxBank = 0;
        for (int i = 0; i < bankIndices.length; ++i) {
            if (bankIndices[i] < 0) {
                throw new IllegalArgumentException(Messages.getString("awt.24E", i));
            }
            if (bankIndices[i] <= maxBank) continue;
            maxBank = bankIndices[i];
        }
        this.numBanks = maxBank + 1;
    }

    public ComponentSampleModel(int dataType, int w, int h, int pixelStride, int scanlineStride, int[] bandOffsets) {
        super(dataType, w, h, bandOffsets.length);
        if (pixelStride < 0) {
            throw new IllegalArgumentException(Messages.getString("awt.24B"));
        }
        if (scanlineStride < 0) {
            throw new IllegalArgumentException(Messages.getString("awt.24C"));
        }
        this.pixelStride = pixelStride;
        this.scanlineStride = scanlineStride;
        this.bandOffsets = (int[])bandOffsets.clone();
        this.numBands = bandOffsets.length;
        this.numBanks = 1;
        this.bankIndices = new int[this.numBands];
        for (int i = 0; i < this.numBands; ++i) {
            this.bankIndices[i] = 0;
        }
    }

    @Override
    public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        switch (this.dataType) {
            case 0: {
                byte[] bdata = obj == null ? new byte[this.numBands] : (byte[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    bdata[i] = (byte)this.getSample(x, y, i, data);
                }
                obj = bdata;
                break;
            }
            case 1: 
            case 2: {
                short[] sdata = obj == null ? new short[this.numBands] : (short[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    sdata[i] = (short)this.getSample(x, y, i, data);
                }
                obj = sdata;
                break;
            }
            case 3: {
                int[] idata = obj == null ? new int[this.numBands] : (int[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    idata[i] = this.getSample(x, y, i, data);
                }
                obj = idata;
                break;
            }
            case 4: {
                float[] fdata = obj == null ? new float[this.numBands] : (float[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    fdata[i] = this.getSampleFloat(x, y, i, data);
                }
                obj = fdata;
                break;
            }
            case 5: {
                double[] ddata = obj == null ? new double[this.numBands] : (double[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    ddata[i] = this.getSampleDouble(x, y, i, data);
                }
                obj = ddata;
            }
        }
        return obj;
    }

    @Override
    public void setDataElements(int x, int y, Object obj, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        switch (this.dataType) {
            case 0: {
                byte[] barr = (byte[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    this.setSample(x, y, i, barr[i] & 0xFF, data);
                }
                break;
            }
            case 1: 
            case 2: {
                short[] sarr = (short[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    this.setSample(x, y, i, sarr[i] & 0xFFFF, data);
                }
                break;
            }
            case 3: {
                int[] iarr = (int[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    this.setSample(x, y, i, iarr[i], data);
                }
                break;
            }
            case 4: {
                float[] farr = (float[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    this.setSample(x, y, i, farr[i], data);
                }
                break;
            }
            case 5: {
                double[] darr = (double[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    this.setSample(x, y, i, darr[i], data);
                }
                break;
            }
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ComponentSampleModel)) {
            return false;
        }
        ComponentSampleModel model = (ComponentSampleModel)o;
        return this.width == model.width && this.height == model.height && this.numBands == model.numBands && this.dataType == model.dataType && Arrays.equals(this.bandOffsets, model.bandOffsets) && Arrays.equals(this.bankIndices, model.bankIndices) && this.numBands == model.numBands && this.numBanks == model.numBanks && this.scanlineStride == model.scanlineStride && this.pixelStride == model.pixelStride;
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] bands) {
        if (bands.length > this.numBands) {
            throw new RasterFormatException(Messages.getString("awt.64"));
        }
        int[] indices = new int[bands.length];
        int[] offsets = new int[bands.length];
        for (int i = 0; i < bands.length; ++i) {
            indices[i] = this.bankIndices[bands[i]];
            offsets[i] = this.bandOffsets[bands[i]];
        }
        return new ComponentSampleModel(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, indices, offsets);
    }

    @Override
    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new ComponentSampleModel(this.dataType, w, h, this.pixelStride, this.pixelStride * w, this.bankIndices, this.bandOffsets);
    }

    @Override
    public int[] getPixel(int x, int y, int[] iArray, DataBuffer data) {
        int[] pixel = iArray == null ? new int[this.numBands] : iArray;
        for (int i = 0; i < this.numBands; ++i) {
            pixel[i] = this.getSample(x, y, i, data);
        }
        return pixel;
    }

    @Override
    public void setPixel(int x, int y, int[] iArray, DataBuffer data) {
        for (int i = 0; i < this.numBands; ++i) {
            this.setSample(x, y, i, iArray[i], data);
        }
    }

    @Override
    public int getSample(int x, int y, int b, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        return data.getElem(this.bankIndices[b], y * this.scanlineStride + x * this.pixelStride + this.bandOffsets[b]);
    }

    @Override
    public float getSampleFloat(int x, int y, int b, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        return data.getElemFloat(this.bankIndices[b], y * this.scanlineStride + x * this.pixelStride + this.bandOffsets[b]);
    }

    @Override
    public double getSampleDouble(int x, int y, int b, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        return data.getElemDouble(this.bankIndices[b], y * this.scanlineStride + x * this.pixelStride + this.bandOffsets[b]);
    }

    @Override
    public int[] getPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || x > this.width || x + w > this.width || y > this.height || y + h > this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int[] pixels = null;
        int idx = 0;
        pixels = iArray == null ? new int[w * h * this.numBands] : iArray;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                for (int n = 0; n < this.numBands; ++n) {
                    pixels[idx++] = this.getSample(j, i, n, data);
                }
            }
        }
        return pixels;
    }

    @Override
    public void setPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int idx = 0;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                for (int n = 0; n < this.numBands; ++n) {
                    this.setSample(j, i, n, iArray[idx++], data);
                }
            }
        }
    }

    @Override
    public void setSample(int x, int y, int b, int s, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        data.setElem(this.bankIndices[b], y * this.scanlineStride + x * this.pixelStride + this.bandOffsets[b], s);
    }

    @Override
    public int[] getSamples(int x, int y, int w, int h, int b, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int idx = 0;
        int[] samples = iArray == null ? new int[w * h] : iArray;
        if (data == null) {
            throw new NullPointerException(Messages.getString("awt.295"));
        }
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                samples[idx++] = this.getSample(j, i, b, data);
            }
        }
        return samples;
    }

    @Override
    public void setSamples(int x, int y, int w, int h, int b, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int idx = 0;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                this.setSample(j, i, b, iArray[idx++], data);
            }
        }
    }

    @Override
    public void setSample(int x, int y, int b, float s, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        data.setElemFloat(this.bankIndices[b], y * this.scanlineStride + x * this.pixelStride + this.bandOffsets[b], s);
    }

    @Override
    public void setSample(int x, int y, int b, double s, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        data.setElemDouble(this.bankIndices[b], y * this.scanlineStride + x * this.pixelStride + this.bandOffsets[b], s);
    }

    @Override
    public DataBuffer createDataBuffer() {
        DataBuffer data = null;
        int maxOffset = this.bandOffsets[0];
        for (int i = 1; i < this.bandOffsets.length; ++i) {
            if (this.bandOffsets[i] <= maxOffset) continue;
            maxOffset = this.bandOffsets[i];
        }
        int size = (this.height - 1) * this.scanlineStride + (this.width - 1) * this.pixelStride + maxOffset + 1;
        switch (this.dataType) {
            case 0: {
                data = new DataBufferByte(size, this.numBanks);
                break;
            }
            case 2: {
                data = new DataBufferShort(size, this.numBanks);
                break;
            }
            case 1: {
                data = new DataBufferUShort(size, this.numBanks);
                break;
            }
            case 3: {
                data = new DataBufferInt(size, this.numBanks);
                break;
            }
            case 4: {
                data = new DataBufferFloat(size, this.numBanks);
                break;
            }
            case 5: {
                data = new DataBufferDouble(size, this.numBanks);
            }
        }
        return data;
    }

    public int getOffset(int x, int y, int b) {
        return y * this.scanlineStride + x * this.pixelStride + this.bandOffsets[b];
    }

    public int getOffset(int x, int y) {
        return y * this.scanlineStride + x * this.pixelStride + this.bandOffsets[0];
    }

    @Override
    public final int getSampleSize(int band) {
        return DataBuffer.getDataTypeSize(this.dataType);
    }

    @Override
    public final int[] getSampleSize() {
        int[] sampleSizes = new int[this.numBands];
        int size = DataBuffer.getDataTypeSize(this.dataType);
        for (int i = 0; i < this.numBands; ++i) {
            sampleSizes[i] = size;
        }
        return sampleSizes;
    }

    public final int[] getBankIndices() {
        return (int[])this.bankIndices.clone();
    }

    public final int[] getBandOffsets() {
        return (int[])this.bandOffsets.clone();
    }

    public int hashCode() {
        int hash = 0;
        int tmp = 0;
        hash = this.width;
        tmp = hash >>> 24;
        hash <<= 8;
        hash |= tmp;
        tmp = (hash ^= this.height) >>> 24;
        hash <<= 8;
        hash |= tmp;
        tmp = (hash ^= this.numBands) >>> 24;
        hash <<= 8;
        hash |= tmp;
        tmp = (hash ^= this.dataType) >>> 24;
        hash <<= 8;
        hash |= tmp;
        for (int element : this.bandOffsets) {
            tmp = (hash ^= element) >>> 24;
            hash <<= 8;
            hash |= tmp;
        }
        for (int element : this.bankIndices) {
            tmp = (hash ^= element) >>> 24;
            hash <<= 8;
            hash |= tmp;
        }
        tmp = (hash ^= this.pixelStride) >>> 24;
        hash <<= 8;
        hash |= tmp;
        return hash ^= this.scanlineStride;
    }

    public final int getScanlineStride() {
        return this.scanlineStride;
    }

    public final int getPixelStride() {
        return this.pixelStride;
    }

    @Override
    public final int getNumDataElements() {
        return this.numBands;
    }
}

