/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.harmony.awt.gl.color.LUTColorConverter;
import org.apache.harmony.awt.internal.nls.Messages;

public class ComponentColorModel
extends ColorModel {
    private boolean signed;
    private boolean integral;
    private float[] scaleFactors;
    private boolean donotSupportUnnormalized;
    private boolean needAlphaDivide;
    private boolean calcValue;
    private boolean needScale = false;
    private float[] minVals;
    private float[] ranges;
    private byte[] alphaLUT;
    private byte[][] colorLUTs;
    private byte[] from_LINEAR_RGB_LUT;
    private byte[] to_LINEAR_8RGB_LUT;
    private short[] to_LINEAR_16RGB_LUT;
    private int LINEAR_RGB_Length;
    private float fFactor;
    private boolean is_sRGB;
    private boolean is_LINEAR_RGB;

    public ComponentColorModel(ColorSpace colorSpace, int[] bits, boolean hasAlpha, boolean isAlphaPremultiplied, int transparency, int transferType) {
        super(ComponentColorModel.createPixelBits(colorSpace, hasAlpha, transferType), ComponentColorModel.validateBits(bits, colorSpace, hasAlpha, transferType), colorSpace, hasAlpha, isAlphaPremultiplied, transparency, transferType);
        switch (transferType) {
            case 0: 
            case 1: 
            case 3: {
                this.signed = false;
                this.integral = true;
                this.donotSupportUnnormalized = false;
                this.scaleFactors = new float[this.numComponents];
                for (int i = 0; i < this.numColorComponents; ++i) {
                    this.scaleFactors[i] = 1.0f / (float)this.maxValues[i];
                    if (this.cs.getMinValue(i) == 0.0f && this.cs.getMaxValue(i) == 1.0f) continue;
                    this.donotSupportUnnormalized = true;
                }
                if (!hasAlpha) break;
                this.maxValues[this.numColorComponents] = (1 << bits[this.numColorComponents]) - 1;
                this.scaleFactors[this.numColorComponents] = 1.0f / (float)this.maxValues[this.numColorComponents];
                break;
            }
            case 2: {
                int i;
                this.signed = true;
                this.integral = true;
                this.donotSupportUnnormalized = true;
                this.scaleFactors = new float[this.numComponents];
                for (i = 0; i < this.numComponents; ++i) {
                    this.maxValues[i] = Short.MAX_VALUE;
                    this.scaleFactors[i] = 1.0f / (float)this.maxValues[i];
                    if (this.cs.getMinValue(i) == 0.0f && this.cs.getMaxValue(i) == 1.0f) continue;
                    this.needScale = true;
                }
                if (!this.needScale) break;
                this.minVals = new float[this.numColorComponents];
                this.ranges = new float[this.numColorComponents];
                for (i = 0; i < this.numColorComponents; ++i) {
                    this.minVals[i] = this.cs.getMinValue(i);
                    this.ranges[i] = this.cs.getMaxValue(i) - this.minVals[i];
                }
                break;
            }
            case 4: 
            case 5: {
                this.signed = true;
                this.integral = false;
                this.donotSupportUnnormalized = true;
                break;
            }
            default: {
                throw new IllegalArgumentException(Messages.getString("awt.215"));
            }
        }
        this.needAlphaDivide = hasAlpha && isAlphaPremultiplied;
        this.initLUTs();
    }

    public ComponentColorModel(ColorSpace colorSpace, boolean hasAlpha, boolean isAlphaPremultiplied, int transparency, int transferType) {
        this(colorSpace, ComponentColorModel.createPixelBitsArray(colorSpace, hasAlpha, transferType), hasAlpha, isAlphaPremultiplied, transparency, transferType);
    }

    private static int[] validateBits(int[] bits, ColorSpace colorSpace, boolean hasAlpha, int transferType) {
        if (bits != null) {
            return bits;
        }
        int numComponents = colorSpace.getNumComponents();
        if (hasAlpha) {
            ++numComponents;
        }
        bits = new int[numComponents];
        int componentLength = DataBuffer.getDataTypeSize(transferType);
        for (int i = 0; i < numComponents; ++i) {
            bits[i] = componentLength;
        }
        return bits;
    }

    private static int createPixelBits(ColorSpace colorSpace, boolean hasAlpha, int transferType) {
        int numComponents = colorSpace.getNumComponents();
        if (hasAlpha) {
            ++numComponents;
        }
        int componentLength = DataBuffer.getDataTypeSize(transferType);
        return numComponents * componentLength;
    }

    private static int[] createPixelBitsArray(ColorSpace colorSpace, boolean hasAlpha, int transferType) {
        int numComponents = colorSpace.getNumComponents();
        if (hasAlpha) {
            ++numComponents;
        }
        int[] bits = new int[numComponents];
        for (int i = 0; i < numComponents; ++i) {
            bits[i] = DataBuffer.getDataTypeSize(transferType);
        }
        return bits;
    }

    @Override
    public Object getDataElements(int[] components, int offset, Object obj) {
        if (this.donotSupportUnnormalized) {
            throw new IllegalArgumentException(Messages.getString("awt.213"));
        }
        if (offset + this.numComponents > components.length) {
            throw new IllegalArgumentException(Messages.getString("awt.216"));
        }
        switch (this.transferType) {
            case 0: {
                byte[] ba = obj == null ? new byte[this.numComponents] : (byte[])obj;
                int i = 0;
                int idx = offset;
                while (i < this.numComponents) {
                    ba[i] = (byte)components[idx];
                    ++i;
                    ++idx;
                }
                return ba;
            }
            case 1: {
                short[] sa = obj == null ? new short[this.numComponents] : (short[])obj;
                int i = 0;
                int idx = offset;
                while (i < this.numComponents) {
                    sa[i] = (short)components[idx];
                    ++i;
                    ++idx;
                }
                return sa;
            }
            case 3: {
                int[] ia = obj == null ? new int[this.numComponents] : (int[])obj;
                int i = 0;
                int idx = offset;
                while (i < this.numComponents) {
                    ia[i] = components[idx];
                    ++i;
                    ++idx;
                }
                return ia;
            }
        }
        throw new UnsupportedOperationException(Messages.getString("awt.217"));
    }

    @Override
    public Object getDataElements(float[] normComponents, int normOffset, Object obj) {
        if (this.needScale) {
            int i = 0;
            int idx = 0;
            while (i < this.numColorComponents) {
                normComponents[idx] = (normComponents[idx] - this.minVals[i]) / this.ranges[i];
                ++i;
                ++idx;
            }
        }
        switch (this.transferType) {
            case 0: {
                byte[] ba = obj == null ? new byte[this.numComponents] : (byte[])obj;
                if (this.needAlphaDivide) {
                    float alpha = normComponents[normOffset + this.numColorComponents];
                    int i = 0;
                    int idx = normOffset;
                    while (i < this.numColorComponents) {
                        ba[i] = (byte)(normComponents[idx] * alpha * (float)this.maxValues[i] + 0.5f);
                        ++i;
                        ++idx;
                    }
                    ba[this.numColorComponents] = (byte)(normComponents[normOffset + this.numColorComponents] * (float)this.maxValues[this.numColorComponents] + 0.5f);
                } else {
                    int i = 0;
                    int idx = normOffset;
                    while (i < this.numComponents) {
                        ba[idx] = (byte)(normComponents[idx] * (float)this.maxValues[i] + 0.5f);
                        ++i;
                        ++idx;
                    }
                }
                return ba;
            }
            case 1: {
                short[] usa = obj == null ? new short[this.numComponents] : (short[])obj;
                if (this.needAlphaDivide) {
                    float alpha = normComponents[normOffset + this.numColorComponents];
                    int i = 0;
                    int idx = 0;
                    while (i < this.numColorComponents) {
                        usa[i] = (short)(normComponents[idx] * alpha * (float)this.maxValues[i] + 0.5f);
                        ++i;
                        ++idx;
                    }
                    usa[this.numColorComponents] = (short)(alpha * (float)this.maxValues[this.numColorComponents] + 0.5f);
                } else {
                    int i = 0;
                    int idx = normOffset;
                    while (i < this.numComponents) {
                        usa[i] = (short)(normComponents[idx] * (float)this.maxValues[i] + 0.5f);
                        ++i;
                        ++idx;
                    }
                }
                return usa;
            }
            case 3: {
                int[] ia = obj == null ? new int[this.numComponents] : (int[])obj;
                if (this.needAlphaDivide) {
                    float alpha = normComponents[normOffset + this.numColorComponents];
                    int i = 0;
                    int idx = 0;
                    while (i < this.numColorComponents) {
                        ia[i] = (int)(normComponents[idx] * alpha * (float)this.maxValues[i] + 0.5f);
                        ++i;
                        ++idx;
                    }
                    ia[this.numColorComponents] = (int)(alpha * (float)this.maxValues[this.numColorComponents] + 0.5f);
                } else {
                    int i = 0;
                    int idx = normOffset;
                    while (i < this.numComponents) {
                        ia[i] = (int)(normComponents[idx] * (float)this.maxValues[i] + 0.5f);
                        ++i;
                        ++idx;
                    }
                }
                return ia;
            }
            case 2: {
                short[] sa = obj == null ? new short[this.numComponents] : (short[])obj;
                if (this.needAlphaDivide) {
                    float alpha = normComponents[normOffset + this.numColorComponents];
                    int i = 0;
                    int idx = 0;
                    while (i < this.numColorComponents) {
                        sa[i] = (short)(normComponents[idx] * alpha * (float)this.maxValues[i] + 0.5f);
                        ++i;
                        ++idx;
                    }
                    sa[this.numColorComponents] = (short)(alpha * (float)this.maxValues[this.numColorComponents] + 0.5f);
                } else {
                    int i = 0;
                    int idx = normOffset;
                    while (i < this.numComponents) {
                        sa[i] = (short)(normComponents[idx] * (float)this.maxValues[i] + 0.5f);
                        ++i;
                        ++idx;
                    }
                }
                return sa;
            }
            case 4: {
                float[] fa = obj == null ? new float[this.numComponents] : (float[])obj;
                if (this.needAlphaDivide) {
                    float alpha = normComponents[normOffset + this.numColorComponents];
                    int i = 0;
                    int idx = 0;
                    while (i < this.numColorComponents) {
                        fa[i] = normComponents[idx] * alpha;
                        ++i;
                        ++idx;
                    }
                    fa[this.numColorComponents] = alpha;
                } else {
                    int i = 0;
                    int idx = normOffset;
                    while (i < this.numComponents) {
                        fa[i] = normComponents[idx];
                        ++i;
                        ++idx;
                    }
                }
                return fa;
            }
            case 5: {
                double[] da = obj == null ? new double[this.numComponents] : (double[])obj;
                if (this.needAlphaDivide) {
                    double alpha = normComponents[normOffset + this.numColorComponents];
                    int i = 0;
                    int idx = 0;
                    while (i < this.numColorComponents) {
                        da[i] = (double)normComponents[idx] * alpha;
                        ++i;
                        ++idx;
                    }
                    da[this.numColorComponents] = alpha;
                } else {
                    int i = 0;
                    int idx = normOffset;
                    while (i < this.numComponents) {
                        da[i] = normComponents[idx];
                        ++i;
                        ++idx;
                    }
                }
                return da;
            }
        }
        throw new IllegalArgumentException(Messages.getString("awt.213"));
    }

    @Override
    public Object getDataElements(int rgb, Object pixel) {
        float[] normComp;
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        int alpha = rgb >> 24 & 0xFF;
        float[] comp = new float[3];
        if (this.is_sRGB || this.is_LINEAR_RGB) {
            if (this.is_LINEAR_RGB) {
                if (this.LINEAR_RGB_Length == 8) {
                    red = this.to_LINEAR_8RGB_LUT[red] & 0xFF;
                    green = this.to_LINEAR_8RGB_LUT[green] & 0xFF;
                    blue = this.to_LINEAR_8RGB_LUT[blue] & 0xFF;
                } else {
                    red = this.to_LINEAR_16RGB_LUT[red] & 0xFFFF;
                    green = this.to_LINEAR_16RGB_LUT[green] & 0xFFFF;
                    blue = this.to_LINEAR_16RGB_LUT[blue] & 0xFFFF;
                }
            }
            comp[0] = (float)red / this.fFactor;
            comp[1] = (float)green / this.fFactor;
            comp[2] = (float)blue / this.fFactor;
            if (!this.hasAlpha) {
                normComp = comp;
            } else {
                float normAlpha = (float)alpha / 255.0f;
                normComp = new float[this.numComponents];
                for (int i = 0; i < this.numColorComponents; ++i) {
                    normComp[i] = comp[i];
                }
                normComp[this.numColorComponents] = normAlpha;
            }
        } else {
            comp[0] = (float)red / this.fFactor;
            comp[1] = (float)green / this.fFactor;
            comp[2] = (float)blue / this.fFactor;
            float[] defComp = this.cs.fromRGB(comp);
            if (!this.hasAlpha) {
                normComp = defComp;
            } else {
                float normAlpha = (float)alpha / 255.0f;
                normComp = new float[this.numComponents];
                for (int i = 0; i < this.numColorComponents; ++i) {
                    normComp[i] = defComp[i];
                }
                normComp[this.numColorComponents] = normAlpha;
            }
        }
        if (this.hasAlpha && this.isAlphaPremultiplied) {
            normComp[0] = normComp[0] * normComp[this.numColorComponents];
            normComp[1] = normComp[1] * normComp[this.numColorComponents];
            normComp[2] = normComp[2] * normComp[this.numColorComponents];
        }
        return this.getDataElements(normComp, 0, pixel);
    }

    @Override
    public WritableRaster getAlphaRaster(WritableRaster raster) {
        if (!this.hasAlpha) {
            return null;
        }
        int x = raster.getMinX();
        int y = raster.getMinY();
        int[] bandList = new int[]{raster.getNumBands() - 1};
        return raster.createWritableChild(x, y, raster.getWidth(), raster.getHeight(), x, y, bandList);
    }

    @Override
    public ColorModel coerceData(WritableRaster raster, boolean isAlphaPremultiplied) {
        block55: {
            int h;
            int w;
            int minY;
            int minX;
            block54: {
                if (!this.hasAlpha || this.isAlphaPremultiplied == isAlphaPremultiplied) {
                    return this;
                }
                minX = raster.getMinX();
                minY = raster.getMinY();
                w = raster.getWidth();
                h = raster.getHeight();
                if (!isAlphaPremultiplied) break block54;
                switch (this.transferType) {
                    case 0: 
                    case 1: 
                    case 3: {
                        float alphaFactor = this.maxValues[this.numColorComponents];
                        int[] iComponents = null;
                        int[] iTransparentComponents = new int[this.numComponents];
                        int i = 0;
                        while (i < h) {
                            int j = 0;
                            int x = minX;
                            while (j < w) {
                                if ((iComponents = raster.getPixel(x, minY, iComponents))[this.numColorComponents] == 0) {
                                    raster.setPixel(x, minY, iTransparentComponents);
                                } else {
                                    float alpha = (float)iComponents[this.numColorComponents] / alphaFactor;
                                    for (int n = 0; n < this.numColorComponents; ++n) {
                                        iComponents[n] = (int)(alpha * (float)iComponents[n] + 0.5f);
                                    }
                                    raster.setPixel(x, minY, iComponents);
                                }
                                ++j;
                                ++x;
                            }
                            ++i;
                            ++minY;
                        }
                        break block55;
                    }
                    case 2: {
                        float sAlphaFactor = this.maxValues[this.numColorComponents];
                        short[] sComponents = null;
                        short[] sTransparentComponents = new short[this.numComponents];
                        int i = 0;
                        while (i < h) {
                            int j = 0;
                            int x = minX;
                            while (j < w) {
                                if ((sComponents = (short[])raster.getDataElements(x, minY, sComponents))[this.numColorComponents] == 0) {
                                    raster.setDataElements(x, minY, sTransparentComponents);
                                } else {
                                    float alpha = (float)sComponents[this.numColorComponents] / sAlphaFactor;
                                    for (int n = 0; n < this.numColorComponents; ++n) {
                                        sComponents[n] = (byte)(alpha * (float)sComponents[n] + 0.5f);
                                    }
                                    raster.setDataElements(x, minY, sComponents);
                                }
                                ++j;
                                ++x;
                            }
                            ++i;
                            ++minY;
                        }
                        break block55;
                    }
                    case 4: {
                        float[] fComponents = null;
                        float[] fTransparentComponents = new float[this.numComponents];
                        int i = 0;
                        while (i < h) {
                            int j = 0;
                            int x = minX;
                            while (j < w) {
                                if ((fComponents = raster.getPixel(x, minY, fComponents))[this.numColorComponents] == 0.0f) {
                                    raster.setDataElements(x, minY, fTransparentComponents);
                                } else {
                                    float alpha = fComponents[this.numColorComponents];
                                    for (int n = 0; n < this.numColorComponents; ++n) {
                                        fComponents[n] = fComponents[n] * alpha;
                                    }
                                    raster.setPixel(x, minY, fComponents);
                                }
                                ++j;
                                ++x;
                            }
                            ++i;
                            ++minY;
                        }
                        break block55;
                    }
                    case 5: {
                        double[] dComponents = null;
                        double[] dTransparentComponents = new double[this.numComponents];
                        int i = 0;
                        while (i < h) {
                            int j = 0;
                            int x = minX;
                            while (j < w) {
                                if ((dComponents = raster.getPixel(x, minY, dComponents))[this.numColorComponents] == 0.0) {
                                    raster.setPixel(x, minY, dTransparentComponents);
                                } else {
                                    double alpha = dComponents[this.numColorComponents];
                                    for (int n = 0; n < this.numColorComponents; ++n) {
                                        dComponents[n] = dComponents[n] * alpha;
                                    }
                                    raster.setPixel(x, minY, dComponents);
                                }
                                ++j;
                                ++x;
                            }
                            ++i;
                            ++minY;
                        }
                        break block55;
                    }
                    default: {
                        throw new UnsupportedOperationException(Messages.getString("awt.219"));
                    }
                }
            }
            switch (this.transferType) {
                case 0: 
                case 1: 
                case 3: {
                    float alphaFactor = this.maxValues[this.numColorComponents];
                    int[] iComponents = null;
                    int[] iTransparentComponents = new int[this.numComponents];
                    int i = 0;
                    while (i < h) {
                        int j = 0;
                        int x = minX;
                        while (j < w) {
                            if ((iComponents = raster.getPixel(x, minY, iComponents))[this.numColorComponents] == 0) {
                                raster.setPixel(x, minY, iTransparentComponents);
                            } else {
                                float alpha = (float)iComponents[this.numColorComponents] / alphaFactor;
                                for (int n = 0; n < this.numColorComponents; ++n) {
                                    iComponents[n] = (int)((float)iComponents[n] / alpha + 0.5f);
                                }
                                raster.setPixel(x, minY, iComponents);
                            }
                            ++j;
                            ++x;
                        }
                        ++i;
                        ++minY;
                    }
                    break;
                }
                case 2: {
                    float sAlphaFactor = this.maxValues[this.numColorComponents];
                    short[] sComponents = null;
                    short[] sTransparentComponents = new short[this.numComponents];
                    int i = 0;
                    while (i < h) {
                        int j = 0;
                        int x = minX;
                        while (j < w) {
                            if ((sComponents = (short[])raster.getDataElements(x, minY, sComponents))[this.numColorComponents] == 0) {
                                raster.setDataElements(x, minY, sTransparentComponents);
                            } else {
                                float alpha = (float)sComponents[this.numColorComponents] / sAlphaFactor;
                                for (int n = 0; n < this.numColorComponents; ++n) {
                                    sComponents[n] = (byte)((float)sComponents[n] / alpha + 0.5f);
                                }
                                raster.setDataElements(x, minY, sComponents);
                            }
                            ++j;
                            ++x;
                        }
                        ++i;
                        ++minY;
                    }
                    break;
                }
                case 4: {
                    float[] fComponents = null;
                    float[] fTransparentComponents = new float[this.numComponents];
                    int i = 0;
                    while (i < h) {
                        int j = 0;
                        int x = minX;
                        while (j < w) {
                            if ((fComponents = raster.getPixel(x, minY, fComponents))[this.numColorComponents] == 0.0f) {
                                raster.setDataElements(x, minY, fTransparentComponents);
                            } else {
                                float alpha = fComponents[this.numColorComponents];
                                for (int n = 0; n < this.numColorComponents; ++n) {
                                    fComponents[n] = fComponents[n] / alpha;
                                }
                                raster.setPixel(x, minY, fComponents);
                            }
                            ++j;
                            ++x;
                        }
                        ++i;
                        ++minY;
                    }
                    break;
                }
                case 5: {
                    double[] dComponents = null;
                    double[] dTransparentComponents = new double[this.numComponents];
                    int i = 0;
                    while (i < h) {
                        int j = 0;
                        int x = minX;
                        while (j < w) {
                            if ((dComponents = raster.getPixel(x, minY, dComponents))[this.numColorComponents] == 0.0) {
                                raster.setPixel(x, minY, dTransparentComponents);
                            } else {
                                double alpha = dComponents[this.numColorComponents];
                                for (int n = 0; n < this.numColorComponents; ++n) {
                                    dComponents[n] = dComponents[n] / alpha;
                                }
                                raster.setPixel(x, minY, dComponents);
                            }
                            ++j;
                            ++x;
                        }
                        ++i;
                        ++minY;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(Messages.getString("awt.219"));
                }
            }
        }
        if (!this.signed) {
            return new ComponentColorModel(this.cs, this.bits, this.hasAlpha, isAlphaPremultiplied, this.transparency, this.transferType);
        }
        return new ComponentColorModel(this.cs, null, this.hasAlpha, isAlphaPremultiplied, this.transparency, this.transferType);
    }

    @Override
    public int[] getComponents(Object pixel, int[] components, int offset) {
        if (this.donotSupportUnnormalized) {
            throw new IllegalArgumentException(Messages.getString("awt.213"));
        }
        if (components == null) {
            components = new int[offset + this.numComponents];
        } else if (offset + this.numComponents > components.length) {
            throw new IllegalArgumentException(Messages.getString("awt.218"));
        }
        switch (this.transferType) {
            case 0: {
                byte[] ba = (byte[])pixel;
                int i = 0;
                int idx = offset;
                while (i < this.numComponents) {
                    components[idx] = ba[i] & 0xFF;
                    ++i;
                    ++idx;
                }
                return components;
            }
            case 1: {
                short[] sa = (short[])pixel;
                int i = 0;
                int idx = offset;
                while (i < this.numComponents) {
                    components[idx] = sa[i] & 0xFFFF;
                    ++i;
                    ++idx;
                }
                return components;
            }
            case 3: {
                int[] ia = (int[])pixel;
                int i = 0;
                int idx = offset;
                while (i < this.numComponents) {
                    components[idx] = ia[i];
                    ++i;
                    ++idx;
                }
                return components;
            }
        }
        throw new UnsupportedOperationException(Messages.getString("awt.217"));
    }

    @Override
    public float[] getNormalizedComponents(Object pixel, float[] normComponents, int normOffset) {
        int i;
        if (normComponents == null) {
            normComponents = new float[this.numComponents + normOffset];
        }
        switch (this.transferType) {
            case 0: {
                byte[] ba = (byte[])pixel;
                i = 0;
                int idx = normOffset;
                while (i < this.numComponents) {
                    normComponents[idx] = (float)(ba[i] & 0xFF) * this.scaleFactors[i];
                    ++i;
                    ++idx;
                }
                break;
            }
            case 1: {
                short[] usa = (short[])pixel;
                int i2 = 0;
                int idx = normOffset;
                while (i2 < this.numComponents) {
                    normComponents[idx] = (float)(usa[i2] & 0xFFFF) * this.scaleFactors[i2];
                    ++i2;
                    ++idx;
                }
                break;
            }
            case 3: {
                int[] ia = (int[])pixel;
                int i3 = 0;
                int idx = normOffset;
                while (i3 < this.numComponents) {
                    normComponents[idx] = (float)ia[i3] * this.scaleFactors[i3];
                    ++i3;
                    ++idx;
                }
                break;
            }
            case 2: {
                short[] sa = (short[])pixel;
                int i4 = 0;
                int idx = normOffset;
                while (i4 < this.numComponents) {
                    normComponents[idx] = (float)sa[i4] * this.scaleFactors[i4];
                    ++i4;
                    ++idx;
                }
                break;
            }
            case 4: {
                float[] fa = (float[])pixel;
                int i5 = 0;
                int idx = normOffset;
                while (i5 < this.numComponents) {
                    normComponents[idx] = fa[i5];
                    ++i5;
                    ++idx;
                }
                break;
            }
            case 5: {
                double[] da = (double[])pixel;
                int i6 = 0;
                int idx = normOffset;
                while (i6 < this.numComponents) {
                    normComponents[idx] = (float)da[i6];
                    ++i6;
                    ++idx;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(Messages.getString("awt.21A"));
            }
        }
        if (this.needAlphaDivide) {
            float alpha = normComponents[normOffset + this.numColorComponents];
            int idx = normOffset;
            for (i = 0; i < this.numColorComponents; ++i) {
                int n = idx++;
                normComponents[n] = normComponents[n] / alpha;
            }
        }
        if (this.needScale) {
            int i7 = 0;
            int idx = normOffset;
            while (i7 < this.numColorComponents) {
                normComponents[idx] = this.minVals[i7] + this.ranges[i7] * normComponents[idx];
                ++i7;
                ++idx;
            }
        }
        return normComponents;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ComponentColorModel)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int getRed(Object inData) {
        return this.getRGBComponent(inData, 0);
    }

    @Override
    public int getRGB(Object inData) {
        int alpha = this.getAlpha(inData);
        if (this.cs.getType() == 6) {
            int gray = this.getRed(inData);
            return alpha << 24 | gray << 16 | gray << 8 | gray;
        }
        return alpha << 24 | this.getRed(inData) << 16 | this.getGreen(inData) << 8 | this.getBlue(inData);
    }

    @Override
    public int getGreen(Object inData) {
        return this.getRGBComponent(inData, 1);
    }

    @Override
    public int getBlue(Object inData) {
        return this.getRGBComponent(inData, 2);
    }

    @Override
    public int getAlpha(Object inData) {
        if (!this.hasAlpha) {
            return 255;
        }
        int alpha = 0;
        switch (this.transferType) {
            case 0: {
                byte[] ba = (byte[])inData;
                alpha = ba[this.numColorComponents] & 0xFF;
                if (this.bits[this.numColorComponents] != 8) {
                    return this.alphaLUT[alpha] & 0xFF;
                }
                return alpha;
            }
            case 1: {
                short[] usa = (short[])inData;
                alpha = usa[this.numColorComponents] & 0xFFFF;
                if (this.bits[this.numColorComponents] != 8) {
                    return this.alphaLUT[alpha] & 0xFF;
                }
                return alpha;
            }
            case 3: {
                int[] ia = (int[])inData;
                alpha = ia[this.numColorComponents];
                if (this.bits[this.numColorComponents] != 8) {
                    return this.alphaLUT[alpha] & 0xFF;
                }
                return alpha;
            }
            case 2: {
                short[] sa = (short[])inData;
                alpha = sa[this.numColorComponents];
                if (this.bits[this.numColorComponents] != 8) {
                    return this.alphaLUT[alpha] & 0xFF;
                }
                return alpha;
            }
            case 4: {
                float[] fa = (float[])inData;
                return (int)(fa[this.numColorComponents] * 255.0f + 0.5f);
            }
            case 5: {
                double[] da = (double[])inData;
                return (int)(da[this.numColorComponents] * 255.0 + 0.5);
            }
        }
        throw new UnsupportedOperationException(Messages.getString("awt.214"));
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        SampleModel sm = this.createCompatibleSampleModel(w, h);
        DataBuffer db = sm.createDataBuffer();
        return Raster.createWritableRaster(sm, db, null);
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sm) {
        if (!(sm instanceof ComponentSampleModel)) {
            return false;
        }
        if (this.numComponents != sm.getNumBands()) {
            return false;
        }
        return this.transferType == sm.getTransferType();
    }

    @Override
    public SampleModel createCompatibleSampleModel(int w, int h) {
        int[] bandOffsets = new int[this.numComponents];
        for (int i = 0; i < this.numComponents; ++i) {
            bandOffsets[i] = i;
        }
        switch (this.transferType) {
            case 0: 
            case 1: {
                return new PixelInterleavedSampleModel(this.transferType, w, h, this.numComponents, w * this.numComponents, bandOffsets);
            }
        }
        return new ComponentSampleModel(this.transferType, w, h, this.numComponents, w * this.numComponents, bandOffsets);
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        SampleModel sm = raster.getSampleModel();
        if (!(sm instanceof ComponentSampleModel)) {
            return false;
        }
        if (sm.getNumBands() != this.numComponents) {
            return false;
        }
        if (raster.getTransferType() != this.transferType) {
            return false;
        }
        int[] sampleSizes = sm.getSampleSize();
        for (int i = 0; i < this.numComponents; ++i) {
            if (this.bits[i] == sampleSizes[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public float[] getNormalizedComponents(int[] components, int offset, float[] normComponents, int normOffset) {
        if (this.donotSupportUnnormalized) {
            throw new IllegalArgumentException(Messages.getString("awt.213"));
        }
        return super.getNormalizedComponents(components, offset, normComponents, normOffset);
    }

    @Override
    public int getDataElement(int[] components, int offset) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException(Messages.getString("awt.212"));
        }
        if (this.donotSupportUnnormalized) {
            throw new IllegalArgumentException(Messages.getString("awt.213"));
        }
        return components[offset];
    }

    @Override
    public int[] getUnnormalizedComponents(float[] normComponents, int normOffset, int[] components, int offset) {
        if (this.donotSupportUnnormalized) {
            throw new IllegalArgumentException(Messages.getString("awt.213"));
        }
        if (normComponents.length - normOffset < this.numComponents) {
            throw new IllegalArgumentException(Messages.getString("awt.21B"));
        }
        return super.getUnnormalizedComponents(normComponents, normOffset, components, offset);
    }

    @Override
    public int getDataElement(float[] normComponents, int normOffset) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException(Messages.getString("awt.212"));
        }
        if (this.signed) {
            throw new IllegalArgumentException(Messages.getString("awt.210"));
        }
        Object pixel = this.getDataElements(normComponents, normOffset, null);
        switch (this.transferType) {
            case 0: {
                byte[] ba = (byte[])pixel;
                return ba[0] & 0xFF;
            }
            case 1: {
                short[] sa = (short[])pixel;
                return sa[0] & 0xFFFF;
            }
            case 3: {
                int[] ia = (int[])pixel;
                return ia[0];
            }
        }
        throw new IllegalArgumentException(Messages.getString("awt.211"));
    }

    @Override
    public int[] getComponents(int pixel, int[] components, int offset) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException(Messages.getString("awt.212"));
        }
        if (this.donotSupportUnnormalized) {
            throw new IllegalArgumentException(Messages.getString("awt.213"));
        }
        if (components == null) {
            components = new int[offset + 1];
        }
        components[offset] = pixel & this.maxValues[0];
        return components;
    }

    @Override
    public int getRed(int pixel) {
        float[] rgb = this.toRGB(pixel);
        return (int)(rgb[0] * 255.0f + 0.5f);
    }

    @Override
    public int getRGB(int pixel) {
        return this.getAlpha(pixel) << 24 | this.getRed(pixel) << 16 | this.getGreen(pixel) << 8 | this.getBlue(pixel);
    }

    @Override
    public int getGreen(int pixel) {
        float[] rgb = this.toRGB(pixel);
        return (int)(rgb[1] * 255.0f + 0.5f);
    }

    @Override
    public int getBlue(int pixel) {
        float[] rgb = this.toRGB(pixel);
        return (int)(rgb[2] * 255.0f + 0.5f);
    }

    @Override
    public int getAlpha(int pixel) {
        if (this.signed) {
            throw new IllegalArgumentException(Messages.getString("awt.210"));
        }
        if (this.numComponents > 1) {
            throw new IllegalArgumentException(Messages.getString("awt.212"));
        }
        return 255;
    }

    private void initLUTs() {
        int i;
        this.is_sRGB = this.cs.isCS_sRGB();
        boolean bl = this.is_LINEAR_RGB = this.cs == LUTColorConverter.LINEAR_RGB_CS;
        if (this.hasAlpha && this.bits[this.numColorComponents] != 8 && this.integral) {
            this.alphaLUT = new byte[this.maxValues[this.numColorComponents] + 1];
            for (i = 0; i <= this.maxValues[this.numColorComponents]; ++i) {
                this.alphaLUT[i] = (byte)(this.scaleFactors[this.numColorComponents] * (float)i + 0.5f);
            }
        }
        if (this.is_LINEAR_RGB) {
            if (this.maxBitLength > 8) {
                this.LINEAR_RGB_Length = 16;
                this.from_LINEAR_RGB_LUT = LUTColorConverter.getFrom16lRGBtosRGB_LUT();
                this.to_LINEAR_16RGB_LUT = LUTColorConverter.getFromsRGBto16lRGB_LUT();
            } else {
                this.LINEAR_RGB_Length = 8;
                this.from_LINEAR_RGB_LUT = LUTColorConverter.getFrom8lRGBtosRGB_LUT();
                this.to_LINEAR_8RGB_LUT = LUTColorConverter.getFromsRGBto8lRGB_LUT();
            }
            this.fFactor = (1 << this.LINEAR_RGB_Length) - 1;
        } else {
            this.fFactor = 255.0f;
        }
        if (!this.isAlphaPremultiplied && this.integral) {
            int j;
            this.colorLUTs = new byte[3][];
            if (this.is_sRGB) {
                for (i = 0; i < this.numColorComponents; ++i) {
                    if (this.bits[i] == 8) continue;
                    for (j = 0; j < i; ++j) {
                        if (this.bits[i] != this.bits[j]) continue;
                        this.colorLUTs[i] = this.colorLUTs[j];
                        break;
                    }
                    this.colorLUTs[i] = new byte[this.maxValues[i] + 1];
                    for (j = 0; j <= this.maxValues[0]; ++j) {
                        this.colorLUTs[i][j] = (byte)(this.scaleFactors[i] * (float)j + 0.5f);
                    }
                }
            }
            if (this.is_LINEAR_RGB) {
                for (i = 0; i < this.numColorComponents; ++i) {
                    if (this.bits[i] == this.LINEAR_RGB_Length) continue;
                    for (j = 0; j < i; ++j) {
                        if (this.bits[i] != this.bits[j]) continue;
                        this.colorLUTs[i] = this.colorLUTs[j];
                        break;
                    }
                    this.colorLUTs[i] = new byte[this.maxValues[i] + 1];
                    for (j = 0; j <= this.maxValues[0]; ++j) {
                        int idx = this.LINEAR_RGB_Length == 8 ? (int)(this.scaleFactors[i] * (float)j + 0.5f) : (int)(this.scaleFactors[i] * (float)j * 257.0f + 0.5f);
                        this.colorLUTs[i][j] = this.from_LINEAR_RGB_LUT[idx];
                    }
                }
            }
        }
    }

    private float[] toRGB(int pixel) {
        if (this.signed) {
            throw new IllegalArgumentException(Messages.getString("awt.210"));
        }
        if (this.numComponents > 1) {
            throw new IllegalArgumentException(Messages.getString("awt.212"));
        }
        Object[] obj = null;
        switch (this.transferType) {
            case 0: {
                byte[] ba = new byte[]{(byte)pixel};
                obj = ba;
                break;
            }
            case 1: {
                short[] sa = new short[]{(short)pixel};
                obj = sa;
                break;
            }
            case 3: {
                int[] ia = new int[]{pixel};
                obj = ia;
            }
        }
        return this.cs.toRGB(this.getNormalizedComponents(obj, null, 0));
    }

    private int getRGBComponent(Object pixel, int idx) {
        if (this.is_sRGB) {
            int comp = this.getDefComponent(pixel, idx);
            if (this.calcValue || this.bits[idx] == 8) {
                return comp;
            }
            return this.colorLUTs[idx][comp] & 0xFF;
        }
        if (this.is_LINEAR_RGB) {
            int comp = this.getDefComponent(pixel, idx);
            if (this.calcValue || this.bits[idx] == this.LINEAR_RGB_Length) {
                return this.from_LINEAR_RGB_LUT[comp] & 0xFF;
            }
            return this.colorLUTs[idx][comp] & 0xFF;
        }
        float[] normComp = this.getNormalizedComponents(pixel, null, 0);
        float[] rgbComp = this.cs.toRGB(normComp);
        return (int)(rgbComp[idx] * 255.0f + 0.5f);
    }

    private int getDefComponent(Object pixel, int idx) {
        int comp = 0;
        this.calcValue = false;
        switch (this.transferType) {
            case 0: {
                byte[] ba = (byte[])pixel;
                comp = ba[idx] & 0xFF;
                if (this.needAlphaDivide) {
                    int alpha = ba[this.numColorComponents] & 0xFF;
                    if (alpha == 0) {
                        comp = 0;
                    } else {
                        float normAlpha = this.scaleFactors[this.numColorComponents] * (float)alpha;
                        comp = (int)((float)comp * this.fFactor / normAlpha + 0.5f);
                    }
                    this.calcValue = true;
                }
                return comp;
            }
            case 1: {
                short[] usa = (short[])pixel;
                comp = usa[idx] & 0xFFFF;
                if (this.needAlphaDivide) {
                    int alpha = usa[this.numColorComponents] & 0xFFFF;
                    if (alpha == 0) {
                        comp = 0;
                    } else {
                        float normAlpha = this.scaleFactors[this.numColorComponents] * (float)alpha;
                        comp = (int)((float)comp * this.fFactor / normAlpha + 0.5f);
                    }
                    this.calcValue = true;
                }
                return comp;
            }
            case 3: {
                int[] ia = (int[])pixel;
                comp = ia[idx];
                if (this.needAlphaDivide) {
                    int alpha = ia[this.numColorComponents];
                    if (alpha == 0) {
                        comp = 0;
                    } else {
                        float normAlpha = this.scaleFactors[this.numColorComponents] * (float)alpha;
                        comp = (int)((float)comp * this.fFactor / normAlpha + 0.5f);
                    }
                    this.calcValue = true;
                }
                return comp;
            }
            case 2: {
                short[] sa = (short[])pixel;
                comp = sa[idx];
                if (this.needAlphaDivide) {
                    short alpha = sa[this.numColorComponents];
                    if (alpha == 0) {
                        comp = 0;
                    } else {
                        float normAlpha = this.scaleFactors[this.numColorComponents] * (float)alpha;
                        comp = (int)((float)comp * this.fFactor / normAlpha + 0.5f);
                    }
                    this.calcValue = true;
                }
                return comp;
            }
            case 4: {
                float[] fa = (float[])pixel;
                if (this.needAlphaDivide) {
                    float alpha = fa[this.numColorComponents];
                    comp = fa[this.numColorComponents] == 0.0f ? 0 : (int)(fa[idx] * this.fFactor / alpha + 0.5f);
                } else {
                    comp = (int)(fa[idx] * this.fFactor + 0.5f);
                }
                this.calcValue = true;
                return comp;
            }
            case 5: {
                double[] da = (double[])pixel;
                comp = this.needAlphaDivide ? (da[this.numColorComponents] == 0.0 ? 0 : (int)(da[idx] * (double)this.fFactor / da[this.numColorComponents] + 0.5)) : (int)(da[idx] * (double)this.fFactor + 0.5);
                this.calcValue = true;
                return comp;
            }
        }
        throw new UnsupportedOperationException(Messages.getString("awt.214"));
    }
}

