/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import org.apache.harmony.awt.gl.color.ColorConverter;
import org.apache.harmony.awt.gl.color.ColorScaler;
import org.apache.harmony.awt.gl.color.ICC_Transform;
import org.apache.harmony.awt.internal.nls.Messages;

public class ColorConvertOp
implements BufferedImageOp,
RasterOp {
    RenderingHints renderingHints;
    Object[] conversionSequence = new ICC_Profile[0];
    private ICC_Profile[] midProfiles;
    private final ColorConverter cc = new ColorConverter();
    private final ICC_TransfomCreator tCreator = new ICC_TransfomCreator();
    private boolean isICC = true;

    public ColorConvertOp(ColorSpace srcCS, ColorSpace dstCS, RenderingHints hints) {
        if (srcCS == null || dstCS == null) {
            throw new NullPointerException(Messages.getString("awt.25B"));
        }
        this.renderingHints = hints;
        boolean srcICC = srcCS instanceof ICC_ColorSpace;
        boolean dstICC = dstCS instanceof ICC_ColorSpace;
        if (srcICC && dstICC) {
            this.conversionSequence = new ICC_Profile[2];
        } else {
            this.conversionSequence = new Object[2];
            this.isICC = false;
        }
        this.conversionSequence[0] = srcICC ? ((ICC_ColorSpace)srcCS).getProfile() : srcCS;
        this.conversionSequence[1] = dstICC ? ((ICC_ColorSpace)dstCS).getProfile() : dstCS;
    }

    public ColorConvertOp(ICC_Profile[] profiles, RenderingHints hints) {
        if (profiles == null) {
            throw new NullPointerException(Messages.getString("awt.25C"));
        }
        this.renderingHints = hints;
        this.midProfiles = profiles;
        this.conversionSequence = new ICC_Profile[this.midProfiles.length];
        for (Object this.conversionSequence[i] : this.midProfiles) {
        }
    }

    public ColorConvertOp(ColorSpace cs, RenderingHints hints) {
        if (cs == null) {
            throw new NullPointerException(Messages.getString("awt.25B"));
        }
        this.renderingHints = hints;
        if (cs instanceof ICC_ColorSpace) {
            this.conversionSequence = new ICC_Profile[1];
            this.conversionSequence[0] = ((ICC_ColorSpace)cs).getProfile();
        } else {
            this.conversionSequence = new Object[1];
            this.conversionSequence[0] = cs;
            this.isICC = false;
        }
    }

    public ColorConvertOp(RenderingHints hints) {
        this.renderingHints = hints;
    }

    @Override
    public final WritableRaster filter(Raster src, WritableRaster dst) {
        int nDstColorComps;
        int nSrcColorComps;
        if (this.conversionSequence.length < 2) {
            throw new IllegalArgumentException(Messages.getString("awt.25D"));
        }
        ICC_Profile srcPf = null;
        ICC_Profile dstPf = null;
        Object first = this.conversionSequence[0];
        Object last = this.conversionSequence[this.conversionSequence.length - 1];
        if (this.isICC) {
            srcPf = (ICC_Profile)first;
            dstPf = (ICC_Profile)last;
            nSrcColorComps = srcPf.getNumComponents();
            nDstColorComps = dstPf.getNumComponents();
        } else {
            if (first instanceof ICC_Profile) {
                srcPf = (ICC_Profile)first;
                nSrcColorComps = srcPf.getNumComponents();
            } else {
                nSrcColorComps = ((ColorSpace)first).getNumComponents();
            }
            if (last instanceof ICC_Profile) {
                dstPf = (ICC_Profile)last;
                nDstColorComps = dstPf.getNumComponents();
            } else {
                nDstColorComps = ((ColorSpace)last).getNumComponents();
            }
        }
        if (src.getNumBands() != nSrcColorComps) {
            throw new IllegalArgumentException(Messages.getString("awt.25E"));
        }
        if (dst != null) {
            if (dst.getNumBands() != nDstColorComps) {
                throw new IllegalArgumentException(Messages.getString("awt.25F"));
            }
            if (src.getWidth() != dst.getWidth() || src.getHeight() != dst.getHeight()) {
                throw new IllegalArgumentException(Messages.getString("awt.260"));
            }
        } else {
            dst = this.createCompatibleDestRaster(src);
        }
        if (this.isICC) {
            ICC_Transform t = this.tCreator.getTransform(srcPf, dstPf, (ICC_Profile[])this.conversionSequence);
            this.cc.translateColor(t, src, dst);
        } else {
            Object[] sequence = this.tCreator.getSequence(null, null);
            ColorScaler scaler = new ColorScaler();
            scaler.loadScalingData(src, null);
            float[][] tmpData = scaler.scaleNormalize(src);
            ColorSpace srcCS = srcPf == null ? (ColorSpace)first : new ICC_ColorSpace(srcPf);
            ColorSpace dstCS = dstPf == null ? (ColorSpace)last : new ICC_ColorSpace(dstPf);
            this.applySequence(sequence, tmpData, srcCS, dstCS);
            scaler.loadScalingData(dst, null);
            scaler.unscaleNormalized(dst, tmpData);
        }
        return dst;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        if (destCM != null) {
            return new BufferedImage(destCM, destCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight()), destCM.isAlphaPremultiplied(), null);
        }
        int nSpaces = this.conversionSequence.length;
        if (nSpaces < 1) {
            throw new IllegalArgumentException(Messages.getString("awt.261"));
        }
        Object destination = this.conversionSequence[nSpaces - 1];
        ColorSpace dstCS = destination instanceof ColorSpace ? (ColorSpace)destination : new ICC_ColorSpace((ICC_Profile)destination);
        ColorModel srcCM = src.getColorModel();
        ComponentColorModel dstCM = new ComponentColorModel(dstCS, srcCM.hasAlpha(), srcCM.isAlphaPremultiplied(), srcCM.getTransparency(), srcCM.getTransferType());
        return new BufferedImage(dstCM, ((ColorModel)dstCM).createCompatibleWritableRaster(src.getWidth(), src.getHeight()), dstCM.isAlphaPremultiplied(), null);
    }

    @Override
    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        boolean isFullICC;
        BufferedImage res;
        if (dst == null && this.conversionSequence.length < 1) {
            throw new IllegalArgumentException(Messages.getString("awt.262"));
        }
        ColorModel srcCM = src.getColorModel();
        if (srcCM instanceof IndexColorModel) {
            src = ((IndexColorModel)srcCM).convertToIntDiscrete(src.getRaster(), false);
        }
        ColorSpace srcCS = srcCM.getColorSpace();
        boolean isDstIndex = false;
        if (dst != null) {
            if (src.getWidth() != dst.getWidth() || src.getHeight() != dst.getHeight()) {
                throw new IllegalArgumentException(Messages.getString("awt.263"));
            }
            if (dst.getColorModel() instanceof IndexColorModel) {
                isDstIndex = true;
                res = this.createCompatibleDestImage(src, null);
            } else {
                res = dst;
            }
        } else {
            res = this.createCompatibleDestImage(src, null);
        }
        ColorModel dstCM = res.getColorModel();
        ColorSpace dstCS = dstCM.getColorSpace();
        ICC_Profile srcPf = null;
        ICC_Profile dstPf = null;
        if (srcCS instanceof ICC_ColorSpace) {
            srcPf = ((ICC_ColorSpace)srcCS).getProfile();
        }
        if (dstCS instanceof ICC_ColorSpace) {
            dstPf = ((ICC_ColorSpace)dstCS).getProfile();
        }
        boolean bl = isFullICC = this.isICC && srcPf != null && dstPf != null;
        if (isFullICC) {
            ICC_Transform t = this.tCreator.getTransform(srcPf, dstPf, (ICC_Profile[])this.conversionSequence);
            this.cc.translateColor(t, src, res);
        } else {
            int i;
            Object[] sequence = this.tCreator.getSequence(srcPf == null ? srcCS : srcPf, dstPf == null ? dstCS : dstPf);
            int srcW = src.getWidth();
            int srcH = src.getHeight();
            int numPixels = srcW * srcH;
            float[][] tmpData = new float[numPixels][this.tCreator.maxComponents];
            int dataPos = 0;
            for (int row = 0; row < srcW; ++row) {
                for (int col = 0; col < srcH; ++col) {
                    tmpData[dataPos] = srcCM.getNormalizedComponents(src.getRaster().getDataElements(row, col, null), tmpData[dataPos], 0);
                    ++dataPos;
                }
            }
            float[] alpha = null;
            int alphaIdx = srcCM.numComponents - 1;
            if (srcCM.hasAlpha() && dstCM.hasAlpha()) {
                alpha = new float[numPixels];
                for (i = 0; i < numPixels; ++i) {
                    alpha[i] = tmpData[i][alphaIdx];
                }
            }
            this.applySequence(sequence, tmpData, srcCS, dstCS);
            if (dstCM.hasAlpha()) {
                alphaIdx = dstCM.numComponents - 1;
                if (alpha != null) {
                    for (i = 0; i < numPixels; ++i) {
                        tmpData[i][alphaIdx] = alpha[i];
                    }
                } else {
                    for (i = 0; i < numPixels; ++i) {
                        tmpData[i][alphaIdx] = 1.0f;
                    }
                }
            }
            int dataPos2 = 0;
            for (int row = 0; row < srcW; ++row) {
                for (int col = 0; col < srcH; ++col) {
                    res.getRaster().setDataElements(row, col, dstCM.getDataElements(tmpData[dataPos2++], 0, null));
                }
            }
        }
        if (isDstIndex) {
            Graphics2D g2d = dst.createGraphics();
            g2d.drawImage((Image)res, 0, 0, null);
            g2d.dispose();
            return dst;
        }
        return res;
    }

    private void applySequence(Object[] sequence, float[][] tmpData, ColorSpace srcCS, ColorSpace dstCS) {
        ICC_Transform t;
        ColorSpace xyzCS = ColorSpace.getInstance(1001);
        int numPixels = tmpData.length;
        if (sequence[0] instanceof ICC_Transform) {
            t = (ICC_Transform)sequence[0];
            this.cc.translateColor(t, tmpData, srcCS, xyzCS, numPixels);
        } else {
            for (int k = 0; k < numPixels; ++k) {
                tmpData[k] = srcCS.toCIEXYZ(tmpData[k]);
            }
            this.cc.loadScalingData(xyzCS);
        }
        for (Object element : sequence) {
            if (element instanceof ICC_Transform) {
                ICC_Transform t2 = (ICC_Transform)element;
                this.cc.translateColor(t2, tmpData, null, null, numPixels);
                continue;
            }
            ColorSpace cs = (ColorSpace)element;
            for (int k = 0; k < numPixels; ++k) {
                tmpData[k] = cs.fromCIEXYZ(tmpData[k]);
                tmpData[k] = cs.toCIEXYZ(tmpData[k]);
            }
        }
        if (sequence[sequence.length - 1] instanceof ICC_Transform) {
            t = (ICC_Transform)sequence[sequence.length - 1];
            this.cc.translateColor(t, tmpData, xyzCS, dstCS, numPixels);
        } else {
            for (int k = 0; k < numPixels; ++k) {
                tmpData[k] = dstCS.fromCIEXYZ(tmpData[k]);
            }
        }
    }

    @Override
    public final Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt != null) {
            dstPt.setLocation(srcPt);
            return dstPt;
        }
        return new Point2D.Float((float)srcPt.getX(), (float)srcPt.getY());
    }

    @Override
    public WritableRaster createCompatibleDestRaster(Raster src) {
        int nComps = 0;
        int nSpaces = this.conversionSequence.length;
        if (nSpaces < 2) {
            throw new IllegalArgumentException(Messages.getString("awt.261"));
        }
        Object lastCS = this.conversionSequence[nSpaces - 1];
        nComps = lastCS instanceof ColorSpace ? ((ColorSpace)lastCS).getNumComponents() : ((ICC_Profile)lastCS).getNumComponents();
        int dstDataType = src.getDataBuffer().getDataType();
        if (dstDataType != 0 && dstDataType != 2) {
            dstDataType = 2;
        }
        return Raster.createInterleavedRaster(dstDataType, src.getWidth(), src.getHeight(), nComps, new Point(src.getMinX(), src.getMinY()));
    }

    @Override
    public final Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    @Override
    public final Rectangle2D getBounds2D(BufferedImage src) {
        return src.getRaster().getBounds();
    }

    public final ICC_Profile[] getICC_Profiles() {
        if (this.midProfiles != null) {
            return this.midProfiles;
        }
        return null;
    }

    @Override
    public final RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    private class ICC_TransfomCreator {
        private ICC_Transform transform;
        private int maxComponents;

        private ICC_TransfomCreator() {
        }

        public ICC_Transform getTransform(ICC_Profile src, ICC_Profile dst, ICC_Profile[] convSeq) {
            ICC_Profile[] profiles;
            int nProfiles;
            if (this.transform != null && src == this.transform.getSrc() && dst == this.transform.getDst()) {
                return this.transform;
            }
            int length = convSeq.length;
            int srcFlg = 0;
            int dstFlg = 0;
            if ((length == 0 || src != convSeq[0]) && src != null) {
                srcFlg = 1;
            }
            if ((length == 0 || dst != convSeq[length - 1]) && dst != null) {
                dstFlg = 1;
            }
            if ((nProfiles = length + srcFlg + dstFlg) == length) {
                profiles = convSeq;
            } else {
                profiles = new ICC_Profile[nProfiles];
                int pos = 0;
                if (srcFlg != 0) {
                    profiles[pos++] = src;
                }
                for (int i = 0; i < length; ++i) {
                    profiles[pos++] = convSeq[i];
                }
                if (dstFlg != 0) {
                    profiles[pos++] = dst;
                }
            }
            this.transform = new ICC_Transform(profiles);
            return this.transform;
        }

        public Object[] getSequence(Object src, Object dst) {
            ArrayList<Object> profiles = new ArrayList<Object>(10);
            ArrayList<Object> sequence = new ArrayList<Object>(10);
            ICC_Profile xyzProfile = ICC_Profile.getInstance(1001);
            Object conversionFirst = null;
            Object conversionLast = null;
            int conversionLength = ColorConvertOp.this.conversionSequence.length;
            if (conversionLength > 0) {
                conversionFirst = ColorConvertOp.this.conversionSequence[0];
                conversionLast = ColorConvertOp.this.conversionSequence[conversionLength - 1];
            }
            boolean iccSequenceStarted = false;
            if (src != conversionFirst && src != null) {
                if (src instanceof ICC_Profile) {
                    profiles.add(src);
                    iccSequenceStarted = true;
                } else {
                    profiles.add(xyzProfile);
                    sequence.add(src);
                }
            } else {
                profiles.add(xyzProfile);
            }
            for (int i = 0; i < conversionLength; ++i) {
                if (ColorConvertOp.this.conversionSequence[i] instanceof ICC_Profile) {
                    profiles.add(ColorConvertOp.this.conversionSequence[i]);
                    iccSequenceStarted = true;
                    continue;
                }
                if (iccSequenceStarted) {
                    profiles.add(xyzProfile);
                    Object prev = profiles.get(0);
                    for (int k = 1; k < profiles.size(); ++k) {
                        if (prev == profiles.get(k)) {
                            profiles.remove(--k);
                        }
                        prev = profiles.get(k);
                    }
                    if (profiles.size() > 1) {
                        sequence.add(new ICC_Transform(profiles.toArray(new ICC_Profile[0])));
                        sequence.add(ColorConvertOp.this.conversionSequence[i]);
                    }
                    profiles.clear();
                    profiles.add(xyzProfile);
                    iccSequenceStarted = false;
                    continue;
                }
                sequence.add(ColorConvertOp.this.conversionSequence[i]);
            }
            if (dst != conversionLast && dst != null) {
                if (dst instanceof ICC_Profile) {
                    profiles.add(dst);
                    iccSequenceStarted = true;
                } else if (iccSequenceStarted) {
                    profiles.add(xyzProfile);
                } else {
                    sequence.add(dst);
                }
            }
            if (iccSequenceStarted) {
                sequence.add(new ICC_Transform(profiles.toArray(new ICC_Profile[0])));
                if (dst != null && !(dst instanceof ICC_Profile)) {
                    sequence.add(dst);
                }
            }
            this.maxComponents = 0;
            int size = sequence.size();
            for (int i = 0; i < size; ++i) {
                Object o = sequence.get(i);
                if (o instanceof ICC_Transform) {
                    ICC_Transform t = (ICC_Transform)o;
                    this.maxComponents = this.maxComponents > t.getNumInputChannels() + 1 ? this.maxComponents : t.getNumInputChannels() + 1;
                    this.maxComponents = this.maxComponents > t.getNumOutputChannels() + 1 ? this.maxComponents : t.getNumOutputChannels() + 1;
                    continue;
                }
                ColorSpace cs = (ColorSpace)o;
                this.maxComponents = this.maxComponents > cs.getNumComponents() + 1 ? this.maxComponents : cs.getNumComponents() + 1;
            }
            return sequence.toArray();
        }
    }
}

