/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageFilter;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.apache.harmony.awt.gl.AwtImageBackdoorAccessor;
import org.apache.harmony.awt.internal.nls.Messages;

public class BufferedImageFilter
extends ImageFilter
implements Cloneable {
    private static final AwtImageBackdoorAccessor accessor = AwtImageBackdoorAccessor.getInstance();
    private BufferedImageOp op;
    private WritableRaster raster;
    private int[] iData;
    private byte[] bData;
    private int width;
    private int height;
    private ColorModel cm;
    private boolean forcedRGB = false;
    private int transferType = 32;

    public BufferedImageFilter(BufferedImageOp op) {
        if (op == null) {
            throw new NullPointerException(Messages.getString("awt.05"));
        }
        this.op = op;
    }

    public BufferedImageOp getBufferedImageOp() {
        return this.op;
    }

    @Override
    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
        if (width <= 0 || height <= 0) {
            this.consumer.imageComplete(3);
            this.reset();
        }
    }

    @Override
    public void setColorModel(ColorModel model) {
        if (this.cm != null && this.cm != model && this.raster != null) {
            this.forceRGB();
        } else {
            this.cm = model;
        }
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        this.setPixels(x, y, w, h, model, pixels, off, scansize, true);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        this.setPixels(x, y, w, h, model, pixels, off, scansize, false);
    }

    @Override
    public void imageComplete(int status) {
        if (status == 3 || status == 2) {
            BufferedImage bim = new BufferedImage(this.cm, this.raster, this.cm.isAlphaPremultiplied, null);
            bim = this.op.filter(bim, null);
            DataBuffer dstDb = bim.getRaster().getDataBuffer();
            ColorModel dstCm = bim.getColorModel();
            int dstW = bim.getWidth();
            int dstH = bim.getHeight();
            this.consumer.setDimensions(dstW, dstH);
            if (dstDb.getDataType() == 3) {
                this.consumer.setColorModel(dstCm);
                this.consumer.setPixels(0, 0, dstW, dstH, dstCm, accessor.getDataInt(dstDb), 0, dstW);
            } else if (dstDb.getDataType() == 0) {
                this.consumer.setColorModel(dstCm);
                this.consumer.setPixels(0, 0, dstW, dstH, dstCm, accessor.getDataByte(dstDb), 0, dstW);
            } else {
                int[] dstData = bim.getRGB(0, 0, dstW, dstH, null, 0, dstW);
                dstCm = ColorModel.getRGBdefault();
                this.consumer.setColorModel(dstCm);
                this.consumer.setPixels(0, 0, dstW, dstH, dstCm, dstData, 0, dstW);
            }
        } else if (status == 1 || status == 4) {
            this.reset();
        }
        this.consumer.imageComplete(status);
    }

    private void setPixels(int x, int y, int w, int h, ColorModel model, Object pixels, int off, int scansize, boolean isByteData) {
        boolean canArraycopy;
        if (x < 0) {
            w -= x;
            off += x;
            x = 0;
        }
        if (y < 0) {
            h -= y;
            off += y * scansize;
            y = 0;
        }
        if (x + w > this.width) {
            w = this.width - x;
        }
        if (y + h > this.height) {
            h = this.height - y;
        }
        if (w <= 0 || h <= 0) {
            return;
        }
        if (this.cm == null) {
            this.setColorModel(model);
        } else if (model == null) {
            model = this.cm;
        } else if (!model.equals(this.cm)) {
            this.forceRGB();
        }
        switch (this.transferType) {
            case 32: {
                if (isByteData) {
                    this.transferType = 0;
                    this.createRaster(this.transferType);
                    canArraycopy = !this.forcedRGB;
                    break;
                }
                this.transferType = 3;
                this.createRaster(this.transferType);
                canArraycopy = !this.forcedRGB || model.equals(ColorModel.getRGBdefault());
                break;
            }
            case 3: {
                if (isByteData) {
                    this.forceRGB();
                    canArraycopy = false;
                    break;
                }
                if (!this.forcedRGB || model.equals(ColorModel.getRGBdefault())) {
                    canArraycopy = true;
                    break;
                }
            }
            case 0: {
                if (isByteData && !this.forcedRGB) {
                    canArraycopy = true;
                    break;
                }
                canArraycopy = false;
                break;
            }
            default: {
                throw new IllegalStateException(Messages.getString("awt.06"));
            }
        }
        int maxOffset = (off += x) + h * scansize;
        int dstOffset = x + y * this.width;
        if (canArraycopy) {
            Object[] dstArray;
            Object[] objectArray = dstArray = isByteData ? this.bData : (Object[])this.iData;
            while (off < maxOffset) {
                System.arraycopy(pixels, off, dstArray, dstOffset, w);
                off += scansize;
                dstOffset += this.width;
            }
        } else {
            while (off < maxOffset) {
                int srcPos = off;
                int dstPos = dstOffset;
                int maxDstPos = dstOffset + w;
                while (dstPos < maxDstPos) {
                    this.iData[dstPos] = model.getRGB(isByteData ? ((byte[])pixels)[srcPos] : ((int[])pixels)[srcPos]);
                    ++dstPos;
                    ++srcPos;
                }
                off += scansize;
                dstOffset += this.width;
            }
        }
    }

    private void forceRGB() {
        if (!this.forcedRGB) {
            int i;
            this.forcedRGB = true;
            int size = this.width * this.height;
            int[] rgbData = new int[size];
            if (this.bData != null) {
                for (i = 0; i < size; ++i) {
                    rgbData[i] = this.cm.getRGB(this.bData[i]);
                }
            } else if (this.iData != null) {
                for (i = 0; i < size; ++i) {
                    rgbData[i] = this.cm.getRGB(this.iData[i]);
                }
            }
            this.cm = ColorModel.getRGBdefault();
            DataBufferInt db = new DataBufferInt(rgbData, size);
            int[] masks = new int[]{0xFF0000, 65280, 255, -16777216};
            this.raster = Raster.createPackedRaster(db, this.width, this.height, this.width, masks, null);
            this.iData = accessor.getDataInt(db);
            this.bData = null;
            this.transferType = 3;
        }
    }

    private void reset() {
        this.width = 0;
        this.height = 0;
        this.forcedRGB = false;
        this.cm = null;
        this.iData = null;
        this.bData = null;
        this.transferType = 32;
        this.raster = null;
    }

    private void createRaster(int dataType) {
        boolean createdValidBuffer = false;
        try {
            this.raster = this.cm.createCompatibleWritableRaster(this.width, this.height);
            int rasterType = this.raster.getDataBuffer().getDataType();
            if (rasterType == dataType) {
                switch (rasterType) {
                    case 3: {
                        this.iData = accessor.getDataInt(this.raster.getDataBuffer());
                        if (this.iData == null) break;
                        createdValidBuffer = true;
                        break;
                    }
                    case 0: {
                        this.bData = accessor.getDataByte(this.raster.getDataBuffer());
                        if (this.bData == null) break;
                        createdValidBuffer = true;
                        break;
                    }
                    default: {
                        createdValidBuffer = false;
                    }
                }
                if (this.cm == ColorModel.getRGBdefault()) {
                    this.forcedRGB = true;
                }
            } else {
                createdValidBuffer = false;
            }
        }
        catch (Exception e) {
            createdValidBuffer = false;
        }
        if (!createdValidBuffer) {
            this.cm = ColorModel.getRGBdefault();
            this.raster = this.cm.createCompatibleWritableRaster(this.width, this.height);
            this.iData = accessor.getDataInt(this.raster.getDataBuffer());
            this.bData = null;
            this.forcedRGB = true;
        }
    }
}

