/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import org.apache.harmony.awt.internal.nls.Messages;

public final class BandedSampleModel
extends ComponentSampleModel {
    private static int[] createIndices(int numBands) {
        int[] indices = new int[numBands];
        for (int i = 0; i < numBands; ++i) {
            indices[i] = i;
        }
        return indices;
    }

    private static int[] createOffsets(int numBands) {
        int[] offsets = new int[numBands];
        for (int i = 0; i < numBands; ++i) {
            offsets[i] = 0;
        }
        return offsets;
    }

    public BandedSampleModel(int dataType, int w, int h, int numBands) {
        this(dataType, w, h, w, BandedSampleModel.createIndices(numBands), BandedSampleModel.createOffsets(numBands));
    }

    public BandedSampleModel(int dataType, int w, int h, int scanlineStride, int[] bankIndices, int[] bandOffsets) {
        super(dataType, w, h, 1, scanlineStride, bankIndices, bandOffsets);
    }

    @Override
    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new BandedSampleModel(this.dataType, w, h, w, this.bankIndices, this.bandOffsets);
    }

    @Override
    public DataBuffer createDataBuffer() {
        DataBuffer data = null;
        int size = this.scanlineStride * this.height;
        switch (this.dataType) {
            case 0: {
                data = new DataBufferByte(size, this.numBanks);
                break;
            }
            case 1: 
            case 2: {
                data = new DataBufferShort(size, this.numBanks);
                break;
            }
            case 3: {
                data = new DataBufferInt(size, this.numBanks);
                break;
            }
            case 4: {
                data = new DataBufferFloat(size, this.numBanks);
                break;
            }
            case 5: {
                data = new DataBufferDouble(size, this.numBanks);
            }
        }
        return data;
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] bands) {
        if (bands.length > this.numBands) {
            throw new RasterFormatException(Messages.getString("awt.64"));
        }
        int[] indices = new int[bands.length];
        int[] offsets = new int[bands.length];
        for (int i = 0; i < bands.length; ++i) {
            indices[i] = this.bankIndices[bands[i]];
            offsets[i] = this.bandOffsets[bands[i]];
        }
        return new BandedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, indices, offsets);
    }

    @Override
    public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
        switch (this.dataType) {
            case 0: {
                byte[] bdata = obj == null ? new byte[this.numBands] : (byte[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    bdata[i] = (byte)this.getSample(x, y, i, data);
                }
                obj = bdata;
                break;
            }
            case 1: 
            case 2: {
                short[] sdata = obj == null ? new short[this.numBands] : (short[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    sdata[i] = (short)this.getSample(x, y, i, data);
                }
                obj = sdata;
                break;
            }
            case 3: {
                int[] idata = obj == null ? new int[this.numBands] : (int[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    idata[i] = this.getSample(x, y, i, data);
                }
                obj = idata;
                break;
            }
            case 4: {
                float[] fdata = obj == null ? new float[this.numBands] : (float[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    fdata[i] = this.getSampleFloat(x, y, i, data);
                }
                obj = fdata;
                break;
            }
            case 5: {
                double[] ddata = obj == null ? new double[this.numBands] : (double[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    ddata[i] = this.getSampleDouble(x, y, i, data);
                }
                obj = ddata;
                break;
            }
        }
        return obj;
    }

    @Override
    public int[] getPixel(int x, int y, int[] iArray, DataBuffer data) {
        int[] pixel = iArray == null ? new int[this.numBands] : iArray;
        for (int i = 0; i < this.numBands; ++i) {
            pixel[i] = this.getSample(x, y, i, data);
        }
        return pixel;
    }

    @Override
    public int getSample(int x, int y, int b, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        return data.getElem(this.bankIndices[b], y * this.scanlineStride + x + this.bandOffsets[b]);
    }

    @Override
    public double getSampleDouble(int x, int y, int b, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        return data.getElemDouble(this.bankIndices[b], y * this.scanlineStride + x + this.bandOffsets[b]);
    }

    @Override
    public float getSampleFloat(int x, int y, int b, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        return data.getElemFloat(this.bankIndices[b], y * this.scanlineStride + x + this.bandOffsets[b]);
    }

    @Override
    public int[] getSamples(int x, int y, int w, int h, int b, int[] iArray, DataBuffer data) {
        int idx = 0;
        int[] samples = iArray == null ? new int[w * h] : iArray;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                samples[idx++] = this.getSample(j, i, b, data);
            }
        }
        return samples;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        int tmp = hash >>> 8;
        hash <<= 8;
        return (hash |= tmp) ^ 0x55;
    }

    @Override
    public void setDataElements(int x, int y, Object obj, DataBuffer data) {
        switch (this.dataType) {
            case 0: {
                byte[] bdata = (byte[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    this.setSample(x, y, i, bdata[i] & 0xFF, data);
                }
                break;
            }
            case 1: 
            case 2: {
                short[] sdata = (short[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    this.setSample(x, y, i, sdata[i] & 0xFFFF, data);
                }
                break;
            }
            case 3: {
                int[] idata = (int[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    this.setSample(x, y, i, idata[i], data);
                }
                break;
            }
            case 4: {
                float[] fdata = (float[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    this.setSample(x, y, i, fdata[i], data);
                }
                break;
            }
            case 5: {
                double[] ddata = (double[])obj;
                for (int i = 0; i < this.numBands; ++i) {
                    this.setSample(x, y, i, ddata[i], data);
                }
                break;
            }
        }
    }

    @Override
    public void setPixel(int x, int y, int[] iArray, DataBuffer data) {
        for (int i = 0; i < this.numBands; ++i) {
            this.setSample(x, y, i, iArray[i], data);
        }
    }

    @Override
    public void setPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        int idx = 0;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                for (int n = 0; n < this.numBands; ++n) {
                    this.setSample(j, i, n, iArray[idx++], data);
                }
            }
        }
    }

    @Override
    public void setSample(int x, int y, int b, double s, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        data.setElemDouble(this.bankIndices[b], y * this.scanlineStride + x + this.bandOffsets[b], s);
    }

    @Override
    public void setSample(int x, int y, int b, float s, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        data.setElemFloat(this.bankIndices[b], y * this.scanlineStride + x + this.bandOffsets[b], s);
    }

    @Override
    public void setSample(int x, int y, int b, int s, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        data.setElem(this.bankIndices[b], y * this.scanlineStride + x + this.bandOffsets[b], s);
    }

    @Override
    public void setSamples(int x, int y, int w, int h, int b, int[] iArray, DataBuffer data) {
        int idx = 0;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                this.setSample(j, i, b, iArray[idx++], data);
            }
        }
    }
}

