/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import org.apache.harmony.awt.gl.font.TextMetricsCalculator;
import org.apache.harmony.awt.gl.font.TextRunBreaker;

public final class TextMeasurer
implements Cloneable {
    AttributedCharacterIterator aci;
    FontRenderContext frc;
    TextRunBreaker breaker = null;
    TextMetricsCalculator tmc = null;

    public TextMeasurer(AttributedCharacterIterator text, FontRenderContext frc) {
        this.aci = text;
        this.frc = frc;
        this.breaker = new TextRunBreaker(this.aci, this.frc);
        this.tmc = new TextMetricsCalculator(this.breaker);
    }

    public void insertChar(AttributedCharacterIterator newParagraph, int insertPos) {
        AttributedCharacterIterator oldAci = this.aci;
        this.aci = newParagraph;
        if (oldAci.getEndIndex() - oldAci.getBeginIndex() - (this.aci.getEndIndex() - this.aci.getBeginIndex()) != -1) {
            this.breaker = new TextRunBreaker(this.aci, this.frc);
            this.tmc = new TextMetricsCalculator(this.breaker);
        } else {
            this.breaker.insertChar(newParagraph, insertPos);
        }
    }

    public void deleteChar(AttributedCharacterIterator newParagraph, int deletePos) {
        AttributedCharacterIterator oldAci = this.aci;
        this.aci = newParagraph;
        if (oldAci.getEndIndex() - oldAci.getBeginIndex() - (this.aci.getEndIndex() - this.aci.getBeginIndex()) != 1) {
            this.breaker = new TextRunBreaker(this.aci, this.frc);
            this.tmc = new TextMetricsCalculator(this.breaker);
        } else {
            this.breaker.deleteChar(newParagraph, deletePos);
        }
    }

    protected Object clone() {
        return new TextMeasurer((AttributedCharacterIterator)this.aci.clone(), this.frc);
    }

    public TextLayout getLayout(int start, int limit) {
        this.breaker.pushSegments(start - this.aci.getBeginIndex(), limit - this.aci.getBeginIndex());
        this.breaker.createAllSegments();
        TextLayout layout = new TextLayout((TextRunBreaker)this.breaker.clone());
        this.breaker.popSegments();
        return layout;
    }

    public float getAdvanceBetween(int start, int end) {
        this.breaker.pushSegments(start - this.aci.getBeginIndex(), end - this.aci.getBeginIndex());
        this.breaker.createAllSegments();
        float retval = this.tmc.createMetrics().getAdvance();
        this.breaker.popSegments();
        return retval;
    }

    public int getLineBreakIndex(int start, float maxAdvance) {
        this.breaker.createAllSegments();
        return this.breaker.getLineBreakIndex(start - this.aci.getBeginIndex(), maxAdvance) + this.aci.getBeginIndex();
    }
}

