/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import org.apache.harmony.awt.gl.font.BasicMetrics;
import org.apache.harmony.awt.gl.font.CaretManager;
import org.apache.harmony.awt.gl.font.TextMetricsCalculator;
import org.apache.harmony.awt.gl.font.TextRunBreaker;
import org.apache.harmony.awt.internal.nls.Messages;

public final class TextLayout
implements Cloneable {
    public static final CaretPolicy DEFAULT_CARET_POLICY = new CaretPolicy();
    private TextRunBreaker breaker;
    private boolean metricsValid = false;
    private TextMetricsCalculator tmc;
    private BasicMetrics metrics;
    private CaretManager caretManager;
    float justificationWidth = -1.0f;

    public TextLayout(String string, Font font, FontRenderContext frc) {
        if (string == null) {
            throw new IllegalArgumentException(Messages.getString("awt.01", "string"));
        }
        if (font == null) {
            throw new IllegalArgumentException(Messages.getString("awt.01", "font"));
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("awt.02", "string"));
        }
        AttributedString as = new AttributedString(string);
        as.addAttribute(TextAttribute.FONT, font);
        this.breaker = new TextRunBreaker(as.getIterator(), frc);
        this.caretManager = new CaretManager(this.breaker);
    }

    public TextLayout(String string, Map<? extends AttributedCharacterIterator.Attribute, ?> attributes, FontRenderContext frc) {
        if (string == null) {
            throw new IllegalArgumentException(Messages.getString("awt.01", "string"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(Messages.getString("awt.01", "attributes"));
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("awt.02", "string"));
        }
        AttributedString as = new AttributedString(string);
        as.addAttributes(attributes, 0, string.length());
        this.breaker = new TextRunBreaker(as.getIterator(), frc);
        this.caretManager = new CaretManager(this.breaker);
    }

    public TextLayout(AttributedCharacterIterator text, FontRenderContext frc) {
        if (text == null) {
            throw new IllegalArgumentException(Messages.getString("awt.03", "text"));
        }
        if (text.getBeginIndex() == text.getEndIndex()) {
            throw new IllegalArgumentException(Messages.getString("awt.04", "text"));
        }
        this.breaker = new TextRunBreaker(text, frc);
        this.caretManager = new CaretManager(this.breaker);
    }

    TextLayout(TextRunBreaker breaker) {
        this.breaker = breaker;
        this.caretManager = new CaretManager(this.breaker);
    }

    public int hashCode() {
        return this.breaker.hashCode();
    }

    protected Object clone() {
        TextLayout res = new TextLayout((TextRunBreaker)this.breaker.clone());
        if (this.justificationWidth >= 0.0f) {
            res.handleJustify(this.justificationWidth);
        }
        return res;
    }

    public boolean equals(TextLayout layout) {
        if (layout == null) {
            return false;
        }
        return this.breaker.equals(layout.breaker);
    }

    public boolean equals(Object obj) {
        return obj instanceof TextLayout ? this.equals((TextLayout)obj) : false;
    }

    public String toString() {
        return super.toString();
    }

    public void draw(Graphics2D g2d, float x, float y) {
        this.updateMetrics();
        this.breaker.drawSegments(g2d, x, y);
    }

    private void updateMetrics() {
        if (!this.metricsValid) {
            this.breaker.createAllSegments();
            this.tmc = new TextMetricsCalculator(this.breaker);
            this.metrics = this.tmc.createMetrics();
            this.metricsValid = true;
        }
    }

    public float getAdvance() {
        this.updateMetrics();
        return this.metrics.getAdvance();
    }

    public float getAscent() {
        this.updateMetrics();
        return this.metrics.getAscent();
    }

    public byte getBaseline() {
        this.updateMetrics();
        return (byte)this.metrics.getBaseLineIndex();
    }

    public float[] getBaselineOffsets() {
        this.updateMetrics();
        return this.tmc.getBaselineOffsets();
    }

    public Shape getBlackBoxBounds(int firstEndpoint, int secondEndpoint) {
        this.updateMetrics();
        if (firstEndpoint < secondEndpoint) {
            return this.breaker.getBlackBoxBounds(firstEndpoint, secondEndpoint);
        }
        return this.breaker.getBlackBoxBounds(secondEndpoint, firstEndpoint);
    }

    public Rectangle2D getBounds() {
        this.updateMetrics();
        return this.breaker.getVisualBounds();
    }

    public float[] getCaretInfo(TextHitInfo hitInfo) {
        this.updateMetrics();
        return this.caretManager.getCaretInfo(hitInfo);
    }

    public float[] getCaretInfo(TextHitInfo hitInfo, Rectangle2D bounds) {
        this.updateMetrics();
        return this.caretManager.getCaretInfo(hitInfo);
    }

    public Shape getCaretShape(TextHitInfo hitInfo, Rectangle2D bounds) {
        this.updateMetrics();
        return this.caretManager.getCaretShape(hitInfo, this);
    }

    public Shape getCaretShape(TextHitInfo hitInfo) {
        this.updateMetrics();
        return this.caretManager.getCaretShape(hitInfo, this);
    }

    public Shape[] getCaretShapes(int offset) {
        return this.getCaretShapes(offset, null, DEFAULT_CARET_POLICY);
    }

    public Shape[] getCaretShapes(int offset, Rectangle2D bounds) {
        return this.getCaretShapes(offset, bounds, DEFAULT_CARET_POLICY);
    }

    public Shape[] getCaretShapes(int offset, Rectangle2D bounds, CaretPolicy policy) {
        if (offset < 0 || offset > this.breaker.getCharCount()) {
            throw new IllegalArgumentException(Messages.getString("awt.195"));
        }
        this.updateMetrics();
        return this.caretManager.getCaretShapes(offset, bounds, policy, this);
    }

    public int getCharacterCount() {
        return this.breaker.getCharCount();
    }

    public byte getCharacterLevel(int index) {
        if (index == -1 || index == this.getCharacterCount()) {
            return (byte)this.breaker.getBaseLevel();
        }
        return this.breaker.getLevel(index);
    }

    public float getDescent() {
        this.updateMetrics();
        return this.metrics.getDescent();
    }

    public TextLayout getJustifiedLayout(float justificationWidth) throws Error {
        float justification = this.breaker.getJustification();
        if (justification < 0.0f) {
            throw new Error(Messages.getString("awt.196"));
        }
        if (justification == 0.0f) {
            return this;
        }
        TextLayout justifiedLayout = new TextLayout((TextRunBreaker)this.breaker.clone());
        justifiedLayout.handleJustify(justificationWidth);
        return justifiedLayout;
    }

    public float getLeading() {
        this.updateMetrics();
        return this.metrics.getLeading();
    }

    public Shape getLogicalHighlightShape(int firstEndpoint, int secondEndpoint) {
        this.updateMetrics();
        return this.getLogicalHighlightShape(firstEndpoint, secondEndpoint, this.breaker.getLogicalBounds());
    }

    public Shape getLogicalHighlightShape(int firstEndpoint, int secondEndpoint, Rectangle2D bounds) {
        this.updateMetrics();
        if (firstEndpoint > secondEndpoint) {
            if (secondEndpoint < 0 || firstEndpoint > this.breaker.getCharCount()) {
                throw new IllegalArgumentException(Messages.getString("awt.197"));
            }
            return this.caretManager.getLogicalHighlightShape(secondEndpoint, firstEndpoint, bounds, this);
        }
        if (firstEndpoint < 0 || secondEndpoint > this.breaker.getCharCount()) {
            throw new IllegalArgumentException(Messages.getString("awt.197"));
        }
        return this.caretManager.getLogicalHighlightShape(firstEndpoint, secondEndpoint, bounds, this);
    }

    public int[] getLogicalRangesForVisualSelection(TextHitInfo hit1, TextHitInfo hit2) {
        return this.caretManager.getLogicalRangesForVisualSelection(hit1, hit2);
    }

    public TextHitInfo getNextLeftHit(int offset) {
        return this.getNextLeftHit(offset, DEFAULT_CARET_POLICY);
    }

    public TextHitInfo getNextLeftHit(TextHitInfo hitInfo) {
        this.breaker.createAllSegments();
        return this.caretManager.getNextLeftHit(hitInfo);
    }

    public TextHitInfo getNextLeftHit(int offset, CaretPolicy policy) {
        if (offset < 0 || offset > this.breaker.getCharCount()) {
            throw new IllegalArgumentException(Messages.getString("awt.195"));
        }
        TextHitInfo hit = TextHitInfo.afterOffset(offset);
        TextHitInfo strongHit = policy.getStrongCaret(hit, hit.getOtherHit(), this);
        TextHitInfo nextLeftHit = this.getNextLeftHit(strongHit);
        if (nextLeftHit != null) {
            return policy.getStrongCaret(this.getVisualOtherHit(nextLeftHit), nextLeftHit, this);
        }
        return null;
    }

    public TextHitInfo getNextRightHit(TextHitInfo hitInfo) {
        this.breaker.createAllSegments();
        return this.caretManager.getNextRightHit(hitInfo);
    }

    public TextHitInfo getNextRightHit(int offset) {
        return this.getNextRightHit(offset, DEFAULT_CARET_POLICY);
    }

    public TextHitInfo getNextRightHit(int offset, CaretPolicy policy) {
        if (offset < 0 || offset > this.breaker.getCharCount()) {
            throw new IllegalArgumentException(Messages.getString("awt.195"));
        }
        TextHitInfo hit = TextHitInfo.afterOffset(offset);
        TextHitInfo strongHit = policy.getStrongCaret(hit, hit.getOtherHit(), this);
        TextHitInfo nextRightHit = this.getNextRightHit(strongHit);
        if (nextRightHit != null) {
            return policy.getStrongCaret(this.getVisualOtherHit(nextRightHit), nextRightHit, this);
        }
        return null;
    }

    public Shape getOutline(AffineTransform xform) {
        this.breaker.createAllSegments();
        GeneralPath outline = this.breaker.getOutline();
        if (outline != null && xform != null) {
            outline.transform(xform);
        }
        return outline;
    }

    public float getVisibleAdvance() {
        this.updateMetrics();
        int lastNonWhitespace = this.breaker.getLastNonWhitespace();
        if (lastNonWhitespace < 0) {
            return 0.0f;
        }
        if (lastNonWhitespace == this.getCharacterCount() - 1) {
            return this.getAdvance();
        }
        if (this.justificationWidth >= 0.0f) {
            return this.justificationWidth;
        }
        this.breaker.pushSegments(this.breaker.getACI().getBeginIndex(), lastNonWhitespace + this.breaker.getACI().getBeginIndex() + 1);
        this.breaker.createAllSegments();
        float visAdvance = this.tmc.createMetrics().getAdvance();
        this.breaker.popSegments();
        return visAdvance;
    }

    public Shape getVisualHighlightShape(TextHitInfo hit1, TextHitInfo hit2, Rectangle2D bounds) {
        return this.caretManager.getVisualHighlightShape(hit1, hit2, bounds, this);
    }

    public Shape getVisualHighlightShape(TextHitInfo hit1, TextHitInfo hit2) {
        this.breaker.createAllSegments();
        return this.caretManager.getVisualHighlightShape(hit1, hit2, this.breaker.getLogicalBounds(), this);
    }

    public TextHitInfo getVisualOtherHit(TextHitInfo hitInfo) {
        return this.caretManager.getVisualOtherHit(hitInfo);
    }

    protected void handleJustify(float justificationWidth) {
        float justification = this.breaker.getJustification();
        if (justification < 0.0f) {
            throw new IllegalStateException(Messages.getString("awt.196"));
        }
        if (justification == 0.0f) {
            return;
        }
        float gap = (justificationWidth - this.getVisibleAdvance()) * justification;
        this.breaker.justify(gap);
        this.justificationWidth = justificationWidth;
        this.tmc = new TextMetricsCalculator(this.breaker);
        this.tmc.correctAdvance(this.metrics);
    }

    public TextHitInfo hitTestChar(float x, float y) {
        return this.hitTestChar(x, y, this.getBounds());
    }

    public TextHitInfo hitTestChar(float x, float y, Rectangle2D bounds) {
        if ((double)x > bounds.getMaxX()) {
            return this.breaker.isLTR() ? TextHitInfo.trailing(this.breaker.getCharCount() - 1) : TextHitInfo.leading(0);
        }
        if ((double)x < bounds.getMinX()) {
            return this.breaker.isLTR() ? TextHitInfo.leading(0) : TextHitInfo.trailing(this.breaker.getCharCount() - 1);
        }
        return this.breaker.hitTest(x, y);
    }

    public boolean isLeftToRight() {
        return this.breaker.isLTR();
    }

    public boolean isVertical() {
        return false;
    }

    public static class CaretPolicy {
        public TextHitInfo getStrongCaret(TextHitInfo hit1, TextHitInfo hit2, TextLayout layout) {
            byte level2;
            byte level1 = layout.getCharacterLevel(hit1.getCharIndex());
            if (level1 == (level2 = layout.getCharacterLevel(hit2.getCharIndex()))) {
                return hit2.isLeadingEdge() && !hit1.isLeadingEdge() ? hit2 : hit1;
            }
            return level1 > level2 ? hit1 : hit2;
        }
    }
}

