/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.GraphicAttribute;
import java.awt.geom.Rectangle2D;
import org.apache.harmony.misc.HashCode;

public final class ImageGraphicAttribute
extends GraphicAttribute {
    private Image fImage;
    private float fOriginX;
    private float fOriginY;
    private float fImgWidth;
    private float fImgHeight;

    public ImageGraphicAttribute(Image image, int alignment, float originX, float originY) {
        super(alignment);
        this.fImage = image;
        this.fOriginX = originX;
        this.fOriginY = originY;
        this.fImgWidth = this.fImage.getWidth(null);
        this.fImgHeight = this.fImage.getHeight(null);
    }

    public ImageGraphicAttribute(Image image, int alignment) {
        this(image, alignment, 0.0f, 0.0f);
    }

    public int hashCode() {
        HashCode hash = new HashCode();
        hash.append(this.fImage.hashCode());
        hash.append(this.getAlignment());
        return hash.hashCode();
    }

    public boolean equals(ImageGraphicAttribute iga) {
        if (iga == null) {
            return false;
        }
        if (iga == this) {
            return true;
        }
        return this.fOriginX == iga.fOriginX && this.fOriginY == iga.fOriginY && this.getAlignment() == iga.getAlignment() && this.fImage.equals(iga.fImage);
    }

    public boolean equals(Object obj) {
        try {
            return this.equals((ImageGraphicAttribute)obj);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public void draw(Graphics2D g2, float x, float y) {
        g2.drawImage(this.fImage, (int)(x - this.fOriginX), (int)(y - this.fOriginY), null);
    }

    @Override
    public float getAdvance() {
        return Math.max(0.0f, this.fImgWidth - this.fOriginX);
    }

    @Override
    public float getAscent() {
        return Math.max(0.0f, this.fOriginY);
    }

    @Override
    public Rectangle2D getBounds() {
        return new Rectangle2D.Float(-this.fOriginX, -this.fOriginY, this.fImgWidth, this.fImgHeight);
    }

    @Override
    public float getDescent() {
        return Math.max(0.0f, this.fImgHeight - this.fOriginY);
    }
}

