/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import java.awt.color.CMMException;
import java.awt.color.ICC_ProfileGray;
import java.awt.color.ICC_ProfileRGB;
import java.awt.color.ProfileDataException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import org.apache.harmony.awt.Utils;
import org.apache.harmony.awt.gl.color.ICC_ProfileHelper;
import org.apache.harmony.awt.gl.color.NativeCMM;
import org.apache.harmony.awt.internal.nls.Messages;

public class ICC_Profile
implements Serializable {
    private static final long serialVersionUID = -3938515861990936766L;
    public static final int CLASS_INPUT = 0;
    public static final int CLASS_DISPLAY = 1;
    public static final int CLASS_OUTPUT = 2;
    public static final int CLASS_DEVICELINK = 3;
    public static final int CLASS_COLORSPACECONVERSION = 4;
    public static final int CLASS_ABSTRACT = 5;
    public static final int CLASS_NAMEDCOLOR = 6;
    public static final int icSigXYZData = 1482250784;
    public static final int icSigLabData = 1281450528;
    public static final int icSigLuvData = 1282766368;
    public static final int icSigYCbCrData = 1497588338;
    public static final int icSigYxyData = 1501067552;
    public static final int icSigRgbData = 1380401696;
    public static final int icSigGrayData = 1196573017;
    public static final int icSigHsvData = 1213421088;
    public static final int icSigHlsData = 1212961568;
    public static final int icSigCmykData = 1129142603;
    public static final int icSigCmyData = 1129142560;
    public static final int icSigSpace2CLR = 843271250;
    public static final int icSigSpace3CLR = 860048466;
    public static final int icSigSpace4CLR = 876825682;
    public static final int icSigSpace5CLR = 893602898;
    public static final int icSigSpace6CLR = 910380114;
    public static final int icSigSpace7CLR = 927157330;
    public static final int icSigSpace8CLR = 943934546;
    public static final int icSigSpace9CLR = 960711762;
    public static final int icSigSpaceACLR = 1094929490;
    public static final int icSigSpaceBCLR = 1111706706;
    public static final int icSigSpaceCCLR = 1128483922;
    public static final int icSigSpaceDCLR = 1145261138;
    public static final int icSigSpaceECLR = 1162038354;
    public static final int icSigSpaceFCLR = 1178815570;
    public static final int icSigInputClass = 1935896178;
    public static final int icSigDisplayClass = 1835955314;
    public static final int icSigOutputClass = 1886549106;
    public static final int icSigLinkClass = 1818848875;
    public static final int icSigAbstractClass = 1633842036;
    public static final int icSigColorantOrderTag = 1668051567;
    public static final int icSigColorantTableTag = 1668051572;
    public static final int icSigColorSpaceClass = 1936744803;
    public static final int icSigNamedColorClass = 1852662636;
    public static final int icPerceptual = 0;
    public static final int icRelativeColorimetric = 1;
    public static final int icSaturation = 2;
    public static final int icAbsoluteColorimetric = 3;
    public static final int icSigHead = 1751474532;
    public static final int icSigAToB0Tag = 1093812784;
    public static final int icSigAToB1Tag = 1093812785;
    public static final int icSigAToB2Tag = 1093812786;
    public static final int icSigBlueColorantTag = 1649957210;
    public static final int icSigBlueMatrixColumnTag = 1649957210;
    public static final int icSigBlueTRCTag = 1649693251;
    public static final int icSigBToA0Tag = 1110589744;
    public static final int icSigBToA1Tag = 1110589745;
    public static final int icSigBToA2Tag = 1110589746;
    public static final int icSigCalibrationDateTimeTag = 1667329140;
    public static final int icSigCharTargetTag = 1952543335;
    public static final int icSigCopyrightTag = 1668313716;
    public static final int icSigCrdInfoTag = 1668441193;
    public static final int icSigDeviceMfgDescTag = 1684893284;
    public static final int icSigDeviceModelDescTag = 0x646D6464;
    public static final int icSigDeviceSettingsTag = 1684371059;
    public static final int icSigGamutTag = 1734438260;
    public static final int icSigGrayTRCTag = 1800688195;
    public static final int icSigGreenColorantTag = 1733843290;
    public static final int icSigGreenMatrixColumnTag = 1733843290;
    public static final int icSigGreenTRCTag = 1733579331;
    public static final int icSigLuminanceTag = 1819635049;
    public static final int icSigMeasurementTag = 1835360627;
    public static final int icSigMediaBlackPointTag = 1651208308;
    public static final int icSigMediaWhitePointTag = 0x77747074;
    public static final int icSigNamedColor2Tag = 1852009522;
    public static final int icSigOutputResponseTag = 1919251312;
    public static final int icSigPreview0Tag = 1886545200;
    public static final int icSigPreview1Tag = 1886545201;
    public static final int icSigPreview2Tag = 1886545202;
    public static final int icSigProfileDescriptionTag = 1684370275;
    public static final int icSigProfileSequenceDescTag = 1886610801;
    public static final int icSigPs2CRD0Tag = 1886610480;
    public static final int icSigPs2CRD1Tag = 1886610481;
    public static final int icSigPs2CRD2Tag = 1886610482;
    public static final int icSigPs2CRD3Tag = 1886610483;
    public static final int icSigPs2CSATag = 1886597747;
    public static final int icSigPs2RenderingIntentTag = 1886597737;
    public static final int icSigRedColorantTag = 1918392666;
    public static final int icSigRedMatrixColumnTag = 1918392666;
    public static final int icSigRedTRCTag = 1918128707;
    public static final int icSigScreeningDescTag = 1935897188;
    public static final int icSigScreeningTag = 1935897198;
    public static final int icSigTechnologyTag = 1952801640;
    public static final int icSigUcrBgTag = 1650877472;
    public static final int icSigViewingCondDescTag = 1987405156;
    public static final int icSigViewingConditionsTag = 1986618743;
    public static final int icSigChromaticAdaptationTag = 1667785060;
    public static final int icSigChromaticityTag = 1667789421;
    public static final int icHdrSize = 0;
    public static final int icHdrCmmId = 4;
    public static final int icHdrVersion = 8;
    public static final int icHdrDeviceClass = 12;
    public static final int icHdrColorSpace = 16;
    public static final int icHdrPcs = 20;
    public static final int icHdrDate = 24;
    public static final int icHdrMagic = 36;
    public static final int icHdrPlatform = 40;
    public static final int icHdrProfileID = 84;
    public static final int icHdrFlags = 44;
    public static final int icHdrManufacturer = 48;
    public static final int icHdrModel = 52;
    public static final int icHdrAttributes = 56;
    public static final int icHdrRenderingIntent = 64;
    public static final int icHdrIlluminant = 68;
    public static final int icHdrCreator = 80;
    public static final int icICCAbsoluteColorimetric = 3;
    public static final int icMediaRelativeColorimetric = 1;
    public static final int icTagType = 0;
    public static final int icTagReserved = 4;
    public static final int icCurveCount = 8;
    public static final int icCurveData = 12;
    public static final int icXYZNumberX = 8;
    private static final int headerSize = 128;
    private static final int headerMagicNumber = 1633907568;
    private static ICC_Profile sRGBProfile;
    private static ICC_Profile xyzProfile;
    private static ICC_Profile grayProfile;
    private static ICC_Profile pyccProfile;
    private static ICC_Profile linearRGBProfile;
    private transient long profileHandle = 0L;
    private transient boolean handleStolen = false;
    private transient byte[] headerData = null;
    private transient ICC_Profile openedProfileObject;

    private ICC_Profile(byte[] data) {
    }

    ICC_Profile() {
    }

    ICC_Profile(long profileHandle) {
        this.profileHandle = profileHandle;
    }

    public void write(String fileName) throws IOException {
        FileOutputStream oStream = new FileOutputStream(fileName);
        oStream.write(this.getData());
        oStream.close();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(null);
        s.writeObject(this.getData());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        String colorSpaceStr = (String)s.readObject();
        byte[] data = (byte[])s.readObject();
        this.openedProfileObject = colorSpaceStr != null ? (colorSpaceStr.equals("CS_sRGB") ? ICC_Profile.getInstance(1000) : (colorSpaceStr.equals("CS_GRAY") ? ICC_Profile.getInstance(1003) : (colorSpaceStr.equals("CS_LINEAR_RGB") ? ICC_Profile.getInstance(1004) : (colorSpaceStr.equals("CS_CIEXYZ") ? ICC_Profile.getInstance(1001) : (colorSpaceStr.equals("CS_PYCC") ? ICC_Profile.getInstance(1002) : ICC_Profile.getInstance(data)))))) : ICC_Profile.getInstance(data);
    }

    protected Object readResolve() throws ObjectStreamException {
        return this.openedProfileObject;
    }

    public void write(OutputStream s) throws IOException {
        s.write(this.getData());
    }

    public void setData(int tagSignature, byte[] tagData) {
        NativeCMM.cmmSetProfileElement(this.profileHandle, tagSignature, tagData);
        if (tagSignature == 1751474532) {
            this.headerData = null;
        }
    }

    public byte[] getData(int tagSignature) {
        int tagSize = 0;
        try {
            tagSize = NativeCMM.cmmGetProfileElementSize(this.profileHandle, tagSignature);
        }
        catch (CMMException e) {
            return null;
        }
        byte[] data = new byte[tagSize];
        NativeCMM.cmmGetProfileElement(this.profileHandle, tagSignature, data);
        return data;
    }

    public byte[] getData() {
        int profileSize = NativeCMM.cmmGetProfileSize(this.profileHandle);
        byte[] data = new byte[profileSize];
        NativeCMM.cmmGetProfile(this.profileHandle, data);
        return data;
    }

    protected void finalize() {
        if (this.profileHandle != 0L && !this.handleStolen) {
            NativeCMM.cmmCloseProfile(this.profileHandle);
        }
        NativeCMM.removeHandle(this);
    }

    public int getProfileClass() {
        int deviceClassSignature = this.getIntFromHeader(12);
        switch (deviceClassSignature) {
            case 1936744803: {
                return 4;
            }
            case 1835955314: {
                return 1;
            }
            case 1886549106: {
                return 2;
            }
            case 1935896178: {
                return 0;
            }
            case 1818848875: {
                return 3;
            }
            case 1633842036: {
                return 5;
            }
            case 1852662636: {
                return 6;
            }
        }
        throw new IllegalArgumentException(Messages.getString("awt.15F"));
    }

    public int getPCSType() {
        return this.csFromSignature(this.getIntFromHeader(20));
    }

    public int getNumComponents() {
        switch (this.getIntFromHeader(16)) {
            case 1281450528: 
            case 1380401696: 
            case 1482250784: {
                return 3;
            }
            case 1129142603: {
                return 4;
            }
            case 1196573017: {
                return 1;
            }
            case 843271250: {
                return 2;
            }
            case 860048466: 
            case 1129142560: 
            case 1212961568: 
            case 1213421088: 
            case 1282766368: 
            case 1497588338: 
            case 1501067552: {
                return 3;
            }
            case 876825682: {
                return 4;
            }
            case 893602898: {
                return 5;
            }
            case 910380114: {
                return 6;
            }
            case 927157330: {
                return 7;
            }
            case 943934546: {
                return 8;
            }
            case 960711762: {
                return 9;
            }
            case 1094929490: {
                return 10;
            }
            case 1111706706: {
                return 11;
            }
            case 1128483922: {
                return 12;
            }
            case 1145261138: {
                return 13;
            }
            case 1162038354: {
                return 14;
            }
            case 1178815570: {
                return 15;
            }
        }
        throw new ProfileDataException(Messages.getString("awt.160"));
    }

    public int getMinorVersion() {
        return this.getByteFromHeader(9);
    }

    public int getMajorVersion() {
        return this.getByteFromHeader(8);
    }

    public int getColorSpaceType() {
        return this.csFromSignature(this.getIntFromHeader(16));
    }

    private static FileInputStream tryPath(String path, String fileName) {
        if (path == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String pathEntry = st.nextToken();
            try {
                return new FileInputStream(pathEntry + File.separatorChar + fileName);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        return null;
    }

    public static ICC_Profile getInstance(String fileName) throws IOException {
        final String fName = fileName;
        FileInputStream fiStream = AccessController.doPrivileged(new PrivilegedAction<FileInputStream>(){

            @Override
            public FileInputStream run() {
                try {
                    return new FileInputStream(fName);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    FileInputStream fiStream = ICC_Profile.tryPath(Utils.getSystemProperty("java.iccprofile.path"), fName);
                    if (fiStream != null) {
                        return fiStream;
                    }
                    fiStream = ICC_Profile.tryPath(Utils.getSystemProperty("java.class.path"), fName);
                    if (fiStream != null) {
                        return fiStream;
                    }
                    String home = Utils.getSystemProperty("java.home");
                    if (home != null) {
                        fiStream = ICC_Profile.tryPath(home + File.separatorChar + "lib" + File.separatorChar + "cmm", fName);
                    }
                    return fiStream;
                }
            }
        });
        if (fiStream == null) {
            throw new IOException(Messages.getString("awt.161", fileName));
        }
        ICC_Profile pf = ICC_Profile.getInstance(fiStream);
        fiStream.close();
        return pf;
    }

    public static ICC_Profile getInstance(InputStream s) throws IOException {
        byte[] header = new byte[128];
        String invalidDataMessage = Messages.getString("awt.162");
        if (s.read(header) != 128) {
            throw new IllegalArgumentException(invalidDataMessage);
        }
        if (ICC_ProfileHelper.getBigEndianFromByteArray(header, 36) != 1633907568) {
            throw new IllegalArgumentException(invalidDataMessage);
        }
        int profileSize = ICC_ProfileHelper.getBigEndianFromByteArray(header, 0);
        byte[] profileData = new byte[profileSize];
        System.arraycopy(header, 0, profileData, 0, 128);
        if (s.read(profileData, 128, profileSize - 128) != profileSize - 128) {
            throw new IllegalArgumentException(invalidDataMessage);
        }
        return ICC_Profile.getInstance(profileData);
    }

    public static ICC_Profile getInstance(byte[] data) {
        ICC_Profile res = null;
        try {
            res = new ICC_Profile(data);
        }
        catch (CMMException e) {
            throw new IllegalArgumentException(Messages.getString("awt.162"));
        }
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
            try {
                if (res.getColorSpaceType() == 5 && res.getDataSize(0x77747074) > 0 && res.getDataSize(1918392666) > 0 && res.getDataSize(1733843290) > 0 && res.getDataSize(1649957210) > 0 && res.getDataSize(1918128707) > 0 && res.getDataSize(1733579331) > 0 && res.getDataSize(1649693251) > 0) {
                    res = new ICC_ProfileRGB(res.getProfileHandle());
                } else if (res.getColorSpaceType() == 6 && res.getDataSize(0x77747074) > 0 && res.getDataSize(1800688195) > 0) {
                    res = new ICC_ProfileGray(res.getProfileHandle());
                }
            }
            catch (CMMException cMMException) {
                // empty catch block
            }
        }
        return res;
    }

    public static ICC_Profile getInstance(int cspace) {
        try {
            switch (cspace) {
                case 1000: {
                    if (sRGBProfile == null) {
                        sRGBProfile = ICC_Profile.getInstance("sRGB.pf");
                    }
                    return sRGBProfile;
                }
                case 1001: {
                    if (xyzProfile == null) {
                        xyzProfile = ICC_Profile.getInstance("CIEXYZ.pf");
                    }
                    return xyzProfile;
                }
                case 1003: {
                    if (grayProfile == null) {
                        grayProfile = ICC_Profile.getInstance("GRAY.pf");
                    }
                    return grayProfile;
                }
                case 1002: {
                    if (pyccProfile == null) {
                        pyccProfile = ICC_Profile.getInstance("PYCC.pf");
                    }
                    return pyccProfile;
                }
                case 1004: {
                    if (linearRGBProfile == null) {
                        linearRGBProfile = ICC_Profile.getInstance("LINEAR_RGB.pf");
                    }
                    return linearRGBProfile;
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(Messages.getString("awt.163"));
        }
        throw new IllegalArgumentException(Messages.getString("awt.164"));
    }

    private int getIntFromHeader(int idx) {
        if (this.headerData == null) {
            this.headerData = this.getData(1751474532);
        }
        return (this.headerData[idx] & 0xFF) << 24 | (this.headerData[idx + 1] & 0xFF) << 16 | (this.headerData[idx + 2] & 0xFF) << 8 | this.headerData[idx + 3] & 0xFF;
    }

    private byte getByteFromHeader(int idx) {
        if (this.headerData == null) {
            this.headerData = this.getData(1751474532);
        }
        return this.headerData[idx];
    }

    private int csFromSignature(int signature) {
        switch (signature) {
            case 1380401696: {
                return 5;
            }
            case 1482250784: {
                return 0;
            }
            case 1129142603: {
                return 9;
            }
            case 1281450528: {
                return 1;
            }
            case 1196573017: {
                return 6;
            }
            case 1212961568: {
                return 8;
            }
            case 1282766368: {
                return 2;
            }
            case 1497588338: {
                return 3;
            }
            case 1501067552: {
                return 4;
            }
            case 1213421088: {
                return 7;
            }
            case 1129142560: {
                return 11;
            }
            case 843271250: {
                return 12;
            }
            case 860048466: {
                return 13;
            }
            case 876825682: {
                return 14;
            }
            case 893602898: {
                return 15;
            }
            case 910380114: {
                return 16;
            }
            case 927157330: {
                return 17;
            }
            case 943934546: {
                return 18;
            }
            case 960711762: {
                return 19;
            }
            case 1094929490: {
                return 20;
            }
            case 1111706706: {
                return 21;
            }
            case 1128483922: {
                return 22;
            }
            case 1145261138: {
                return 23;
            }
            case 1162038354: {
                return 24;
            }
            case 1178815570: {
                return 25;
            }
        }
        throw new IllegalArgumentException(Messages.getString("awt.165"));
    }

    private long getProfileHandle() {
        this.handleStolen = true;
        return this.profileHandle;
    }

    private int getDataSize(int tagSignature) {
        return NativeCMM.cmmGetProfileElementSize(this.profileHandle, tagSignature);
    }

    float[] getXYZValue(int tagSignature) {
        float[] res = new float[3];
        byte[] data = this.getData(tagSignature);
        res[0] = (float)ICC_ProfileHelper.getIntFromByteArray(data, 0) / 65536.0f;
        res[1] = (float)ICC_ProfileHelper.getIntFromByteArray(data, 4) / 65536.0f;
        res[2] = (float)ICC_ProfileHelper.getIntFromByteArray(data, 8) / 65536.0f;
        return res;
    }

    float[] getMediaWhitePoint() {
        return this.getXYZValue(0x77747074);
    }

    private float getGammaOrTRC(int tagSignature, short[] dataTRC) {
        byte[] data = this.getData(tagSignature);
        int trcSize = ICC_ProfileHelper.getIntFromByteArray(data, 8);
        dataTRC = null;
        if (trcSize == 0) {
            return 1.0f;
        }
        if (trcSize == 1) {
            return (float)ICC_ProfileHelper.getShortFromByteArray(data, 12) / 256.0f;
        }
        dataTRC = new short[trcSize];
        int i = 0;
        int pos = 12;
        while (i < trcSize) {
            dataTRC[i] = ICC_ProfileHelper.getShortFromByteArray(data, pos);
            ++i;
            pos += 2;
        }
        return 0.0f;
    }

    float getGamma(int tagSignature) {
        short[] dataTRC = null;
        float gamma = this.getGammaOrTRC(tagSignature, dataTRC);
        if (dataTRC == null) {
            return gamma;
        }
        throw new ProfileDataException(Messages.getString("awt.166"));
    }

    short[] getTRC(int tagSignature) {
        short[] dataTRC = null;
        this.getGammaOrTRC(tagSignature, dataTRC);
        if (dataTRC == null) {
            throw new ProfileDataException(Messages.getString("awt.167"));
        }
        return dataTRC;
    }
}

