/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import java.awt.color.CMMException;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.color.ICC_ProfileStub;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import org.apache.harmony.awt.gl.color.ColorConverter;
import org.apache.harmony.awt.gl.color.ColorScaler;
import org.apache.harmony.awt.gl.color.ICC_Transform;
import org.apache.harmony.awt.internal.nls.Messages;

public class ICC_ColorSpace
extends ColorSpace {
    private static final long serialVersionUID = 3455889114070431483L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("thisProfile", ICC_Profile.class), new ObjectStreamField("minVal", float[].class), new ObjectStreamField("maxVal", float[].class), new ObjectStreamField("diffMinMax", float[].class), new ObjectStreamField("invDiffMinMax", float[].class), new ObjectStreamField("needScaleInit", Boolean.TYPE)};
    private static final float MAX_XYZ = 1.9999695f;
    private static final float MAX_SHORT = 65535.0f;
    private static final float INV_MAX_SHORT = 1.5259022E-5f;
    private static final float SHORT2XYZ_FACTOR = 3.0517578E-5f;
    private static final float XYZ2SHORT_FACTOR = 32768.0f;
    private ICC_Profile profile = null;
    private float[] minValues = null;
    private float[] maxValues = null;
    private ICC_Transform toRGBTransform = null;
    private ICC_Transform fromRGBTransform = null;
    private ICC_Transform toXYZTransform = null;
    private ICC_Transform fromXYZTransform = null;
    private final ColorConverter converter = new ColorConverter();
    private final ColorScaler scaler = new ColorScaler();
    private boolean scalingDataLoaded = false;
    private ICC_ColorSpace resolvedDeserializedInst;

    public ICC_ColorSpace(ICC_Profile pf) {
        super(pf.getColorSpaceType(), pf.getNumComponents());
        int pfClass = pf.getProfileClass();
        switch (pfClass) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException(Messages.getString("awt.168"));
            }
        }
        this.profile = pf;
        this.fillMinMaxValues();
    }

    public ICC_Profile getProfile() {
        if (this.profile instanceof ICC_ProfileStub) {
            this.profile = ((ICC_ProfileStub)this.profile).loadProfile();
        }
        return this.profile;
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        if (this.toRGBTransform == null) {
            ICC_Profile sRGBProfile = ((ICC_ColorSpace)ColorSpace.getInstance(1000)).getProfile();
            ICC_Profile[] profiles = new ICC_Profile[]{this.getProfile(), sRGBProfile};
            this.toRGBTransform = new ICC_Transform(profiles);
            if (!this.scalingDataLoaded) {
                this.scaler.loadScalingData(this);
                this.scalingDataLoaded = true;
            }
        }
        short[] data = new short[this.getNumComponents()];
        this.scaler.scale(colorvalue, data, 0);
        short[] converted = this.converter.translateColor(this.toRGBTransform, data, null);
        float[] res = new float[]{(float)(converted[0] & 0xFFFF) * 1.5259022E-5f, (float)(converted[1] & 0xFFFF) * 1.5259022E-5f, (float)(converted[2] & 0xFFFF) * 1.5259022E-5f};
        return res;
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        if (this.toXYZTransform == null) {
            ICC_Profile xyzProfile = ((ICC_ColorSpace)ColorSpace.getInstance(1001)).getProfile();
            ICC_Profile[] profiles = new ICC_Profile[]{this.getProfile(), xyzProfile};
            try {
                int[] intents = new int[]{1, 0};
                this.toXYZTransform = new ICC_Transform(profiles, intents);
            }
            catch (CMMException e) {
                this.toXYZTransform = new ICC_Transform(profiles);
            }
            if (!this.scalingDataLoaded) {
                this.scaler.loadScalingData(this);
                this.scalingDataLoaded = true;
            }
        }
        short[] data = new short[this.getNumComponents()];
        this.scaler.scale(colorvalue, data, 0);
        short[] converted = this.converter.translateColor(this.toXYZTransform, data, null);
        float[] res = new float[]{(float)(converted[0] & 0xFFFF) * 3.0517578E-5f, (float)(converted[1] & 0xFFFF) * 3.0517578E-5f, (float)(converted[2] & 0xFFFF) * 3.0517578E-5f};
        return res;
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        if (this.fromRGBTransform == null) {
            ICC_Profile sRGBProfile = ((ICC_ColorSpace)ColorSpace.getInstance(1000)).getProfile();
            ICC_Profile[] profiles = new ICC_Profile[]{sRGBProfile, this.getProfile()};
            this.fromRGBTransform = new ICC_Transform(profiles);
            if (!this.scalingDataLoaded) {
                this.scaler.loadScalingData(this);
                this.scalingDataLoaded = true;
            }
        }
        short[] scaledRGBValue = new short[]{(short)(rgbvalue[0] * 65535.0f + 0.5f), (short)(rgbvalue[1] * 65535.0f + 0.5f), (short)(rgbvalue[2] * 65535.0f + 0.5f)};
        short[] converted = this.converter.translateColor(this.fromRGBTransform, scaledRGBValue, null);
        float[] res = new float[this.getNumComponents()];
        this.scaler.unscale(res, converted, 0);
        return res;
    }

    @Override
    public float[] fromCIEXYZ(float[] xyzvalue) {
        if (this.fromXYZTransform == null) {
            ICC_Profile xyzProfile = ((ICC_ColorSpace)ColorSpace.getInstance(1001)).getProfile();
            ICC_Profile[] profiles = new ICC_Profile[]{xyzProfile, this.getProfile()};
            try {
                int[] intents = new int[]{0, 1};
                this.fromXYZTransform = new ICC_Transform(profiles, intents);
            }
            catch (CMMException e) {
                this.fromXYZTransform = new ICC_Transform(profiles);
            }
            if (!this.scalingDataLoaded) {
                this.scaler.loadScalingData(this);
                this.scalingDataLoaded = true;
            }
        }
        short[] scaledXYZValue = new short[]{(short)(xyzvalue[0] * 32768.0f + 0.5f), (short)(xyzvalue[1] * 32768.0f + 0.5f), (short)(xyzvalue[2] * 32768.0f + 0.5f)};
        short[] converted = this.converter.translateColor(this.fromXYZTransform, scaledXYZValue, null);
        float[] res = new float[this.getNumComponents()];
        this.scaler.unscale(res, converted, 0);
        return res;
    }

    @Override
    public float getMinValue(int component) {
        if (component < 0 || component > this.getNumComponents() - 1) {
            throw new IllegalArgumentException(Messages.getString("awt.169"));
        }
        return this.minValues[component];
    }

    @Override
    public float getMaxValue(int component) {
        if (component < 0 || component > this.getNumComponents() - 1) {
            throw new IllegalArgumentException(Messages.getString("awt.169"));
        }
        return this.maxValues[component];
    }

    private void fillMinMaxValues() {
        int n = this.getNumComponents();
        this.maxValues = new float[n];
        this.minValues = new float[n];
        switch (this.getType()) {
            case 0: {
                this.minValues[0] = 0.0f;
                this.minValues[1] = 0.0f;
                this.minValues[2] = 0.0f;
                this.maxValues[0] = 1.9999695f;
                this.maxValues[1] = 1.9999695f;
                this.maxValues[2] = 1.9999695f;
                break;
            }
            case 1: {
                this.minValues[0] = 0.0f;
                this.minValues[1] = -128.0f;
                this.minValues[2] = -128.0f;
                this.maxValues[0] = 100.0f;
                this.maxValues[1] = 127.0f;
                this.maxValues[2] = 127.0f;
                break;
            }
            default: {
                for (int i = 0; i < n; ++i) {
                    this.minValues[i] = 0.0f;
                    this.maxValues[i] = 1.0f;
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("thisProfile", this.profile);
        fields.put("minVal", null);
        fields.put("maxVal", null);
        fields.put("diffMinMax", null);
        fields.put("invDiffMinMax", null);
        fields.put("needScaleInit", true);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        this.resolvedDeserializedInst = new ICC_ColorSpace((ICC_Profile)fields.get("thisProfile", null));
    }

    Object readResolve() throws ObjectStreamException {
        return this.resolvedDeserializedInst;
    }
}

