/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import org.apache.harmony.awt.internal.nls.Messages;

public class TexturePaint
implements Paint {
    BufferedImage img;
    Rectangle2D anchor;

    public TexturePaint(BufferedImage img, Rectangle2D anchor) {
        if (img == null) {
            throw new NullPointerException(Messages.getString("awt.114"));
        }
        if (anchor == null) {
            throw new NullPointerException(Messages.getString("awt.115"));
        }
        this.img = img;
        this.anchor = anchor;
    }

    public BufferedImage getImage() {
        return this.img;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle device, Rectangle2D user, AffineTransform t, RenderingHints hints) {
        Object value = hints.get(RenderingHints.KEY_INTERPOLATION);
        boolean bilinear = value != null && value != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        int type = this.img.getType();
        DataBuffer buf = this.img.getRaster().getDataBuffer();
        if (buf instanceof DataBufferInt) {
            if (type == 2 || type == 3 || type == 4 || type == 1) {
                if (bilinear) {
                    return new TexturePaintContext.IntBilinear(this.img, this.anchor, t);
                }
                return new TexturePaintContext.IntSimple(this.img, this.anchor, t);
            }
        } else if (buf instanceof DataBufferByte) {
            if (type == 10) {
                if (bilinear) {
                    return new TexturePaintContext.ByteBilinear(this.img, this.anchor, t);
                }
                return new TexturePaintContext.ByteSimple(this.img, this.anchor, t);
            }
        } else if (buf instanceof DataBufferUShort && type == 11) {
            if (bilinear) {
                return new TexturePaintContext.ShortBilinear(this.img, this.anchor, t);
            }
            return new TexturePaintContext.ShortSimple(this.img, this.anchor, t);
        }
        if (bilinear) {
            if (type != 13) {
                return new TexturePaintContext.CommonBilinear(this.img, this.anchor, t);
            }
        } else {
            return new TexturePaintContext.CommonSimple(this.img, this.anchor, t);
        }
        return new TexturePaintContext(this.img, this.anchor, t);
    }

    @Override
    public int getTransparency() {
        return this.img.getColorModel().getTransparency();
    }

    public Rectangle2D getAnchorRect() {
        return this.anchor;
    }
}

