/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import org.apache.harmony.awt.internal.nls.Messages;

public final class JobAttributes
implements Cloneable {
    private int copies;
    private int fromPage;
    private int maxPage;
    private int minPage;
    private int[][] pageRanges;
    private int firstPage;
    private int lastPage;
    private int toPage;
    private String fileName;
    private String printer;
    private DefaultSelectionType defaultSelection;
    private DestinationType destination;
    private MultipleDocumentHandlingType multiDocHandling;
    private DialogType dialog;
    private SidesType sides;

    public JobAttributes() {
        this.setDefaultSelection(DefaultSelectionType.ALL);
        this.setDestination(DestinationType.PRINTER);
        this.setDialog(DialogType.NATIVE);
        this.setMultipleDocumentHandlingToDefault();
        this.setSidesToDefault();
        this.setCopiesToDefault();
        this.setMaxPage(Integer.MAX_VALUE);
        this.setMinPage(1);
    }

    public JobAttributes(JobAttributes obj) {
        this.set(obj);
    }

    public JobAttributes(int copies, DefaultSelectionType defaultSelection, DestinationType destination, DialogType dialog, String fileName, int maxPage, int minPage, MultipleDocumentHandlingType multipleDocumentHandling, int[][] pageRanges, String printer, SidesType sides) {
        this.setCopies(copies);
        this.setDefaultSelection(defaultSelection);
        this.setDestination(destination);
        this.setDialog(dialog);
        this.setFileName(fileName);
        this.setMinPage(minPage);
        this.setMaxPage(maxPage);
        this.setMultipleDocumentHandling(multipleDocumentHandling);
        this.setPageRanges(pageRanges);
        this.setPrinter(printer);
        this.setSides(sides);
    }

    public void setCopiesToDefault() {
        this.setCopies(1);
    }

    public void setMultipleDocumentHandlingToDefault() {
        this.setMultipleDocumentHandling(MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_UNCOLLATED_COPIES);
    }

    public void setSidesToDefault() {
        this.setSides(SidesType.ONE_SIDED);
    }

    public int getCopies() {
        return this.copies;
    }

    public void setCopies(int copies) {
        if (copies <= 0) {
            throw new IllegalArgumentException(Messages.getString("awt.152"));
        }
        this.copies = copies;
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public void setMaxPage(int imaxPage) {
        if (imaxPage <= 0 || imaxPage < this.minPage) {
            throw new IllegalArgumentException(Messages.getString("awt.153"));
        }
        this.maxPage = imaxPage;
    }

    public int getMinPage() {
        return this.minPage;
    }

    public void setMinPage(int iminPage) {
        if (iminPage <= 0 || iminPage > this.maxPage) {
            throw new IllegalArgumentException(Messages.getString("awt.154"));
        }
        this.minPage = iminPage;
    }

    public int getFromPage() {
        if (this.fromPage != 0) {
            return this.fromPage;
        }
        if (this.toPage != 0) {
            return this.getMinPage();
        }
        if (this.pageRanges != null) {
            return this.firstPage;
        }
        return this.getMinPage();
    }

    public void setFromPage(int ifromPage) {
        if (ifromPage <= 0 || ifromPage > this.toPage || ifromPage < this.minPage || ifromPage > this.maxPage) {
            throw new IllegalArgumentException(Messages.getString("awt.155"));
        }
        this.fromPage = ifromPage;
    }

    public int getToPage() {
        if (this.toPage != 0) {
            return this.toPage;
        }
        if (this.fromPage != 0) {
            return this.fromPage;
        }
        if (this.pageRanges != null) {
            return this.lastPage;
        }
        return this.getMinPage();
    }

    public void setToPage(int itoPage) {
        if (itoPage <= 0 || itoPage < this.fromPage || itoPage < this.minPage || itoPage > this.maxPage) {
            throw new IllegalArgumentException(Messages.getString("awt.156"));
        }
        this.toPage = itoPage;
    }

    public String getPrinter() {
        return this.printer;
    }

    public void setPrinter(String printer) {
        this.printer = printer;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int[][] getPageRanges() {
        int prl = this.pageRanges.length;
        if (this.pageRanges != null) {
            int[][] pr = new int[prl][2];
            for (int i = 0; i < prl; ++i) {
                pr[i][0] = this.pageRanges[i][0];
                pr[i][1] = this.pageRanges[i][1];
            }
            return pr;
        }
        int[][] pr = new int[1][2];
        if (this.fromPage != 0 || this.toPage != 0) {
            pr[0][0] = this.fromPage;
            pr[0][1] = this.toPage;
        } else {
            pr[0][0] = this.minPage;
            pr[0][1] = this.minPage;
        }
        return pr;
    }

    public void setPageRanges(int[][] pr) {
        int k;
        String msg = Messages.getString("awt.157");
        if (pr == null) {
            throw new IllegalArgumentException(msg);
        }
        int n1 = 0;
        int n2 = 0;
        int prl = pr.length;
        for (k = 0; k < prl; ++k) {
            if (pr[k] == null || pr[k].length != 2 || pr[k][0] <= n2 || pr[k][1] < pr[k][0]) {
                throw new IllegalArgumentException(msg);
            }
            n2 = pr[k][1];
            if (n1 != 0) continue;
            n1 = pr[k][0];
        }
        if (n1 < this.minPage || n2 > this.maxPage) {
            throw new IllegalArgumentException(msg);
        }
        this.pageRanges = new int[prl][2];
        for (k = 0; k < prl; ++k) {
            this.pageRanges[k][0] = pr[k][0];
            this.pageRanges[k][1] = pr[k][1];
        }
        this.firstPage = n1;
        this.lastPage = n2;
    }

    public DestinationType getDestination() {
        return this.destination;
    }

    public void setDestination(DestinationType destination) {
        if (destination == null) {
            throw new IllegalArgumentException(Messages.getString("awt.158"));
        }
        this.destination = destination;
    }

    public DialogType getDialog() {
        return this.dialog;
    }

    public void setDialog(DialogType dialog) {
        if (dialog == null) {
            throw new IllegalArgumentException(Messages.getString("awt.159"));
        }
        this.dialog = dialog;
    }

    public DefaultSelectionType getDefaultSelection() {
        return this.defaultSelection;
    }

    public void setDefaultSelection(DefaultSelectionType a_defaultSelection) {
        if (a_defaultSelection == null) {
            throw new IllegalArgumentException(Messages.getString("awt.15A"));
        }
        this.defaultSelection = a_defaultSelection;
    }

    public MultipleDocumentHandlingType getMultipleDocumentHandling() {
        return this.multiDocHandling;
    }

    public void setMultipleDocumentHandling(MultipleDocumentHandlingType multipleDocumentHandling) {
        if (multipleDocumentHandling == null) {
            throw new IllegalArgumentException(Messages.getString("awt.15B"));
        }
        this.multiDocHandling = multipleDocumentHandling;
    }

    public SidesType getSides() {
        return this.sides;
    }

    public void setSides(SidesType sides) {
        if (sides == null) {
            throw new IllegalArgumentException(Messages.getString("awt.15C"));
        }
        this.sides = sides;
    }

    public void set(JobAttributes obj) {
        this.copies = obj.copies;
        this.defaultSelection = obj.defaultSelection;
        this.destination = obj.destination;
        this.dialog = obj.dialog;
        this.fileName = obj.fileName;
        this.printer = obj.printer;
        this.multiDocHandling = obj.multiDocHandling;
        this.firstPage = obj.firstPage;
        this.lastPage = obj.lastPage;
        this.sides = obj.sides;
        this.fromPage = obj.fromPage;
        this.toPage = obj.toPage;
        this.maxPage = obj.maxPage;
        this.minPage = obj.minPage;
        if (obj.pageRanges == null) {
            this.pageRanges = null;
        } else {
            this.setPageRanges(obj.pageRanges);
        }
    }

    public String toString() {
        String s = "Page-ranges [";
        int k = this.pageRanges.length - 1;
        for (int i = 0; i <= k; ++i) {
            s = s + this.pageRanges[i][0] + "-" + this.pageRanges[i][1] + (i < k ? "," : "");
        }
        s = s + "], copies=" + this.getCopies() + ",defSelection=" + this.getDefaultSelection() + ",dest=" + this.getDestination() + ",fromPg=" + this.getFromPage() + ",toPg=" + this.getToPage() + ",minPg=" + this.getMinPage() + ",maxPg=" + this.getMaxPage() + ",multiple-document-handling=" + this.getMultipleDocumentHandling() + ",fileName=" + this.getFileName() + ",printer=" + this.getPrinter() + ",dialog=" + this.getDialog() + ",sides=" + this.getSides();
        return s;
    }

    public int hashCode() {
        int hash = this.toString().hashCode();
        return hash;
    }

    public Object clone() {
        JobAttributes ja = new JobAttributes(this);
        return ja;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobAttributes)) {
            return false;
        }
        JobAttributes ja = (JobAttributes)obj;
        if (this.fileName == null ? ja.fileName != null : !this.fileName.equals(ja.fileName)) {
            return false;
        }
        if (this.printer == null ? ja.printer != null : !this.printer.equals(ja.printer)) {
            return false;
        }
        if (this.pageRanges == null) {
            if (ja.pageRanges != null) {
                return false;
            }
        } else {
            if (ja.pageRanges == null) {
                return false;
            }
            if (this.pageRanges.length != ja.pageRanges.length) {
                return false;
            }
            for (int[] element : this.pageRanges) {
                if (element[0] == element[0] && element[1] == element[1]) continue;
                return false;
            }
        }
        if (this.copies != ja.copies) {
            return false;
        }
        if (this.defaultSelection != ja.defaultSelection) {
            return false;
        }
        if (this.destination != ja.destination) {
            return false;
        }
        if (this.dialog != ja.dialog) {
            return false;
        }
        if (this.maxPage != ja.maxPage) {
            return false;
        }
        if (this.minPage != ja.minPage) {
            return false;
        }
        if (this.multiDocHandling != ja.multiDocHandling) {
            return false;
        }
        if (this.firstPage != ja.firstPage) {
            return false;
        }
        if (this.lastPage != ja.lastPage) {
            return false;
        }
        if (this.sides != ja.sides) {
            return false;
        }
        if (this.toPage != ja.toPage) {
            return false;
        }
        return this.fromPage == ja.fromPage;
    }

    public static final class SidesType {
        public static final SidesType ONE_SIDED = new SidesType(0);
        public static final SidesType TWO_SIDED_LONG_EDGE = new SidesType(1);
        public static final SidesType TWO_SIDED_SHORT_EDGE = new SidesType(2);

        private SidesType(int i) {
        }

        private SidesType() {
            this(0);
        }
    }

    public static final class MultipleDocumentHandlingType {
        public static final MultipleDocumentHandlingType SEPARATE_DOCUMENTS_COLLATED_COPIES = new MultipleDocumentHandlingType(0);
        public static final MultipleDocumentHandlingType SEPARATE_DOCUMENTS_UNCOLLATED_COPIES = new MultipleDocumentHandlingType(1);

        private MultipleDocumentHandlingType(int i) {
        }

        private MultipleDocumentHandlingType() {
            this(0);
        }
    }

    public static final class DialogType {
        public static final DialogType COMMON = new DialogType(0);
        public static final DialogType NATIVE = new DialogType(1);
        public static final DialogType NONE = new DialogType(2);

        private DialogType(int i) {
        }

        private DialogType() {
            this(0);
        }
    }

    public static final class DestinationType {
        public static final DestinationType FILE = new DestinationType(0);
        public static final DestinationType PRINTER = new DestinationType(1);

        private DestinationType(int i) {
        }

        private DestinationType() {
            this(0);
        }
    }

    public static final class DefaultSelectionType {
        public static final DefaultSelectionType ALL = new DefaultSelectionType(0);
        public static final DefaultSelectionType RANGE = new DefaultSelectionType(1);
        public static final DefaultSelectionType SELECTION = new DefaultSelectionType(2);

        private DefaultSelectionType(int i) {
        }

        private DefaultSelectionType() {
            this(0);
        }
    }
}

