/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

class GradientPaintContext
implements PaintContext {
    static int LOOKUP_SIZE = 256;
    static int LOOKUP_MASK = 511;
    static double ZERO = 1.0E-10;
    ColorModel cm;
    boolean cyclic;
    int c1;
    int c2;
    int[] table;
    int dx;
    int dy;
    int delta;

    GradientPaintContext(ColorModel cm, AffineTransform t, Point2D point1, Color color1, Point2D point2, Color color2, boolean cyclic) {
        this.cyclic = cyclic;
        this.cm = ColorModel.getRGBdefault();
        this.c1 = color1.getRGB();
        this.c2 = color2.getRGB();
        double px = point2.getX() - point1.getX();
        double py = point2.getY() - point1.getY();
        Point2D p = t.transform(point1, null);
        Point2D.Double bx = new Point2D.Double(px, py);
        Point2D.Double by = new Point2D.Double(py, -px);
        t.deltaTransform(bx, bx);
        t.deltaTransform(by, by);
        double vec = ((Point2D)bx).getX() * ((Point2D)by).getY() - ((Point2D)bx).getY() * ((Point2D)by).getX();
        if (Math.abs(vec) < ZERO) {
            this.delta = 0;
            this.dy = 0;
            this.dx = 0;
            this.table = new int[1];
            this.table[0] = this.c1;
        } else {
            double mult = (double)(LOOKUP_SIZE * 256) / vec;
            this.dx = (int)(((Point2D)by).getX() * mult);
            this.dy = (int)(((Point2D)by).getY() * mult);
            this.delta = (int)((p.getX() * ((Point2D)by).getY() - p.getY() * ((Point2D)by).getX()) * mult);
            this.createTable();
        }
    }

    void createTable() {
        int i;
        double ca = this.c1 >> 24 & 0xFF;
        double cr = this.c1 >> 16 & 0xFF;
        double cg = this.c1 >> 8 & 0xFF;
        double cb = this.c1 & 0xFF;
        double k = 1.0 / (double)LOOKUP_SIZE;
        double da = ((double)(this.c2 >> 24 & 0xFF) - ca) * k;
        double dr = ((double)(this.c2 >> 16 & 0xFF) - cr) * k;
        double dg = ((double)(this.c2 >> 8 & 0xFF) - cg) * k;
        double db = ((double)(this.c2 & 0xFF) - cb) * k;
        this.table = new int[this.cyclic ? LOOKUP_SIZE + LOOKUP_SIZE : LOOKUP_SIZE];
        for (i = 0; i < LOOKUP_SIZE; ++i) {
            this.table[i] = (int)ca << 24 | (int)cr << 16 | (int)cg << 8 | (int)cb;
            ca += da;
            cr += dr;
            cg += dg;
            cb += db;
        }
        if (this.cyclic) {
            for (i = 0; i < LOOKUP_SIZE; ++i) {
                this.table[GradientPaintContext.LOOKUP_SIZE + GradientPaintContext.LOOKUP_SIZE - 1 - i] = this.table[i];
            }
        }
    }

    @Override
    public ColorModel getColorModel() {
        return this.cm;
    }

    @Override
    public void dispose() {
    }

    @Override
    public Raster getRaster(int x, int y, int w, int h) {
        WritableRaster rast = this.cm.createCompatibleWritableRaster(w, h);
        int[] buf = ((DataBufferInt)rast.getDataBuffer()).getData();
        int c = x * this.dy - y * this.dx - this.delta;
        int cx = this.dy;
        int cy = -w * this.dy - this.dx;
        int k = 0;
        if (this.cyclic) {
            for (int j = 0; j < h; ++j) {
                for (int i = 0; i < w; ++i) {
                    buf[k++] = this.table[c >> 8 & LOOKUP_MASK];
                    c += cx;
                }
                c += cy;
            }
        } else {
            for (int j = 0; j < h; ++j) {
                for (int i = 0; i < w; ++i) {
                    int index = c >> 8;
                    buf[k++] = index < 0 ? this.c1 : (index >= LOOKUP_SIZE ? this.c2 : this.table[index]);
                    c += cx;
                }
                c += cy;
            }
        }
        return rast;
    }
}

