/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import com.github.anastr.speedviewlib.R;
import com.github.anastr.speedviewlib.Speedometer;
import com.github.anastr.speedviewlib.components.Section;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0014J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\u001a\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J(\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007H\u0014J\b\u0010!\u001a\u00020\u0014H\u0014R$\u0010\t\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/github/anastr/speedviewlib/TubeSpeedometer;", "Lcom/github/anastr/speedviewlib/Speedometer;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "speedometerBackColor", "getSpeedometerBackColor", "()I", "setSpeedometerBackColor", "(I)V", "speedometerRect", "Landroid/graphics/RectF;", "tubeBacPaint", "Landroid/graphics/Paint;", "tubePaint", "defaultGaugeValues", "", "defaultSpeedometerValues", "init", "initAttributeSet", "initDraw", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldW", "oldH", "updateBackgroundBitmap", "speedviewlib_release"})
public class TubeSpeedometer
extends Speedometer {
    @NotNull
    private final Paint tubePaint;
    @NotNull
    private final Paint tubeBacPaint;
    @NotNull
    private final RectF speedometerRect;

    @JvmOverloads
    public TubeSpeedometer(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.tubePaint = new Paint(1);
        this.tubeBacPaint = new Paint(1);
        this.speedometerRect = new RectF();
        this.init();
        this.initAttributeSet(context, attrs);
    }

    public /* synthetic */ TubeSpeedometer(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final int getSpeedometerBackColor() {
        return this.tubeBacPaint.getColor();
    }

    public final void setSpeedometerBackColor(int speedometerBackColor) {
        this.tubeBacPaint.setColor(speedometerBackColor);
        this.invalidateGauge();
    }

    @Override
    protected void defaultGaugeValues() {
        super.setSpeedometerWidth(this.dpTOpx(40.0f));
        this.getSections().get(0).setColor(-16728876);
        this.getSections().get(1).setColor(-16121);
        this.getSections().get(2).setColor(-769226);
    }

    @Override
    protected void defaultSpeedometerValues() {
        super.setBackgroundCircleColor(0);
    }

    private final void init() {
        this.tubePaint.setStyle(Paint.Style.STROKE);
        this.tubeBacPaint.setStyle(Paint.Style.STROKE);
        this.tubeBacPaint.setColor(-9079435);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
    }

    private final void initAttributeSet(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TubeSpeedometer, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyledAttributes(attrs, R.styleable.TubeSpeedometer, 0, 0)");
        TypedArray a = typedArray;
        this.tubeBacPaint.setColor(a.getColor(R.styleable.TubeSpeedometer_sv_speedometerBackColor, this.tubeBacPaint.getColor()));
        a.recycle();
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        this.updateBackgroundBitmap();
    }

    private final void initDraw() {
        this.tubePaint.setStrokeWidth(this.getSpeedometerWidth());
        if (this.getCurrentSection() != null) {
            Section section = this.getCurrentSection();
            Intrinsics.checkNotNull((Object)section);
            this.tubePaint.setColor(section.getColor());
        } else {
            this.tubePaint.setColor(0);
        }
    }

    @Override
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.initDraw();
        float sweepAngle = (float)(this.getEndDegree() - this.getStartDegree()) * this.getOffsetSpeed();
        canvas.drawArc(this.speedometerRect, (float)this.getStartDegree(), sweepAngle, false, this.tubePaint);
        this.drawSpeedUnitText(canvas);
        this.drawIndicator(canvas);
        this.drawNotes(canvas);
    }

    @Override
    protected void updateBackgroundBitmap() {
        Canvas c = this.createBackgroundBitmapCanvas();
        this.tubeBacPaint.setStrokeWidth(this.getSpeedometerWidth());
        float risk = this.getSpeedometerWidth() * 0.5f + (float)this.getPadding();
        this.speedometerRect.set(risk, risk, (float)this.getSize() - risk, (float)this.getSize() - risk);
        c.drawArc(this.speedometerRect, (float)this.getStartDegree(), (float)(this.getEndDegree() - this.getStartDegree()), false, this.tubeBacPaint);
        this.drawMarks(c);
        if (this.getTickNumber() > 0) {
            this.drawTicks(c);
        } else {
            this.drawDefMinMaxSpeedPosition(c);
        }
    }

    @JvmOverloads
    public TubeSpeedometer(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TubeSpeedometer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

