/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import com.github.anastr.speedviewlib.R;
import com.github.anastr.speedviewlib.Speedometer;
import com.github.anastr.speedviewlib.components.Section;
import com.github.anastr.speedviewlib.components.indicators.Indicator;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020)H\u0014J\u0006\u0010+\u001a\u00020\u0007J\b\u0010,\u001a\u00020)H\u0002J\u001a\u0010-\u001a\u00020)2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u000200H\u0014J(\u00101\u001a\u00020)2\u0006\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u0007H\u0014J\u000e\u00106\u001a\u00020)2\u0006\u0010\u000b\u001a\u00020\u0007J\u0010\u00107\u001a\u00020)2\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020)H\u0014J\b\u0010;\u001a\u00020)H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010$\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010\u0018\"\u0004\b&\u0010\u001aR\u000e\u0010'\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/github/anastr/speedviewlib/RaySpeedometer;", "Lcom/github/anastr/speedviewlib/Speedometer;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "activeMarkPaint", "Landroid/graphics/Paint;", "degreeBetweenMark", "withEffects", "", "isWithEffects", "()Z", "setWithEffects", "(Z)V", "markPath", "Landroid/graphics/Path;", "ray1Path", "ray2Path", "rayColor", "getRayColor", "()I", "setRayColor", "(I)V", "rayMarkPaint", "markRayWidth", "", "rayMarkWidth", "getRayMarkWidth", "()F", "setRayMarkWidth", "(F)V", "rayPaint", "speedBackgroundColor", "getSpeedBackgroundColor", "setSpeedBackgroundColor", "speedBackgroundPaint", "defaultGaugeValues", "", "defaultSpeedometerValues", "getDegreeBetweenMark", "init", "initAttributeSet", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldW", "oldH", "setDegreeBetweenMark", "setIndicator", "indicator", "Lcom/github/anastr/speedviewlib/components/indicators/Indicator$Indicators;", "updateBackgroundBitmap", "updateMarkPath", "speedviewlib_release"})
public class RaySpeedometer
extends Speedometer {
    @NotNull
    private final Path markPath;
    @NotNull
    private final Path ray1Path;
    @NotNull
    private final Path ray2Path;
    @NotNull
    private final Paint rayMarkPaint;
    @NotNull
    private final Paint activeMarkPaint;
    @NotNull
    private final Paint speedBackgroundPaint;
    @NotNull
    private final Paint rayPaint;
    private boolean withEffects;
    private int degreeBetweenMark;

    @JvmOverloads
    public RaySpeedometer(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.markPath = new Path();
        this.ray1Path = new Path();
        this.ray2Path = new Path();
        this.rayMarkPaint = new Paint(1);
        this.activeMarkPaint = new Paint(1);
        this.speedBackgroundPaint = new Paint(1);
        this.rayPaint = new Paint(1);
        this.withEffects = true;
        this.degreeBetweenMark = 5;
        this.init();
        this.initAttributeSet(context, attrs);
    }

    public /* synthetic */ RaySpeedometer(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final boolean isWithEffects() {
        return this.withEffects;
    }

    public final void setWithEffects(boolean withEffects) {
        this.withEffects = withEffects;
        if (this.isInEditMode()) {
            return;
        }
        this.getIndicator().withEffects(withEffects);
        if (withEffects) {
            this.rayPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(3.0f, BlurMaskFilter.Blur.SOLID));
            this.activeMarkPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(5.0f, BlurMaskFilter.Blur.SOLID));
            this.speedBackgroundPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(8.0f, BlurMaskFilter.Blur.SOLID));
        } else {
            this.rayPaint.setMaskFilter(null);
            this.activeMarkPaint.setMaskFilter(null);
            this.speedBackgroundPaint.setMaskFilter(null);
        }
        this.invalidateGauge();
    }

    public final int getSpeedBackgroundColor() {
        return this.speedBackgroundPaint.getColor();
    }

    public final void setSpeedBackgroundColor(int speedBackgroundColor) {
        this.speedBackgroundPaint.setColor(speedBackgroundColor);
        this.invalidateGauge();
    }

    public final float getRayMarkWidth() {
        return this.rayMarkPaint.getStrokeWidth();
    }

    public final void setRayMarkWidth(float markRayWidth) {
        this.rayMarkPaint.setStrokeWidth(markRayWidth);
        this.activeMarkPaint.setStrokeWidth(markRayWidth);
        if (this.isAttachedToWindow()) {
            this.invalidate();
        }
    }

    public final int getRayColor() {
        return this.rayPaint.getColor();
    }

    public final void setRayColor(int rayColor) {
        this.rayPaint.setColor(rayColor);
        this.invalidateGauge();
    }

    @Override
    protected void defaultGaugeValues() {
        super.setTextColor(-1);
    }

    @Override
    protected void defaultSpeedometerValues() {
        super.setBackgroundCircleColor(-14606047);
        super.setMarkColor(-16777216);
    }

    private final void initAttributeSet(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RaySpeedometer, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyledAttributes(attrs, R.styleable.RaySpeedometer, 0, 0)");
        TypedArray a = typedArray;
        this.rayPaint.setColor(a.getColor(R.styleable.RaySpeedometer_sv_rayColor, this.rayPaint.getColor()));
        int degreeBetweenMark = a.getInt(R.styleable.RaySpeedometer_sv_degreeBetweenMark, this.degreeBetweenMark);
        float rayMarkWidth = a.getDimension(R.styleable.RaySpeedometer_sv_rayMarkWidth, this.rayMarkPaint.getStrokeWidth());
        this.rayMarkPaint.setStrokeWidth(rayMarkWidth);
        this.activeMarkPaint.setStrokeWidth(rayMarkWidth);
        this.speedBackgroundPaint.setColor(a.getColor(R.styleable.RaySpeedometer_sv_speedBackgroundColor, this.speedBackgroundPaint.getColor()));
        this.withEffects = a.getBoolean(R.styleable.RaySpeedometer_sv_withEffects, this.withEffects);
        a.recycle();
        this.setWithEffects(this.withEffects);
        boolean bl = 1 <= degreeBetweenMark ? degreeBetweenMark <= 20 : false;
        if (bl) {
            this.degreeBetweenMark = degreeBetweenMark;
        }
    }

    private final void init() {
        this.rayMarkPaint.setStyle(Paint.Style.STROKE);
        this.rayMarkPaint.setStrokeWidth(this.dpTOpx(3.0f));
        this.activeMarkPaint.setStyle(Paint.Style.STROKE);
        this.activeMarkPaint.setStrokeWidth(this.dpTOpx(3.0f));
        this.rayPaint.setStyle(Paint.Style.STROKE);
        this.rayPaint.setStrokeWidth(this.dpTOpx(1.8f));
        this.rayPaint.setColor(-1);
        this.speedBackgroundPaint.setColor(-1);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
        this.setWithEffects(this.withEffects);
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        this.updateMarkPath();
        this.updateBackgroundBitmap();
    }

    @Override
    protected void onDraw(@NotNull Canvas canvas) {
        RectF speedBackgroundRect;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        canvas.save();
        canvas.rotate((float)this.getStartDegree() + 90.0f, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
        int i = this.getStartDegree();
        while (i < this.getEndDegree()) {
            if (this.getDegree() <= (float)i) {
                this.rayMarkPaint.setColor(this.getMarkColor());
                canvas.drawPath(this.markPath, this.rayMarkPaint);
                canvas.rotate((float)this.degreeBetweenMark, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
                i += this.degreeBetweenMark;
                continue;
            }
            if (this.getCurrentSection() != null) {
                Section section = this.getCurrentSection();
                Intrinsics.checkNotNull((Object)section);
                this.activeMarkPaint.setColor(section.getColor());
            } else {
                this.activeMarkPaint.setColor(0);
            }
            canvas.drawPath(this.markPath, this.activeMarkPaint);
            canvas.rotate((float)this.degreeBetweenMark, (float)this.getSize() * 0.5f, (float)this.getSize() / 2.0f);
            i += this.degreeBetweenMark;
        }
        canvas.restore();
        RectF rectF = speedBackgroundRect = this.getSpeedUnitTextBounds();
        rectF.left -= 2.0f;
        rectF = speedBackgroundRect;
        rectF.right += 2.0f;
        rectF = speedBackgroundRect;
        rectF.bottom += 2.0f;
        canvas.drawRect(speedBackgroundRect, this.speedBackgroundPaint);
        this.drawSpeedUnitText(canvas);
        this.drawIndicator(canvas);
        this.drawNotes(canvas);
    }

    @Override
    protected void updateBackgroundBitmap() {
        Canvas c = this.createBackgroundBitmapCanvas();
        this.updateMarkPath();
        this.ray1Path.reset();
        this.ray1Path.moveTo((float)this.getSize() / 2.0f, (float)this.getSize() / 2.0f);
        this.ray1Path.lineTo((float)this.getSize() / 2.0f, (float)this.getSizePa() / 3.2f + (float)this.getPadding());
        this.ray1Path.moveTo((float)this.getSize() / 2.0f, (float)this.getSizePa() / 3.2f + (float)this.getPadding());
        this.ray1Path.lineTo((float)this.getSize() / 2.2f, (float)this.getSizePa() / 3.0f + (float)this.getPadding());
        this.ray1Path.moveTo((float)this.getSize() / 2.2f, (float)this.getSizePa() / 3.0f + (float)this.getPadding());
        this.ray1Path.lineTo((float)this.getSize() / 2.1f, (float)this.getSizePa() / 4.5f + (float)this.getPadding());
        this.ray2Path.reset();
        this.ray2Path.moveTo((float)this.getSize() / 2.0f, (float)this.getSize() / 2.0f);
        this.ray2Path.lineTo((float)this.getSize() / 2.0f, (float)this.getSizePa() / 3.2f + (float)this.getPadding());
        this.ray2Path.moveTo((float)this.getSize() / 2.0f, (float)this.getSizePa() / 3.2f + (float)this.getPadding());
        this.ray2Path.lineTo((float)this.getSize() / 2.2f, (float)this.getSizePa() / 3.8f + (float)this.getPadding());
        this.ray2Path.moveTo((float)this.getSize() / 2.0f, (float)this.getSizePa() / 3.2f + (float)this.getPadding());
        this.ray2Path.lineTo((float)this.getSize() / 1.8f, (float)this.getSizePa() / 3.8f + (float)this.getPadding());
        c.save();
        int n = 0;
        do {
            int i = n++;
            c.rotate(58.0f, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
            if (i % 2 == 0) {
                c.drawPath(this.ray1Path, this.rayPaint);
                continue;
            }
            c.drawPath(this.ray2Path, this.rayPaint);
        } while (n <= 5);
        c.restore();
        this.drawMarks(c);
        if (this.getTickNumber() > 0) {
            this.drawTicks(c);
        } else {
            this.drawDefMinMaxSpeedPosition(c);
        }
    }

    private final void updateMarkPath() {
        this.markPath.reset();
        this.markPath.moveTo((float)this.getSize() * 0.5f, (float)this.getPadding());
        this.markPath.lineTo((float)this.getSize() * 0.5f, this.getSpeedometerWidth() + (float)this.getPadding());
    }

    @Override
    public void setIndicator(@NotNull Indicator.Indicators indicator) {
        Intrinsics.checkNotNullParameter((Object)((Object)indicator), (String)"indicator");
        super.setIndicator(indicator);
        this.getIndicator().withEffects(this.withEffects);
    }

    public final int getDegreeBetweenMark() {
        return this.degreeBetweenMark;
    }

    public final void setDegreeBetweenMark(int degreeBetweenMark) {
        if (degreeBetweenMark <= 0 || degreeBetweenMark > 20) {
            return;
        }
        this.degreeBetweenMark = degreeBetweenMark;
        if (this.isAttachedToWindow()) {
            this.invalidate();
        }
    }

    @JvmOverloads
    public RaySpeedometer(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public RaySpeedometer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

