/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.Typeface;
import android.util.AttributeSet;
import com.github.anastr.speedviewlib.R;
import com.github.anastr.speedviewlib.Speedometer;
import com.github.anastr.speedviewlib.components.Style;
import com.github.anastr.speedviewlib.components.indicators.Indicator;
import com.github.anastr.speedviewlib.components.indicators.SpindleIndicator;
import com.github.anastr.speedviewlib.util.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020$H\u0014J\u0006\u0010&\u001a\u00020\u0007J\u0006\u0010'\u001a\u00020\u0007J\b\u0010(\u001a\u00020$H\u0002J\u001a\u0010)\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010*\u001a\u00020$H\u0002J\b\u0010+\u001a\u00020$H\u0002J\u0010\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020.H\u0014J(\u0010/\u001a\u00020$2\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0007H\u0014J\u000e\u00104\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u0007J\u000e\u00105\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\u0007J\b\u00106\u001a\u00020$H\u0014J\b\u00107\u001a\u00020$H\u0002J\b\u00108\u001a\u000209H\u0002R$\u0010\t\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00178F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/github/anastr/speedviewlib/PointerSpeedometer;", "Lcom/github/anastr/speedviewlib/Speedometer;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "centerCircleColor", "getCenterCircleColor", "()I", "setCenterCircleColor", "(I)V", "centerCircleRadius", "", "getCenterCircleRadius", "()F", "setCenterCircleRadius", "(F)V", "circlePaint", "Landroid/graphics/Paint;", "withPointer", "", "isWithPointer", "()Z", "setWithPointer", "(Z)V", "pointerBackPaint", "pointerColor", "pointerPaint", "speedometerColor", "speedometerPaint", "speedometerRect", "Landroid/graphics/RectF;", "defaultGaugeValues", "", "defaultSpeedometerValues", "getPointerColor", "getSpeedometerColor", "init", "initAttributeSet", "initAttributeValue", "initDraw", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldW", "oldH", "setPointerColor", "setSpeedometerColor", "updateBackgroundBitmap", "updateRadial", "updateSweep", "Landroid/graphics/SweepGradient;", "speedviewlib_release"})
public class PointerSpeedometer
extends Speedometer {
    @NotNull
    private final Paint speedometerPaint;
    @NotNull
    private final Paint pointerPaint;
    @NotNull
    private final Paint pointerBackPaint;
    @NotNull
    private final Paint circlePaint;
    @NotNull
    private final RectF speedometerRect;
    private int speedometerColor;
    private int pointerColor;
    private boolean withPointer;
    private float centerCircleRadius;

    @JvmOverloads
    public PointerSpeedometer(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.speedometerPaint = new Paint(1);
        this.pointerPaint = new Paint(1);
        this.pointerBackPaint = new Paint(1);
        this.circlePaint = new Paint(1);
        this.speedometerRect = new RectF();
        this.speedometerColor = -1118482;
        this.pointerColor = -1;
        this.withPointer = true;
        this.centerCircleRadius = this.dpTOpx(12.0f);
        this.init();
        this.initAttributeSet(context, attrs);
    }

    public /* synthetic */ PointerSpeedometer(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final int getCenterCircleColor() {
        return this.circlePaint.getColor();
    }

    public final void setCenterCircleColor(int centerCircleColor) {
        this.circlePaint.setColor(centerCircleColor);
        if (this.isAttachedToWindow()) {
            this.invalidate();
        }
    }

    public final float getCenterCircleRadius() {
        return this.centerCircleRadius;
    }

    public final void setCenterCircleRadius(float centerCircleRadius) {
        this.centerCircleRadius = centerCircleRadius;
        if (this.isAttachedToWindow()) {
            this.invalidate();
        }
    }

    public final boolean isWithPointer() {
        return this.withPointer;
    }

    public final void setWithPointer(boolean withPointer) {
        this.withPointer = withPointer;
        if (this.isAttachedToWindow()) {
            this.invalidate();
        }
    }

    @Override
    protected void defaultGaugeValues() {
        super.setSpeedometerWidth(this.dpTOpx(10.0f));
        super.setTextColor(-1);
        super.setSpeedTextColor(-1);
        super.setUnitTextColor(-1);
        super.setSpeedTextSize(this.dpTOpx(24.0f));
        super.setUnitTextSize(this.dpTOpx(11.0f));
        super.setSpeedTextTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
    }

    @Override
    protected void defaultSpeedometerValues() {
        super.setMarksNumber(8);
        super.setMarksPadding(this.getSpeedometerWidth() + this.dpTOpx(12.0f));
        super.setMarkStyle(Style.ROUND);
        super.setMarkHeight(this.dpTOpx(5.0f));
        super.setMarkWidth(this.dpTOpx(2.0f));
        Object object = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context");
        this.setIndicator(new SpindleIndicator((Context)object));
        object = this.getIndicator();
        boolean bl = false;
        boolean bl2 = false;
        Object $this$defaultSpeedometerValues_u24lambda_u2d0 = object;
        boolean bl3 = false;
        ((Indicator)$this$defaultSpeedometerValues_u24lambda_u2d0).setWidth(((Indicator)$this$defaultSpeedometerValues_u24lambda_u2d0).dpTOpx(16.0f));
        ((Indicator)$this$defaultSpeedometerValues_u24lambda_u2d0).setColor(-1);
        super.setBackgroundCircleColor(-12006167);
    }

    private final void init() {
        this.speedometerPaint.setStyle(Paint.Style.STROKE);
        this.speedometerPaint.setStrokeCap(Paint.Cap.ROUND);
        this.circlePaint.setColor(-1);
    }

    private final void initAttributeSet(Context context, AttributeSet attrs) {
        if (attrs == null) {
            this.initAttributeValue();
            return;
        }
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PointerSpeedometer, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyledAttributes(attrs, R.styleable.PointerSpeedometer, 0, 0)");
        TypedArray a = typedArray;
        this.speedometerColor = a.getColor(R.styleable.PointerSpeedometer_sv_speedometerColor, this.speedometerColor);
        this.pointerColor = a.getColor(R.styleable.PointerSpeedometer_sv_pointerColor, this.pointerColor);
        this.circlePaint.setColor(a.getColor(R.styleable.PointerSpeedometer_sv_centerCircleColor, this.circlePaint.getColor()));
        this.setCenterCircleRadius(a.getDimension(R.styleable.SpeedView_sv_centerCircleRadius, this.centerCircleRadius));
        this.withPointer = a.getBoolean(R.styleable.PointerSpeedometer_sv_withPointer, this.withPointer);
        a.recycle();
        this.initAttributeValue();
    }

    private final void initAttributeValue() {
        this.pointerPaint.setColor(this.pointerColor);
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        float risk = this.getSpeedometerWidth() * 0.5f + this.dpTOpx(8.0f) + (float)this.getPadding();
        this.speedometerRect.set(risk, risk, (float)this.getSize() - risk, (float)this.getSize() - risk);
        this.updateRadial();
        this.updateBackgroundBitmap();
    }

    private final void initDraw() {
        this.speedometerPaint.setStrokeWidth(this.getSpeedometerWidth());
        this.speedometerPaint.setShader((Shader)this.updateSweep());
    }

    @Override
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.initDraw();
        float roundAngle = UtilsKt.getRoundAngle(this.getSpeedometerWidth(), this.speedometerRect.width());
        canvas.drawArc(this.speedometerRect, (float)this.getStartDegree() + roundAngle, (float)(this.getEndDegree() - this.getStartDegree()) - roundAngle * 2.0f, false, this.speedometerPaint);
        if (this.withPointer) {
            canvas.save();
            canvas.rotate((float)90 + this.getDegree(), (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
            canvas.drawCircle((float)this.getSize() * 0.5f, this.getSpeedometerWidth() * 0.5f + this.dpTOpx(8.0f) + (float)this.getPadding(), this.getSpeedometerWidth() * 0.5f + this.dpTOpx(8.0f), this.pointerBackPaint);
            canvas.drawCircle((float)this.getSize() * 0.5f, this.getSpeedometerWidth() * 0.5f + this.dpTOpx(8.0f) + (float)this.getPadding(), this.getSpeedometerWidth() * 0.5f + this.dpTOpx(1.0f), this.pointerPaint);
            canvas.restore();
        }
        this.drawSpeedUnitText(canvas);
        this.drawIndicator(canvas);
        int c = this.getCenterCircleColor();
        this.circlePaint.setColor(Color.argb((int)((int)((float)Color.alpha((int)c) * 0.5f)), (int)Color.red((int)c), (int)Color.green((int)c), (int)Color.blue((int)c)));
        canvas.drawCircle((float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f, this.centerCircleRadius + this.dpTOpx(6.0f), this.circlePaint);
        this.circlePaint.setColor(c);
        canvas.drawCircle((float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f, this.centerCircleRadius, this.circlePaint);
        this.drawNotes(canvas);
    }

    @Override
    protected void updateBackgroundBitmap() {
        Canvas c = this.createBackgroundBitmapCanvas();
        this.initDraw();
        this.drawMarks(c);
        if (this.getTickNumber() > 0) {
            this.drawTicks(c);
        } else {
            this.drawDefMinMaxSpeedPosition(c);
        }
    }

    private final SweepGradient updateSweep() {
        int startColor = Color.argb((int)150, (int)Color.red((int)this.speedometerColor), (int)Color.green((int)this.speedometerColor), (int)Color.blue((int)this.speedometerColor));
        int color2 = Color.argb((int)220, (int)Color.red((int)this.speedometerColor), (int)Color.green((int)this.speedometerColor), (int)Color.blue((int)this.speedometerColor));
        int color3 = Color.argb((int)70, (int)Color.red((int)this.speedometerColor), (int)Color.green((int)this.speedometerColor), (int)Color.blue((int)this.speedometerColor));
        int endColor = Color.argb((int)15, (int)Color.red((int)this.speedometerColor), (int)Color.green((int)this.speedometerColor), (int)Color.blue((int)this.speedometerColor));
        float position = this.getOffsetSpeed() * (float)(this.getEndDegree() - this.getStartDegree()) / 360.0f;
        Object[] objectArray = new int[]{startColor, color2, this.speedometerColor, color3, endColor, startColor};
        int[] nArray = objectArray;
        objectArray = new float[6];
        objectArray[0] = (int)0.0f;
        objectArray[1] = (int)(position * 0.5f);
        objectArray[2] = (int)position;
        objectArray[3] = (int)position;
        objectArray[4] = (int)0.99f;
        objectArray[5] = (int)1.0f;
        SweepGradient sweepGradient = new SweepGradient((float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f, nArray, (float[])objectArray);
        Matrix matrix = new Matrix();
        matrix.postRotate((float)this.getStartDegree(), (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
        sweepGradient.setLocalMatrix(matrix);
        return sweepGradient;
    }

    private final void updateRadial() {
        int centerColor = Color.argb((int)160, (int)Color.red((int)this.pointerColor), (int)Color.green((int)this.pointerColor), (int)Color.blue((int)this.pointerColor));
        int edgeColor = Color.argb((int)10, (int)Color.red((int)this.pointerColor), (int)Color.green((int)this.pointerColor), (int)Color.blue((int)this.pointerColor));
        Object[] objectArray = new int[]{centerColor, edgeColor};
        int[] nArray = objectArray;
        objectArray = new float[2];
        objectArray[0] = (int)0.4f;
        objectArray[1] = (int)1.0f;
        RadialGradient pointerGradient = new RadialGradient((float)this.getSize() * 0.5f, this.getSpeedometerWidth() * 0.5f + this.dpTOpx(8.0f) + (float)this.getPadding(), this.getSpeedometerWidth() * 0.5f + this.dpTOpx(8.0f), nArray, (float[])objectArray, Shader.TileMode.CLAMP);
        this.pointerBackPaint.setShader((Shader)pointerGradient);
    }

    public final int getSpeedometerColor() {
        return this.speedometerColor;
    }

    public final void setSpeedometerColor(int speedometerColor) {
        this.speedometerColor = speedometerColor;
        if (this.isAttachedToWindow()) {
            this.invalidate();
        }
    }

    public final int getPointerColor() {
        return this.pointerColor;
    }

    public final void setPointerColor(int pointerColor) {
        this.pointerColor = pointerColor;
        this.pointerPaint.setColor(pointerColor);
        this.updateRadial();
        if (this.isAttachedToWindow()) {
            this.invalidate();
        }
    }

    @JvmOverloads
    public PointerSpeedometer(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public PointerSpeedometer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

