/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import com.github.anastr.speedviewlib.R;
import com.github.anastr.speedviewlib.Speedometer;
import com.github.anastr.speedviewlib.components.Section;
import com.github.anastr.speedviewlib.components.Style;
import com.github.anastr.speedviewlib.components.indicators.Indicator;
import com.github.anastr.speedviewlib.components.indicators.NormalSmallIndicator;
import com.github.anastr.speedviewlib.util.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u00020'H\u0014J\b\u0010)\u001a\u00020'H\u0002J\u001a\u0010*\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010+\u001a\u00020'H\u0002J\b\u0010,\u001a\u00020'H\u0002J\u0010\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020/H\u0014J(\u00100\u001a\u00020'2\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0007H\u0014J\u0010\u00105\u001a\u00020'2\u0006\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u00020'H\u0014R$\u0010\t\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00178F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u000b\"\u0004\b!\u0010\rR\u000e\u0010\"\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/github/anastr/speedviewlib/DeluxeSpeedView;", "Lcom/github/anastr/speedviewlib/Speedometer;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "centerCircleColor", "getCenterCircleColor", "()I", "setCenterCircleColor", "(I)V", "centerCircleRadius", "", "getCenterCircleRadius", "()F", "setCenterCircleRadius", "(F)V", "circlePaint", "Landroid/graphics/Paint;", "withEffects", "", "isWithEffects", "()Z", "setWithEffects", "(Z)V", "smallMarkPaint", "smallMarkPath", "Landroid/graphics/Path;", "speedBackgroundColor", "getSpeedBackgroundColor", "setSpeedBackgroundColor", "speedBackgroundPaint", "speedometerPaint", "speedometerRect", "Landroid/graphics/RectF;", "defaultGaugeValues", "", "defaultSpeedometerValues", "init", "initAttributeSet", "initAttributeValue", "initDraw", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldW", "oldH", "setIndicator", "indicator", "Lcom/github/anastr/speedviewlib/components/indicators/Indicator$Indicators;", "updateBackgroundBitmap", "speedviewlib_release"})
public class DeluxeSpeedView
extends Speedometer {
    @NotNull
    private final Path smallMarkPath;
    @NotNull
    private final Paint circlePaint;
    @NotNull
    private final Paint speedometerPaint;
    @NotNull
    private final Paint smallMarkPaint;
    @NotNull
    private final Paint speedBackgroundPaint;
    @NotNull
    private final RectF speedometerRect;
    private boolean withEffects;
    private float centerCircleRadius;

    @JvmOverloads
    public DeluxeSpeedView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.smallMarkPath = new Path();
        this.circlePaint = new Paint(1);
        this.speedometerPaint = new Paint(1);
        this.smallMarkPaint = new Paint(1);
        this.speedBackgroundPaint = new Paint(1);
        this.speedometerRect = new RectF();
        this.withEffects = true;
        this.centerCircleRadius = this.dpTOpx(20.0f);
        this.init();
        this.initAttributeSet(context, attrs);
    }

    public /* synthetic */ DeluxeSpeedView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final boolean isWithEffects() {
        return this.withEffects;
    }

    public final void setWithEffects(boolean withEffects) {
        this.withEffects = withEffects;
        if (this.isInEditMode()) {
            return;
        }
        this.getIndicator().withEffects(withEffects);
        if (withEffects) {
            this.getMarkPaint().setMaskFilter((MaskFilter)new BlurMaskFilter(5.0f, BlurMaskFilter.Blur.SOLID));
            this.speedBackgroundPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(8.0f, BlurMaskFilter.Blur.SOLID));
            this.circlePaint.setMaskFilter((MaskFilter)new BlurMaskFilter(10.0f, BlurMaskFilter.Blur.SOLID));
        } else {
            this.getMarkPaint().setMaskFilter(null);
            this.speedBackgroundPaint.setMaskFilter(null);
            this.circlePaint.setMaskFilter(null);
        }
        this.invalidateGauge();
    }

    public final int getSpeedBackgroundColor() {
        return this.speedBackgroundPaint.getColor();
    }

    public final void setSpeedBackgroundColor(int speedBackgroundColor) {
        this.speedBackgroundPaint.setColor(speedBackgroundColor);
        this.invalidateGauge();
    }

    public final int getCenterCircleColor() {
        return this.circlePaint.getColor();
    }

    public final void setCenterCircleColor(int centerCircleColor) {
        this.circlePaint.setColor(centerCircleColor);
        if (this.isAttachedToWindow()) {
            this.invalidate();
        }
    }

    public final float getCenterCircleRadius() {
        return this.centerCircleRadius;
    }

    public final void setCenterCircleRadius(float centerCircleRadius) {
        this.centerCircleRadius = centerCircleRadius;
        if (this.isAttachedToWindow()) {
            this.invalidate();
        }
    }

    @Override
    protected void defaultGaugeValues() {
        super.setTextColor(-1);
        this.getSections().get(0).setColor(-13138129);
        this.getSections().get(1).setColor(-6061516);
        this.getSections().get(2).setColor(-6610912);
    }

    @Override
    protected void defaultSpeedometerValues() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        this.setIndicator(new NormalSmallIndicator(context));
        this.getIndicator().setColor(-16711700);
        super.setBackgroundCircleColor(-14606047);
        super.setMarksNumber(8);
    }

    private final void init() {
        this.speedometerPaint.setStyle(Paint.Style.STROKE);
        this.smallMarkPaint.setStyle(Paint.Style.STROKE);
        this.speedBackgroundPaint.setColor(-1);
        this.circlePaint.setColor(-2039584);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
        this.setWithEffects(this.withEffects);
    }

    private final void initAttributeSet(Context context, AttributeSet attrs) {
        if (attrs == null) {
            this.initAttributeValue();
            return;
        }
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.DeluxeSpeedView, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyledAttributes(attrs, R.styleable.DeluxeSpeedView, 0, 0)");
        TypedArray a = typedArray;
        this.speedBackgroundPaint.setColor(a.getColor(R.styleable.DeluxeSpeedView_sv_speedBackgroundColor, this.speedBackgroundPaint.getColor()));
        this.withEffects = a.getBoolean(R.styleable.DeluxeSpeedView_sv_withEffects, this.withEffects);
        this.circlePaint.setColor(a.getColor(R.styleable.DeluxeSpeedView_sv_centerCircleColor, this.circlePaint.getColor()));
        this.setCenterCircleRadius(a.getDimension(R.styleable.DeluxeSpeedView_sv_centerCircleRadius, this.centerCircleRadius));
        int styleIndex = a.getInt(R.styleable.DeluxeSpeedView_sv_sectionStyle, -1);
        if (styleIndex != -1) {
            Iterable $this$forEach$iv = this.getSections();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Section it = (Section)element$iv;
                boolean bl = false;
                it.setStyle(Style.values()[styleIndex]);
            }
        }
        a.recycle();
        this.setWithEffects(this.withEffects);
        this.initAttributeValue();
    }

    private final void initAttributeValue() {
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        this.updateBackgroundBitmap();
    }

    private final void initDraw() {
        this.speedometerPaint.setStrokeWidth(this.getSpeedometerWidth());
        this.smallMarkPaint.setColor(this.getMarkColor());
    }

    @Override
    protected void onDraw(@NotNull Canvas canvas) {
        RectF speedBackgroundRect;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        RectF rectF = speedBackgroundRect = this.getSpeedUnitTextBounds();
        rectF.left -= 2.0f;
        rectF = speedBackgroundRect;
        rectF.right += 2.0f;
        rectF = speedBackgroundRect;
        rectF.bottom += 2.0f;
        canvas.drawRect(speedBackgroundRect, this.speedBackgroundPaint);
        this.drawSpeedUnitText(canvas);
        this.drawIndicator(canvas);
        canvas.drawCircle((float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f, this.centerCircleRadius, this.circlePaint);
        this.drawNotes(canvas);
    }

    @Override
    protected void updateBackgroundBitmap() {
        Canvas c = this.createBackgroundBitmapCanvas();
        this.initDraw();
        float smallMarkH = (float)this.getViewSizePa() / 20.0f;
        this.smallMarkPath.reset();
        this.smallMarkPath.moveTo((float)this.getSize() * 0.5f, this.getSpeedometerWidth() + (float)this.getPadding());
        this.smallMarkPath.lineTo((float)this.getSize() * 0.5f, this.getSpeedometerWidth() + (float)this.getPadding() + smallMarkH);
        this.smallMarkPaint.setStrokeWidth(3.0f);
        Iterable $this$forEach$iv = this.getSections();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Section it = (Section)element$iv;
            boolean bl = false;
            float risk = it.getWidth() * 0.5f + (float)this.getPadding() + it.getPadding();
            this.speedometerRect.set(risk, risk, (float)this.getSize() - risk, (float)this.getSize() - risk);
            this.speedometerPaint.setStrokeWidth(it.getWidth());
            this.speedometerPaint.setColor(it.getColor());
            float startAngle = (float)(this.getEndDegree() - this.getStartDegree()) * it.getStartOffset() + (float)this.getStartDegree();
            float sweepAngle = (float)(this.getEndDegree() - this.getStartDegree()) * it.getEndOffset() - (startAngle - (float)this.getStartDegree());
            if (it.getStyle() == Style.ROUND) {
                float roundAngle = UtilsKt.getRoundAngle(it.getWidth(), this.speedometerRect.width());
                this.speedometerPaint.setStrokeCap(Paint.Cap.ROUND);
                c.drawArc(this.speedometerRect, startAngle + roundAngle, sweepAngle - roundAngle * 2.0f, false, this.speedometerPaint);
                continue;
            }
            this.speedometerPaint.setStrokeCap(Paint.Cap.BUTT);
            c.drawArc(this.speedometerRect, startAngle, sweepAngle, false, this.speedometerPaint);
        }
        c.save();
        c.rotate(90.0f + (float)this.getStartDegree(), (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
        for (float i = (float)this.getStartDegree(); i < (float)this.getEndDegree() - 10.0f; i += 10.0f) {
            c.rotate(10.0f, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
            c.drawPath(this.smallMarkPath, this.smallMarkPaint);
        }
        c.restore();
        this.drawMarks(c);
        if (this.getTickNumber() > 0) {
            this.drawTicks(c);
        } else {
            this.drawDefMinMaxSpeedPosition(c);
        }
    }

    @Override
    public void setIndicator(@NotNull Indicator.Indicators indicator) {
        Intrinsics.checkNotNullParameter((Object)((Object)indicator), (String)"indicator");
        super.setIndicator(indicator);
        this.getIndicator().withEffects(this.withEffects);
    }

    @JvmOverloads
    public DeluxeSpeedView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public DeluxeSpeedView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

