/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib.components.note;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import com.github.anastr.speedviewlib.components.note.Note;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016J \u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010H\u0014J\u0006\u0010\u0019\u001a\u00020\u0010J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/github/anastr/speedviewlib/components/note/TextNote;", "Lcom/github/anastr/speedviewlib/components/note/Note;", "context", "Landroid/content/Context;", "noteText", "", "(Landroid/content/Context;Ljava/lang/CharSequence;)V", "notePaint", "Landroid/text/TextPaint;", "textColor", "", "getTextColor", "()I", "textLayout", "Landroid/text/StaticLayout;", "textSize", "", "build", "", "viewWidth", "drawContains", "canvas", "Landroid/graphics/Canvas;", "leftX", "topY", "getTextSize", "setTextColor", "setTextSize", "setTextTypeFace", "typeface", "Landroid/graphics/Typeface;", "speedviewlib_release"})
public final class TextNote
extends Note<TextNote> {
    private final TextPaint notePaint;
    private float textSize;
    private StaticLayout textLayout;
    private final CharSequence noteText;

    public final int getTextColor() {
        return this.notePaint.getColor();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void build(int viewWidth) {
        this.textLayout = new StaticLayout(this.noteText, this.notePaint, viewWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        int w = 0;
        int n = 0;
        StaticLayout staticLayout = this.textLayout;
        if (staticLayout == null) {
            Intrinsics.throwNpe();
        }
        int n2 = staticLayout.getLineCount();
        while (n < n2) {
            void i;
            float f = w;
            StaticLayout staticLayout2 = this.textLayout;
            if (staticLayout2 == null) {
                Intrinsics.throwNpe();
            }
            float f2 = staticLayout2.getLineWidth((int)i);
            boolean bl = false;
            w = (int)Math.max(f, f2);
            ++i;
        }
        StaticLayout staticLayout3 = this.textLayout;
        if (staticLayout3 == null) {
            Intrinsics.throwNpe();
        }
        this.noticeContainsSizeChange(w, staticLayout3.getHeight());
    }

    @Override
    protected void drawContains(@NotNull Canvas canvas, float leftX, float topY) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.translate(leftX, topY);
        StaticLayout staticLayout = this.textLayout;
        if (staticLayout == null) {
            Intrinsics.throwNpe();
        }
        staticLayout.draw(canvas);
        canvas.restore();
    }

    public final float getTextSize() {
        return this.textSize;
    }

    @NotNull
    public final TextNote setTextSize(float textSize) {
        this.textSize = textSize;
        this.notePaint.setTextSize(textSize);
        return this;
    }

    @NotNull
    public final TextNote setTextTypeFace(@NotNull Typeface typeface) {
        Intrinsics.checkParameterIsNotNull((Object)typeface, (String)"typeface");
        this.notePaint.setTypeface(typeface);
        return this;
    }

    @NotNull
    public final TextNote setTextColor(int textColor) {
        this.notePaint.setColor(textColor);
        return this;
    }

    public TextNote(@NotNull Context context, @Nullable CharSequence noteText) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.noteText = noteText;
        this.notePaint = new TextPaint(1);
        this.textSize = this.notePaint.getTextSize();
        CharSequence charSequence = this.noteText;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null) {
            boolean bl3 = false;
            String string = "noteText cannot be null.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.notePaint.setTextAlign(Paint.Align.LEFT);
    }
}

