/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib.components.indicators;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import com.github.anastr.speedviewlib.Speedometer;
import com.github.anastr.speedviewlib.components.indicators.Indicator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\nH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/github/anastr/speedviewlib/components/indicators/LineIndicator;", "Lcom/github/anastr/speedviewlib/components/indicators/Indicator;", "context", "Landroid/content/Context;", "mode", "", "(Landroid/content/Context;F)V", "indicatorPath", "Landroid/graphics/Path;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "degree", "getBottom", "setWithEffects", "withEffects", "", "updateIndicator", "Companion", "speedviewlib_release"})
public final class LineIndicator
extends Indicator<LineIndicator> {
    private final Path indicatorPath;
    private final float mode;
    public static final float LINE = 1.0f;
    public static final float HALF_LINE = 0.5f;
    public static final float QUARTER_LINE = 0.25f;
    public static final Companion Companion = new Companion(null);

    @Override
    public float getBottom() {
        return this.getCenterY() * this.mode;
    }

    @Override
    public void draw(@NotNull Canvas canvas, float degree) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.rotate(90.0f + degree, this.getCenterX(), this.getCenterY());
        canvas.drawPath(this.indicatorPath, this.getIndicatorPaint());
        canvas.restore();
    }

    @Override
    public void updateIndicator() {
        this.indicatorPath.reset();
        float f = this.getCenterX();
        Speedometer speedometer = this.getSpeedometer();
        if (speedometer == null) {
            Intrinsics.throwNpe();
        }
        this.indicatorPath.moveTo(f, (float)speedometer.getPadding());
        this.indicatorPath.lineTo(this.getCenterX(), this.getCenterY() * this.mode);
        this.getIndicatorPaint().setStyle(Paint.Style.STROKE);
        this.getIndicatorPaint().setStrokeWidth(this.getWidth());
        this.getIndicatorPaint().setColor(this.getColor());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void setWithEffects(boolean withEffects) {
        if (withEffects) {
            Speedometer speedometer = this.getSpeedometer();
            if (speedometer == null) {
                Intrinsics.throwNpe();
            }
            if (!speedometer.isInEditMode()) {
                this.getIndicatorPaint().setMaskFilter((MaskFilter)new BlurMaskFilter(15.0f, BlurMaskFilter.Blur.SOLID));
                return;
            }
        }
        this.getIndicatorPaint().setMaskFilter((MaskFilter)null);
    }

    public LineIndicator(@NotNull Context context, float mode) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.mode = mode;
        this.indicatorPath = new Path();
        this.setWidth(this.dpTOpx(8.0f));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/anastr/speedviewlib/components/indicators/LineIndicator$Companion;", "", "()V", "HALF_LINE", "", "LINE", "QUARTER_LINE", "speedviewlib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

