/*
 * Decompiled with CFR 0.152.
 */
package com.downloader.internal;

import com.downloader.Error;
import com.downloader.Priority;
import com.downloader.Response;
import com.downloader.Status;
import com.downloader.internal.DownloadTask;
import com.downloader.request.DownloadRequest;

public class DownloadRunnable
implements Runnable {
    public final Priority priority;
    public final int sequence;
    public final DownloadRequest request;

    DownloadRunnable(DownloadRequest request) {
        this.request = request;
        this.priority = request.getPriority();
        this.sequence = request.getSequenceNumber();
    }

    @Override
    public void run() {
        this.request.setStatus(Status.RUNNING);
        DownloadTask downloadTask = DownloadTask.create(this.request);
        Response response = downloadTask.run();
        if (response.isSuccessful()) {
            this.request.deliverSuccess();
        } else if (response.isPaused()) {
            this.request.deliverPauseEvent();
        } else if (response.getError() != null) {
            this.request.deliverError(response.getError());
        } else if (!response.isCancelled()) {
            this.request.deliverError(new Error());
        }
    }
}

