/*
 * Decompiled with CFR 0.152.
 */
package am.leon;

import am.leon.FullScreenPhotoFragment;
import am.leon.LeonMedia;
import am.leon.LeonObject;
import am.leon.Media;
import am.leon.Utils;
import android.content.Context;
import android.net.Uri;
import android.view.View;
import java.io.File;
import java.util.List;

class OnImageClickListener
implements View.OnClickListener,
FullScreenPhotoFragment.FullScreenStatus {
    private View view;
    private Context context;
    private LeonObject leonObject;

    OnImageClickListener(Context context) {
        this.context = context;
        this.leonObject = new LeonObject();
    }

    void setImage(LeonMedia leonMedia) {
        switch (leonMedia.getType()) {
            case URI: {
                this.setImage((Uri)leonMedia.getObject());
                break;
            }
            case MEDIA: {
                this.setImage((Media)leonMedia.getObject());
                break;
            }
            case FILE: {
                this.setImage((File)leonMedia.getObject());
                break;
            }
            case STRING: {
                this.setImage((String)leonMedia.getObject());
                break;
            }
            case RESOURCE: {
                this.setImage((Integer)leonMedia.getObject());
            }
        }
    }

    private void setImage(Uri uri) {
        this.leonObject.getUriList().clear();
        this.leonObject.setImage(uri);
    }

    private void setImage(Media media) {
        this.leonObject.getMediaList().clear();
        this.leonObject.setImage(media);
    }

    private void setImage(File file) {
        this.leonObject.getFileList().clear();
        this.leonObject.setImage(file);
    }

    private void setImage(String path) {
        this.leonObject.getStringList().clear();
        this.leonObject.setImage(path);
    }

    private void setImage(int res) {
        this.leonObject.getResList().clear();
        this.leonObject.setImage(res);
    }

    void setUriImages(List<Uri> uriList, int currentPosition, String appLanguage) {
        this.leonObject.setUriList(uriList);
        this.leonObject.setCurrentPosition(currentPosition);
        this.leonObject.setAppLanguage(appLanguage);
    }

    void setMediaImages(List<Media> mediaList, int currentPosition, String appLanguage) {
        this.leonObject.setMediaList(mediaList);
        this.leonObject.setCurrentPosition(currentPosition);
        this.leonObject.setAppLanguage(appLanguage);
    }

    void setFileImages(List<File> fileList, int currentPosition, String appLanguage) {
        this.leonObject.setFileList(fileList);
        this.leonObject.setCurrentPosition(currentPosition);
        this.leonObject.setAppLanguage(appLanguage);
    }

    void setStringImages(List<String> stringList, int currentPosition, String appLanguage) {
        this.leonObject.setStringList(stringList);
        this.leonObject.setCurrentPosition(currentPosition);
        this.leonObject.setAppLanguage(appLanguage);
    }

    void setResImages(List<Integer> resList, int currentPosition, String appLanguage) {
        this.leonObject.setResList(resList);
        this.leonObject.setCurrentPosition(currentPosition);
        this.leonObject.setAppLanguage(appLanguage);
    }

    public void onClick(View view) {
        this.view = view;
        FullScreenPhotoFragment.getInstance(this.leonObject, this).show(Utils.unwrap(this.context).getSupportFragmentManager(), this.getClass().getName());
    }

    @Override
    public void fullScreenStatus(boolean status) {
        if (status) {
            this.view.setEnabled(false);
        } else {
            this.view.setEnabled(true);
        }
    }

    void setReloadImageRes(int reloadImageRes) {
        this.leonObject.setReloadImageRes(reloadImageRes);
    }

    void setDefaultImageRes(int defaultImageRes) {
        this.leonObject.setDefaultImageRes(defaultImageRes);
    }

    void setVideoPlayImageRes(int videoPlayImageRes) {
        this.leonObject.setVideoPlayImageRes(videoPlayImageRes);
    }

    void setPlaceHolderImageRes(int placeHolderImageRes) {
        this.leonObject.setPlaceHolderImageRes(placeHolderImageRes);
    }
}

