/*
 * Decompiled with CFR 0.152.
 */
package am.leon;

import am.leon.LeonMedia;
import am.leon.Media;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class LeonObject
implements Parcelable {
    private String appLanguage;
    private int currentPosition;
    private List<Uri> uriList;
    private List<Media> mediaList;
    private List<File> fileList;
    private List<String> stringList;
    private List<Integer> resList;
    private int reloadImageRes;
    private int defaultImageRes;
    private int videoPlayImageRes;
    private int placeHolderImageRes;
    public static final Parcelable.Creator<LeonObject> CREATOR = new Parcelable.Creator<LeonObject>(){

        public LeonObject createFromParcel(Parcel in) {
            return new LeonObject(in);
        }

        public LeonObject[] newArray(int size) {
            return new LeonObject[size];
        }
    };

    LeonObject() {
        this.uriList = new ArrayList<Uri>();
        this.mediaList = new ArrayList<Media>();
        this.fileList = new ArrayList<File>();
        this.stringList = new ArrayList<String>();
        this.resList = new ArrayList<Integer>();
    }

    public void clear() {
        this.uriList.clear();
        this.mediaList.clear();
        this.fileList.clear();
        this.stringList.clear();
        this.resList.clear();
        this.placeHolderImageRes = 0;
        this.videoPlayImageRes = 0;
        this.defaultImageRes = 0;
        this.reloadImageRes = 0;
    }

    public void clearImages() {
        this.uriList.clear();
        this.mediaList.clear();
        this.fileList.clear();
        this.stringList.clear();
        this.resList.clear();
    }

    List<LeonMedia> getLeonMedia() {
        ArrayList<LeonMedia> list = new ArrayList<LeonMedia>();
        try {
            if (this.getUriList().size() != 0) {
                for (Uri uri : this.getUriList()) {
                    list.add(LeonMedia.getLeonMedia(uri));
                }
            } else if (this.getMediaList().size() != 0) {
                for (Media media : this.getMediaList()) {
                    list.add(LeonMedia.getLeonMedia(media));
                }
            } else if (this.getFileList().size() != 0) {
                for (File file : this.getFileList()) {
                    list.add(LeonMedia.getLeonMedia(file));
                }
            } else if (this.getStringList().size() != 0) {
                for (String path : this.getStringList()) {
                    list.add(LeonMedia.getLeonMedia(path));
                }
            } else if (this.getResList().size() != 0) {
                for (Integer res : this.getResList()) {
                    list.add(LeonMedia.getLeonMedia(res));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private LeonObject(Parcel in) {
        this.appLanguage = in.readString();
        this.currentPosition = in.readInt();
        this.uriList = in.createTypedArrayList(Uri.CREATOR);
        this.mediaList = in.createTypedArrayList(Media.CREATOR);
        this.stringList = in.createStringArrayList();
        this.reloadImageRes = in.readInt();
        this.defaultImageRes = in.readInt();
        this.videoPlayImageRes = in.readInt();
        this.placeHolderImageRes = in.readInt();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.appLanguage);
        dest.writeInt(this.currentPosition);
        dest.writeTypedList(this.uriList);
        dest.writeTypedList(this.mediaList);
        dest.writeStringList(this.stringList);
        dest.writeInt(this.reloadImageRes);
        dest.writeInt(this.defaultImageRes);
        dest.writeInt(this.videoPlayImageRes);
        dest.writeInt(this.placeHolderImageRes);
    }

    public int describeContents() {
        return 0;
    }

    String getAppLanguage() {
        return this.appLanguage;
    }

    void setAppLanguage(String appLanguage) {
        this.appLanguage = appLanguage;
    }

    int getCurrentPosition() {
        return this.currentPosition;
    }

    void setCurrentPosition(int currentPosition) {
        this.currentPosition = currentPosition;
    }

    void setImage(Uri uri) {
        this.uriList.add(uri);
    }

    List<Uri> getUriList() {
        return this.uriList;
    }

    void setUriList(List<Uri> uriList) {
        this.uriList = uriList;
    }

    void setImage(Media media) {
        this.mediaList.add(media);
    }

    public List<Media> getMediaList() {
        return this.mediaList;
    }

    public void setMediaList(List<Media> mediaList) {
        this.mediaList = mediaList;
    }

    void setImage(File file) {
        this.fileList.add(file);
    }

    List<File> getFileList() {
        return this.fileList;
    }

    void setFileList(List<File> fileList) {
        this.fileList = fileList;
    }

    void setImage(String path) {
        this.stringList.add(path);
    }

    List<String> getStringList() {
        return this.stringList;
    }

    void setStringList(List<String> stringList) {
        this.stringList = stringList;
    }

    void setImage(int res) {
        this.resList.add(res);
    }

    List<Integer> getResList() {
        return this.resList;
    }

    void setResList(List<Integer> resList) {
        this.resList = resList;
    }

    int getReloadImageRes() {
        return this.reloadImageRes;
    }

    void setReloadImageRes(int reloadImageRes) {
        this.reloadImageRes = reloadImageRes;
    }

    int getDefaultImageRes() {
        return this.defaultImageRes;
    }

    void setDefaultImageRes(int defaultImageRes) {
        this.defaultImageRes = defaultImageRes;
    }

    int getVideoPlayImageRes() {
        return this.videoPlayImageRes;
    }

    void setVideoPlayImageRes(int videoPlayImageRes) {
        this.videoPlayImageRes = videoPlayImageRes;
    }

    int getPlaceHolderImageRes() {
        return this.placeHolderImageRes;
    }

    void setPlaceHolderImageRes(int placeHolderImageRes) {
        this.placeHolderImageRes = placeHolderImageRes;
    }
}

