/*
 * Decompiled with CFR 0.152.
 */
package am.leon;

import am.leon.LeonMedia;
import am.leon.Media;
import am.leon.OnImageClickListener;
import am.leon.PicassoCallback;
import am.leon.R;
import am.leon.TouchImageView;
import am.leon.Utils;
import android.content.Context;
import android.content.res.TypedArray;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.squareup.picasso.Callback;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Transformation;
import java.io.File;
import java.util.List;

public class LeonImageView
extends TouchImageView {
    private OnImageClickListener onImageClickListener;
    private int reloadImageRes;
    private int defaultImageRes;
    private int videoPlayImageRes;
    private int placeHolderImageRes;

    public LeonImageView(Context context) {
        this(context, null);
    }

    public LeonImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LeonImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.viewInit(context);
        this.setTypedArrayValues(context, attrs, defStyle);
    }

    private void viewInit(Context context) {
        this.onImageClickListener = new OnImageClickListener(context);
        this.setOnClickListener(this.onImageClickListener);
    }

    private void setTypedArrayValues(Context context, AttributeSet attrs, int defStyle) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.LeonImageView, defStyle, 0);
        this.setReloadImageRes(typedArray.getResourceId(R.styleable.LeonImageView_leon_reload_icon, R.drawable.layer_reload));
        this.setDefaultImageRes(typedArray.getResourceId(R.styleable.LeonImageView_leon_default_icon, R.drawable.ic_default));
        this.setVideoPlayImageRes(typedArray.getResourceId(R.styleable.LeonImageView_leon_play_video_icon, R.drawable.ic_play_colored));
        this.setPlaceHolderImageRes(typedArray.getResourceId(R.styleable.LeonImageView_leon_place_holder_icon, R.drawable.layer_place_holder));
        typedArray.recycle();
    }

    private void setTypedArrayValues(Context context, int leonImageViewStyle) {
        int[] attrs = new int[]{R.attr.leon_reload_icon, R.attr.leon_default_icon, R.attr.leon_play_video_icon, R.attr.leon_play_video_icon};
        TypedArray typedArray = context.obtainStyledAttributes(leonImageViewStyle, attrs);
        this.setReloadImageRes(typedArray.getResourceId(R.styleable.LeonImageView_leon_reload_icon, R.drawable.layer_reload));
        this.setDefaultImageRes(typedArray.getResourceId(R.styleable.LeonImageView_leon_default_icon, R.drawable.ic_default));
        this.setVideoPlayImageRes(typedArray.getResourceId(R.styleable.LeonImageView_leon_play_video_icon, R.drawable.ic_play_colored));
        this.setPlaceHolderImageRes(typedArray.getResourceId(R.styleable.LeonImageView_leon_place_holder_icon, R.drawable.layer_place_holder));
        typedArray.recycle();
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        if (l == null) {
            super.setOnClickListener(null);
        } else {
            super.setOnClickListener(l);
        }
    }

    public int getReloadImageRes() {
        return this.reloadImageRes;
    }

    public void setReloadImageRes(int reloadImageRes) {
        this.reloadImageRes = reloadImageRes;
        this.onImageClickListener.setReloadImageRes(reloadImageRes);
    }

    public int getDefaultImageRes() {
        return this.defaultImageRes;
    }

    public void setDefaultImageRes(int defaultImageRes) {
        this.defaultImageRes = defaultImageRes;
        this.onImageClickListener.setDefaultImageRes(defaultImageRes);
    }

    public int getVideoPlayImageRes() {
        return this.videoPlayImageRes;
    }

    public void setVideoPlayImageRes(int videoPlayImageRes) {
        this.videoPlayImageRes = videoPlayImageRes;
        this.onImageClickListener.setVideoPlayImageRes(videoPlayImageRes);
    }

    public int getPlaceHolderImageRes() {
        return this.placeHolderImageRes;
    }

    public void setPlaceHolderImageRes(int placeHolderImageRes) {
        this.placeHolderImageRes = placeHolderImageRes;
        this.onImageClickListener.setPlaceHolderImageRes(placeHolderImageRes);
    }

    public void loadImage(Object object) {
        try {
            this.executePicasso(LeonMedia.getLeonMedia(object));
            this.onImageClickListener.setImage(LeonMedia.getLeonMedia(object));
        }
        catch (Exception e) {
            this.setImageResource(this.getDefaultImageRes());
            e.printStackTrace();
        }
    }

    public void loadImage(Object object, Transformation transformation) {
        try {
            this.executePicasso(LeonMedia.getLeonMedia(object), transformation);
            this.onImageClickListener.setImage(LeonMedia.getLeonMedia(object));
        }
        catch (Exception e) {
            this.setImageResource(this.getDefaultImageRes());
            e.printStackTrace();
        }
    }

    public void loadUriImages(List<Uri> uriList) {
        this.onImageClickListener.setUriImages(uriList, 0, "en");
    }

    public void loadUriImages(List<Uri> uriList, int currentPosition) {
        this.onImageClickListener.setUriImages(uriList, currentPosition, "en");
    }

    public void loadUriImages(List<Uri> uriList, int currentPosition, String appLanguage) {
        this.onImageClickListener.setUriImages(uriList, currentPosition, appLanguage);
    }

    public void loadMediaImages(List<Media> mediaList) {
        this.onImageClickListener.setMediaImages(mediaList, 0, "en");
    }

    public void loadMediaImages(List<Media> mediaList, int currentPosition) {
        this.onImageClickListener.setMediaImages(mediaList, currentPosition, "en");
    }

    public void loadMediaImages(List<Media> mediaList, int currentPosition, String appLanguage) {
        this.onImageClickListener.setMediaImages(mediaList, currentPosition, appLanguage);
    }

    public void loadFileImages(List<File> fileList) {
        this.onImageClickListener.setFileImages(fileList, 0, "en");
    }

    public void loadFileImages(List<File> fileList, int currentPosition) {
        this.onImageClickListener.setFileImages(fileList, currentPosition, "en");
    }

    public void loadFileImages(List<File> fileList, int currentPosition, String appLanguage) {
        this.onImageClickListener.setFileImages(fileList, currentPosition, appLanguage);
    }

    public void loadImages(List<String> stringList) {
        this.onImageClickListener.setStringImages(stringList, 0, "en");
    }

    public void loadImages(List<String> stringList, int currentPosition) {
        this.onImageClickListener.setStringImages(stringList, currentPosition, "en");
    }

    public void loadImages(List<String> stringList, int currentPosition, String appLanguage) {
        this.onImageClickListener.setStringImages(stringList, currentPosition, appLanguage);
    }

    public void loadResImages(List<Integer> resList) {
        this.onImageClickListener.setResImages(resList, 0, "en");
    }

    public void loadResImages(List<Integer> resList, int currentPosition) {
        this.onImageClickListener.setResImages(resList, currentPosition, "en");
    }

    public void loadResImages(List<Integer> resList, int currentPosition, String appLanguage) {
        this.onImageClickListener.setResImages(resList, currentPosition, appLanguage);
    }

    private void executePicasso(LeonMedia leonMedia) {
        Picasso picasso = Picasso.get();
        switch (leonMedia.getType()) {
            case URI: {
                picasso.load((Uri)leonMedia.getObject()).placeholder(this.getPlaceHolderImageRes()).error(this.getReloadImageRes()).into((ImageView)this, (Callback)new PicassoCallback(this, leonMedia));
                break;
            }
            case MEDIA: {
                picasso.load(Utils.getMediaPath((Media)leonMedia.getObject())).placeholder(this.getPlaceHolderImageRes()).error(this.getReloadImageRes()).into((ImageView)this, (Callback)new PicassoCallback(this, leonMedia));
                break;
            }
            case FILE: {
                picasso.load((File)leonMedia.getObject()).placeholder(this.getPlaceHolderImageRes()).error(this.getReloadImageRes()).into((ImageView)this, (Callback)new PicassoCallback(this, leonMedia));
                break;
            }
            case STRING: {
                picasso.load(Utils.getStringPath((String)leonMedia.getObject())).placeholder(this.getPlaceHolderImageRes()).error(this.getReloadImageRes()).into((ImageView)this, (Callback)new PicassoCallback(this, leonMedia));
                break;
            }
            case RESOURCE: {
                this.setImageResource((Integer)leonMedia.getObject());
            }
        }
    }

    private void executePicasso(LeonMedia leonMedia, Transformation transformation) {
        Picasso picasso = Picasso.get();
        switch (leonMedia.getType()) {
            case URI: {
                picasso.load((Uri)leonMedia.getObject()).placeholder(this.getPlaceHolderImageRes()).error(this.getReloadImageRes()).transform(transformation).into((ImageView)this, (Callback)new PicassoCallback(this, leonMedia, transformation));
                break;
            }
            case MEDIA: {
                picasso.load(Utils.getMediaPath((Media)leonMedia.getObject())).placeholder(this.getPlaceHolderImageRes()).error(this.getReloadImageRes()).transform(transformation).into((ImageView)this, (Callback)new PicassoCallback(this, leonMedia, transformation));
                break;
            }
            case FILE: {
                picasso.load((File)leonMedia.getObject()).placeholder(this.getPlaceHolderImageRes()).error(this.getReloadImageRes()).transform(transformation).into((ImageView)this, (Callback)new PicassoCallback(this, leonMedia, transformation));
                break;
            }
            case STRING: {
                picasso.load(Utils.getStringPath((String)leonMedia.getObject())).placeholder(this.getPlaceHolderImageRes()).error(this.getReloadImageRes()).transform(transformation).into((ImageView)this, (Callback)new PicassoCallback(this, leonMedia, transformation));
                break;
            }
            case RESOURCE: {
                this.setImageResource((Integer)leonMedia.getObject());
            }
        }
    }

    public void show() {
        this.onImageClickListener.onClick((View)this);
    }
}

