/*
 * Decompiled with CFR 0.152.
 */
package am.leon;

import am.leon.FullScreenImageAdapter;
import am.leon.LeonObject;
import am.leon.R;
import am.leon.swipePackage.SwipeDialogFragment;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;

public class FullScreenPhotoFragment
extends SwipeDialogFragment
implements FullScreenImageAdapter.ImageZoomCallback {
    private View view;
    private ViewPager2 viewpager;
    private LeonObject leonObject;
    private FullScreenImageAdapter adapter;
    private FullScreenStatus fullScreenStatus;
    private static final String LEON_TAG = "leon_tag";

    public void onDismiss(@NonNull DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.getActivity() instanceof DialogInterface.OnDismissListener) {
            ((DialogInterface.OnDismissListener)this.getActivity()).onDismiss(dialog);
        }
    }

    static FullScreenPhotoFragment getInstance(LeonObject leonObject, FullScreenStatus fullScreenStatus) {
        FullScreenPhotoFragment sheet = new FullScreenPhotoFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable(LEON_TAG, (Parcelable)leonObject);
        sheet.fullScreenStatus = fullScreenStatus;
        sheet.setArguments(bundle);
        return sheet;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.leonObject = (LeonObject)this.getArguments().getParcelable(LEON_TAG);
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (this.getDialog() != null) {
            Window window = this.getDialog().getWindow();
            window.setLayout(-1, -1);
            window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            window.getAttributes().windowAnimations = R.style.DialogAnimation;
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.view = inflater.inflate(R.layout.fragment_media_dialog, null);
        this.viewInit();
        this.fullScreenStatus.fullScreenStatus(true);
        this.viewpager.setCurrentItem(this.leonObject.getCurrentPosition(), false);
        return this.view;
    }

    private void viewInit() {
        this.viewpager = (ViewPager2)this.view.findViewById(R.id.leon_viewpager);
        this.adapter = new FullScreenImageAdapter(this.getContext(), this.leonObject, this);
        this.viewpager.setAdapter((RecyclerView.Adapter)this.adapter);
        if (this.leonObject.getAppLanguage() != null && this.leonObject.getAppLanguage().equals("ar")) {
            this.viewpager.setLayoutDirection(1);
        }
    }

    public void onCancel(@NonNull DialogInterface dialog) {
        this.fullScreenStatus.fullScreenStatus(false);
        super.onCancel(dialog);
    }

    public void dismiss() {
        this.fullScreenStatus.fullScreenStatus(false);
        super.dismiss();
    }

    @Override
    public void isZoomed(boolean isZoomed) {
        this.setSwipeable(!isZoomed);
        this.viewpager.setUserInputEnabled(!isZoomed);
    }

    public static interface FullScreenStatus {
        public void fullScreenStatus(boolean var1);
    }
}

