/*
 * Decompiled with CFR 0.152.
 */
package am.leon;

import am.leon.LeonImageView;
import am.leon.LeonMedia;
import am.leon.LeonObject;
import am.leon.Media;
import am.leon.R;
import am.leon.TouchImageView;
import am.leon.Utils;
import android.content.Context;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.recyclerview.widget.RecyclerView;
import com.squareup.picasso.Callback;
import com.squareup.picasso.Picasso;
import java.io.File;

class FullScreenImageAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context context;
    private LeonObject leonObject;
    private ImageZoomCallback zoomCallback;

    FullScreenImageAdapter(Context context, LeonObject leonObject, ImageZoomCallback zoomCallback) {
        this.context = context;
        this.leonObject = leonObject;
        this.zoomCallback = zoomCallback;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.item_media, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        LeonMedia leonMedia = this.leonObject.getLeonMedia().get(position);
        holder.imageView.setScaleX(0.1f);
        holder.imageView.setScaleY(0.1f);
        holder.imageView.setZoomEnabled(false);
        holder.handleLeonMedia(leonMedia);
    }

    public int getItemCount() {
        return this.leonObject.getLeonMedia().size();
    }

    static interface ImageZoomCallback {
        public void isZoomed(boolean var1);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder
    implements TouchImageView.OnTouchImageViewListener,
    View.OnClickListener,
    Callback {
        private LeonImageView imageView;
        private AppCompatImageView ic_video;
        private boolean loadingError;

        ViewHolder(View itemView) {
            super(itemView);
            this.loadingError = false;
            this.ic_video = (AppCompatImageView)itemView.findViewById(R.id.videoImage);
            this.imageView = (LeonImageView)itemView.findViewById(R.id.image);
            this.imageView.setOnTouchImageViewListener(this);
            this.imageView.setOnClickListener(null);
            this.imageView.setPlaceHolderImageRes(FullScreenImageAdapter.this.leonObject.getPlaceHolderImageRes());
            this.imageView.setDefaultImageRes(FullScreenImageAdapter.this.leonObject.getDefaultImageRes());
            this.imageView.setReloadImageRes(FullScreenImageAdapter.this.leonObject.getReloadImageRes());
            this.ic_video.setImageResource(FullScreenImageAdapter.this.leonObject.getVideoPlayImageRes());
        }

        @Override
        public void onMove() {
            if (FullScreenImageAdapter.this.zoomCallback != null) {
                FullScreenImageAdapter.this.zoomCallback.isZoomed(this.imageView.isZoomed());
            }
        }

        private void handleLeonMedia(LeonMedia leonMedia) {
            switch (leonMedia.getType()) {
                case URI: {
                    this.executePicasso((Uri)leonMedia.getObject());
                    break;
                }
                case MEDIA: {
                    this.executePicasso(Utils.getMediaPath((Media)leonMedia.getObject()));
                    break;
                }
                case FILE: {
                    this.executePicasso((File)leonMedia.getObject());
                    break;
                }
                case STRING: {
                    String path = (String)leonMedia.getObject();
                    if (path.contains("http")) {
                        this.executePicasso(path);
                        break;
                    }
                    this.executePicasso("file://" + path);
                    break;
                }
                case RESOURCE: {
                    this.imageView.setImageResource((Integer)leonMedia.getObject());
                }
            }
        }

        private void handleMediaObject(Media media) {
            if (media.getType().equals("video")) {
                this.ic_video.setVisibility(0);
                this.imageView.setOnClickListener(this);
                this.imageView.setZoomEnabled(false);
            } else {
                this.ic_video.setVisibility(8);
            }
        }

        private void executePicasso(Uri uri) {
            Picasso.get().load(uri).placeholder(FullScreenImageAdapter.this.leonObject.getPlaceHolderImageRes()).error(FullScreenImageAdapter.this.leonObject.getReloadImageRes()).into((ImageView)this.imageView, (Callback)this);
        }

        private void executePicasso(File file) {
            Picasso.get().load(file).placeholder(FullScreenImageAdapter.this.leonObject.getPlaceHolderImageRes()).error(FullScreenImageAdapter.this.leonObject.getReloadImageRes()).into((ImageView)this.imageView, (Callback)this);
        }

        private void executePicasso(String path) {
            Picasso.get().load(path).placeholder(FullScreenImageAdapter.this.leonObject.getPlaceHolderImageRes()).error(FullScreenImageAdapter.this.leonObject.getReloadImageRes()).into((ImageView)this.imageView, (Callback)this);
        }

        public void onSuccess() {
            this.loadingError = false;
            this.imageView.setScaleX(1.0f);
            this.imageView.setScaleY(1.0f);
            this.imageView.setZoomEnabled(true);
            try {
                LeonMedia leonMedia = FullScreenImageAdapter.this.leonObject.getLeonMedia().get(this.getAdapterPosition());
                if (leonMedia.getType().equals((Object)LeonMedia.LeonMediaType.MEDIA)) {
                    this.handleMediaObject((Media)leonMedia.getObject());
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }

        public void onError(Exception e) {
            this.loadingError = true;
            this.imageView.setScaleX(0.1f);
            this.imageView.setScaleY(0.1f);
            this.imageView.setZoomEnabled(false);
            this.imageView.setOnClickListener(this);
        }

        public void onClick(View v) {
            Media media;
            LeonMedia leonMedia = FullScreenImageAdapter.this.leonObject.getLeonMedia().get(this.getAdapterPosition());
            if (this.loadingError) {
                this.handleLeonMedia(leonMedia);
            } else if (leonMedia.getType().equals((Object)LeonMedia.LeonMediaType.MEDIA) && (media = (Media)leonMedia.getObject()).getPath() != null) {
                Utils.youtubePlay(FullScreenImageAdapter.this.context, media.getPath().substring(media.getPath().indexOf("=") + 1));
            }
        }
    }
}

