/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.view;

import com.ahmadullahpk.alldocumentreader.xs.common.shape.AbstractShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPAutoShape;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.AbstractView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.BNView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.CellView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.EncloseCharacterView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LeafView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LineView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ObjView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PageView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ParagraphView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.RowView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ShapeView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.TableView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.TitleView;

public class ViewFactory {
    public static IView createView(IControl control, IElement elem, IElement paraElem, int viewType) {
        AbstractView view = null;
        switch (viewType) {
            case 4: {
                view = new PageView(elem);
                break;
            }
            case 5: {
                view = new ParagraphView(elem);
                break;
            }
            case 6: {
                view = new LineView(elem);
                break;
            }
            case 7: {
                if (AttrManage.instance().hasAttribute(elem.getAttribute(), (short)13)) {
                    AbstractShape shape = control.getSysKit().getWPShapeManage().getShape(AttrManage.instance().getShapeID(elem.getAttribute()));
                    if (shape != null) {
                        if (shape.getType() == 2 || shape.getType() == 5) {
                            view = new ShapeView(paraElem, elem, (AutoShape)shape);
                            break;
                        }
                        if (shape.getType() != 0) break;
                        view = new ObjView(paraElem, elem, (WPAutoShape)shape);
                        break;
                    }
                    view = new ObjView(paraElem, elem, null);
                    break;
                }
                if (AttrManage.instance().hasAttribute(elem.getAttribute(), (short)16)) {
                    view = new EncloseCharacterView(paraElem, elem);
                    break;
                }
                view = new LeafView(paraElem, elem);
                break;
            }
            case 9: {
                if (elem.getType() == 2) {
                    view = new TableView(elem);
                    break;
                }
                view = new ParagraphView(elem);
                break;
            }
            case 10: {
                view = new RowView(elem);
                break;
            }
            case 11: {
                view = new CellView(elem);
                break;
            }
            case 12: {
                view = new TitleView(elem);
                break;
            }
            case 13: {
                view = new BNView();
                break;
            }
        }
        return view;
    }

    public static void dispose() {
    }
}

