/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.view;

import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.DocAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IRoot;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.PageAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.TableAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ViewKit;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.wp.model.CellElement;
import com.ahmadullahpk.alldocumentreader.xs.wp.model.RowElement;
import com.ahmadullahpk.alldocumentreader.xs.wp.model.TableElement;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.BreakPagesCell;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.CellView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LayoutKit;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ParagraphView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.RowView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.TableView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ViewFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public class TableLayoutKit {
    private boolean isRowBreakPages;
    private short rowIndex;
    private RowElement breakRowElement;
    private RowView breakRowView;
    private Map<Integer, BreakPagesCell> breakPagesCell;
    private TableAttr tableAttr = new TableAttr();
    private Vector<CellView> mergedCell = new Vector();

    public TableLayoutKit() {
        this.breakPagesCell = new LinkedHashMap<Integer, BreakPagesCell>();
    }

    public int layoutTable(IControl control, IDocument doc, IRoot root, DocAttr docAttr, PageAttr pageAttr, ParaAttr paraAttr, TableView tableView, long startOffset, int x, int y, int w, int h, int flag, boolean isBreakPages) {
        this.mergedCell.clear();
        int span = h;
        int dx = 0;
        int dy = 0;
        int breakType = 0;
        TableElement tableElem = (TableElement)tableView.getElement();
        AttrManage.instance().fillTableAttr(this.tableAttr, tableElem.getAttribute());
        flag = ViewKit.instance().setBitValue(flag, 2, true);
        boolean keepOne = ViewKit.instance().getBitValue(flag, 0);
        long maxEnd = tableElem.getEndOffset();
        int rowHeight = 0;
        int tableHeight = 0;
        int tableWidth = 0;
        RowView rowView = null;
        while (startOffset < maxEnd && span > 0 || this.breakRowElement != null && isBreakPages) {
            IElement rowElem;
            this.isRowBreakPages = false;
            if (this.breakRowElement != null && isBreakPages) {
                rowElem = this.breakRowElement;
                this.breakRowElement = null;
            } else {
                short s = this.rowIndex;
                this.rowIndex = (short)(s + 1);
                rowElem = tableElem.getElementForIndex(s);
            }
            if (rowElem == null) break;
            if (rowView != null) {
                this.layoutMergedCell(rowView, (RowElement)rowElem, false);
                tableHeight = dy = rowView.getY() + rowView.getLayoutSpan((byte)1);
                span = h - tableHeight;
                if (span <= 0) {
                    if (this.isBreakPages(rowView)) {
                        this.rowIndex = (short)(this.rowIndex - 1);
                        this.breakRowElement = (RowElement)rowView.getElement();
                        break;
                    }
                    this.breakRowElement = rowElem;
                    break;
                }
            }
            rowView = (RowView)ViewFactory.createView(control, rowElem, null, 10);
            tableView.appendChlidView(rowView);
            rowView.setStartOffset(startOffset);
            rowView.setLocation(dx, dy);
            breakType = this.layoutRow(control, doc, root, docAttr, pageAttr, paraAttr, rowView, startOffset, dx, dy, w, span, flag, isBreakPages);
            rowHeight = rowView.getLayoutSpan((byte)1);
            if (!(rowHeight != 0 && span - rowHeight >= 0 || keepOne)) {
                RowView preView = (RowView)rowView.getPreView();
                if (preView != null && this.isBreakPages(preView)) {
                    this.rowIndex = (short)(this.rowIndex - 1);
                    this.breakRowElement = (RowElement)preView.getElement();
                    this.clearCurrentRowBreakPageCell(rowElem);
                } else {
                    this.breakRowElement = (RowElement)rowView.getElement();
                    this.clearCurrentRowBreakPageCell(rowElem);
                }
                tableView.deleteView(rowView, true);
                rowView = preView;
                breakType = 1;
                break;
            }
            if (breakType == 1 && this.breakPagesCell.size() > 0 || this.isRowBreakPages) {
                this.breakRowElement = (RowElement)rowView.getElement();
            }
            tableWidth = Math.max(tableWidth, rowView.getLayoutSpan((byte)0));
            dy += rowHeight;
            tableHeight += rowHeight;
            startOffset = rowView.getEndOffset(null);
            isBreakPages = false;
            keepOne = false;
        }
        this.layoutMergedCell(rowView, null, true);
        tableView.setEndOffset(startOffset);
        tableView.setSize(tableWidth, tableHeight);
        if (docAttr.rootType == 0) {
            byte hor = (byte)AttrManage.instance().getParaHorizontalAlign(tableElem.getAttribute());
            int want = w - tableWidth;
            if (hor == 1 || hor == 2) {
                if (hor == 1) {
                    want /= 2;
                }
                tableView.setX(tableView.getX() + want);
            } else {
                tableView.setX(tableView.getX() - this.tableAttr.leftMargin + (int)((float)AttrManage.instance().getParaIndentLeft(tableElem.getAttribute()) * 0.06666667f));
            }
        }
        this.breakRowView = rowView;
        return breakType;
    }

    private void clearCurrentRowBreakPageCell(IElement currentElem) {
        Vector<Integer> keys = new Vector<Integer>();
        for (Integer key : this.breakPagesCell.keySet()) {
            BreakPagesCell bc = this.breakPagesCell.get(key);
            if (bc.getCell().getStartOffset() < currentElem.getStartOffset() || bc.getCell().getEndOffset() > currentElem.getEndOffset()) continue;
            keys.add(key);
        }
        for (Integer key : keys) {
            this.breakPagesCell.remove(key);
        }
    }

    public int layoutRow(IControl control, IDocument doc, IRoot root, DocAttr docAttr, PageAttr pageAttr, ParaAttr paraAttr, RowView rowView, long startOffset, int x, int y, int w, int h, int flag, boolean isBreakPages) {
        int dx = 0;
        int dy = 0;
        int breakType = 0;
        RowElement rowElem = (RowElement)rowView.getElement();
        long maxEnd = rowElem.getEndOffset();
        int rowHeight = (int)((float)AttrManage.instance().getTableRowHeight(rowElem.getAttribute()) * 0.06666667f);
        int rowWidth = 0;
        int maxCellHeight = 0;
        int maxRowHeight = rowHeight;
        boolean isInvalid = true;
        for (int cellIndex = 0; cellIndex < rowElem.getCellNumber(); ++cellIndex) {
            IElement cellElem = null;
            boolean isNullCell = false;
            if (isBreakPages && this.breakPagesCell.size() > 0) {
                if (this.breakPagesCell.containsKey(cellIndex)) {
                    BreakPagesCell breakCell = this.breakPagesCell.remove(cellIndex);
                    cellElem = breakCell.getCell();
                    startOffset = breakCell.getBreakOffset();
                } else {
                    cellElem = rowElem.getElementForIndex(cellIndex);
                    isNullCell = true;
                }
            } else {
                CellView temp;
                cellElem = rowElem.getElementForIndex(cellIndex);
                if (cellElem == null) break;
                startOffset = cellElem.getStartOffset();
                boolean bl = isNullCell = startOffset == cellElem.getEndOffset();
                if (!isNullCell && this.breakRowView != null && isBreakPages && (temp = this.breakRowView.getCellView((short)cellIndex)) != null) {
                    isNullCell = temp.getEndOffset(null) == cellElem.getEndOffset();
                }
            }
            CellView cellView = (CellView)ViewFactory.createView(control, cellElem, null, 11);
            rowView.appendChlidView(cellView);
            cellView.setStartOffset(startOffset);
            cellView.setLocation(dx, dy);
            cellView.setColumn((short)cellIndex);
            if (isNullCell) {
                cellView.setFirstMergedCell(isBreakPages);
                breakType = this.layoutCellForNull(doc, root, docAttr, pageAttr, paraAttr, cellView, startOffset, dx, dy, w, h, flag, cellIndex, isBreakPages);
            } else {
                cellView.setFirstMergedCell(isBreakPages || AttrManage.instance().isTableVerFirstMerged(cellElem.getAttribute()));
                cellView.setMergedCell(AttrManage.instance().isTableVerMerged(cellElem.getAttribute()));
                breakType = this.layoutCell(control, doc, root, docAttr, pageAttr, paraAttr, cellView, startOffset, dx, dy, w, h, flag, cellIndex, isBreakPages);
            }
            int cellWidth = cellView.getLayoutSpan((byte)0);
            int cellHeight = cellView.getLayoutSpan((byte)1);
            isInvalid = isInvalid && cellHeight == 0;
            dx += cellWidth;
            rowWidth += cellWidth;
            w -= cellWidth;
            if (!cellView.isMergedCell()) {
                maxRowHeight = Math.max(maxRowHeight, cellHeight);
            }
            if (cellView.isFirstMergedCell()) {
                this.mergedCell.add(cellView);
            }
            maxCellHeight = Math.max(maxCellHeight, cellHeight);
            startOffset = cellView.getEndOffset(null);
        }
        for (CellView cellView = (CellView)rowView.getChildView(); cellView != null; cellView = (CellView)cellView.getNextView()) {
            if (cellView.isMergedCell() || cellView.getLayoutSpan((byte)1) >= maxRowHeight) continue;
            cellView.setHeight(maxRowHeight - cellView.getTopIndent() - cellView.getBottomIndent());
            CellElement cellElem = (CellElement)cellView.getElement();
            if (cellElem != null) {
                this.tableAttr.cellVerticalAlign = (byte)AttrManage.instance().getTableCellVerAlign(cellElem.getAttribute());
            }
            this.layoutCellVerticalAlign(cellView);
        }
        rowView.setEndOffset(maxEnd);
        if (isInvalid) {
            maxRowHeight = Integer.MAX_VALUE;
        }
        rowView.setSize(rowWidth, maxRowHeight);
        this.breakRowView = null;
        return breakType;
    }

    public int layoutCell(IControl control, IDocument doc, IRoot root, DocAttr docAttr, PageAttr pageAttr, ParaAttr paraAttr, CellView cellView, long startOffset, int x, int y, int w, int h, int flag, int cellIndex, boolean isBreakPages) {
        int paraHeight;
        CellElement cellElem = (CellElement)cellView.getElement();
        AttrManage.instance().fillTableAttr(this.tableAttr, cellElem.getAttribute());
        cellView.setBackground(this.tableAttr.cellBackground);
        cellView.setIndent(this.tableAttr.leftMargin, this.tableAttr.topMargin, this.tableAttr.rightMargin, this.tableAttr.bottomMargin);
        int dx = this.tableAttr.leftMargin;
        int dy = this.tableAttr.topMargin;
        int breakType = 0;
        long maxEnd = cellElem.getEndOffset();
        int cellHeight = 0;
        int cellWidth = this.tableAttr.cellWidth - this.tableAttr.leftMargin - this.tableAttr.rightMargin;
        for (int spanH = h - this.tableAttr.topMargin - this.tableAttr.bottomMargin; startOffset < maxEnd && spanH > 0 && breakType != 1; spanH -= paraHeight) {
            IElement paraElem = doc.getParagraph(startOffset);
            ParagraphView paraView = (ParagraphView)ViewFactory.createView(control, paraElem, null, 5);
            cellView.appendChlidView(paraView);
            paraView.setStartOffset(startOffset);
            paraView.setLocation(dx, dy);
            AttrManage.instance().fillParaAttr(cellView.getControl(), paraAttr, paraElem.getAttribute());
            breakType = LayoutKit.instance().layoutPara(control, doc, docAttr, pageAttr, paraAttr, paraView, startOffset, dx, dy, cellWidth, spanH, flag);
            paraHeight = paraView.getLayoutSpan((byte)1);
            if (paraView.getChildView() == null) {
                cellView.deleteView(paraView, true);
                break;
            }
            if (root.getViewContainer() != null) {
                root.getViewContainer().add(paraView);
            }
            dy += paraHeight;
            cellHeight += paraHeight;
            startOffset = paraView.getEndOffset(null);
            paraView.setEndOffset(startOffset);
            flag = ViewKit.instance().setBitValue(flag, 0, false);
        }
        if (startOffset < maxEnd && !this.breakPagesCell.containsKey(cellIndex) && cellWidth > 0) {
            this.breakPagesCell.put(cellIndex, new BreakPagesCell(cellElem, startOffset));
            this.isRowBreakPages = true;
        }
        cellView.setEndOffset(startOffset);
        cellView.setSize(cellWidth, cellHeight);
        return breakType;
    }

    public int layoutCellForNull(IDocument doc, IRoot root, DocAttr docAttr, PageAttr pageAttr, ParaAttr paraAttr, CellView cellView, long startOffset, int x, int y, int w, int h, int flag, int cellIndex, boolean isBreakPages) {
        CellElement cellElem = (CellElement)cellView.getElement();
        AttrManage.instance().fillTableAttr(this.tableAttr, cellElem.getAttribute());
        cellView.setIndent(this.tableAttr.leftMargin, this.tableAttr.topMargin, this.tableAttr.rightMargin, this.tableAttr.bottomMargin);
        int cellHeight = 0;
        int cellWidth = this.tableAttr.cellWidth - this.tableAttr.leftMargin - this.tableAttr.rightMargin;
        cellView.setSize(cellWidth, cellHeight);
        return 0;
    }

    private void layoutMergedCell(RowView row, RowElement nextRowElem, boolean isLastRow) {
        if (row == null) {
            return;
        }
        int maxY = row.getY() + row.getLayoutSpan((byte)1);
        if (isLastRow) {
            for (CellView cell : this.mergedCell) {
                if (cell.getParentView() == null) continue;
                cell.setHeight(maxY - cell.getParentView().getY());
                this.layoutCellVerticalAlign(cell);
            }
            this.mergedCell.clear();
            return;
        }
        for (CellView cell : this.mergedCell) {
            maxY = Math.max(maxY, cell.getParentView().getY() + cell.getLayoutSpan((byte)1));
        }
        Vector<CellView> vector = new Vector<CellView>();
        for (CellView cell : this.mergedCell) {
            IElement cellElem = nextRowElem.getElementForIndex(cell.getColumn());
            if (cellElem == null || AttrManage.instance().isTableVerMerged(cellElem.getAttribute()) && !AttrManage.instance().isTableVerFirstMerged(cellElem.getAttribute())) continue;
            int cellHeight = cell.getLayoutSpan((byte)1);
            if (cell.getParentView().getY() + cellHeight < maxY) {
                cell.setHeight(maxY - cell.getParentView().getY());
                this.layoutCellVerticalAlign(cell);
            } else {
                row.setHeight(maxY - row.getY());
                for (CellView cellView = (CellView)row.getChildView(); cellView != null; cellView = (CellView)cellView.getNextView()) {
                    if (cellView.isMergedCell()) continue;
                    int oldHeight = cellView.getHeight();
                    cellView.setHeight(maxY - cellView.getParentView().getY());
                    if (oldHeight == cellView.getHeight()) continue;
                    this.layoutCellVerticalAlign(cellView);
                }
            }
            vector.add(cell);
        }
        for (CellView cell : vector) {
            maxY = cell.getParentView().getY() + cell.getLayoutSpan((byte)1);
            if (maxY > row.getY() + row.getLayoutSpan((byte)1)) {
                cell.setHeight(row.getY() + row.getLayoutSpan((byte)1) - cell.getY());
            }
            this.mergedCell.remove(cell);
        }
    }

    private boolean isBreakPages(RowView rowView) {
        for (IView view = rowView.getChildView(); view != null; view = view.getNextView()) {
            IElement elem = view.getElement();
            if (view.getEndOffset(null) == elem.getEndOffset() || view.getWidth() <= 0) continue;
            return true;
        }
        return false;
    }

    private void layoutCellVerticalAlign(CellView cellView) {
        IView para;
        if (this.tableAttr.cellVerticalAlign == 0) {
            return;
        }
        int textHeight = 0;
        for (para = cellView.getChildView(); para != null; para = para.getNextView()) {
            textHeight += para.getLayoutSpan((byte)1);
        }
        int want = cellView.getLayoutSpan((byte)1) - textHeight;
        int verAlignmnet = AttrManage.instance().getTableCellVerAlign(cellView.getElement().getAttribute());
        if (verAlignmnet == 1 || verAlignmnet == 2) {
            if (verAlignmnet == 1) {
                want /= 2;
            }
            for (para = cellView.getChildView(); para != null; para = para.getNextView()) {
                para.setY(para.getY() + want);
            }
        }
    }

    public boolean isTableBreakPages() {
        return this.breakPagesCell.size() > 0 || this.breakRowElement != null;
    }

    public void clearBreakPages() {
        this.rowIndex = 0;
        this.breakRowElement = null;
        this.breakPagesCell.clear();
        this.breakRowView = null;
    }

    public void dispose() {
        this.breakRowElement = null;
        this.breakPagesCell.clear();
        this.breakRowView = null;
    }
}

