/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.view;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.font.FontTypefaceManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.AbstractView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.CharAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.DocAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.PageAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ViewKit;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.CellView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PageView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ShapeView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.TitleView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.WPSTRoot;

public class LeafView
extends AbstractView {
    private static StringBuffer title = new StringBuffer();
    protected CharAttr charAttr;
    protected Paint paint;
    protected int numPages = -1;

    public LeafView() {
    }

    public LeafView(IElement paraElem, IElement elem) {
        this.elem = elem;
        this.initProperty(elem, paraElem);
    }

    @Override
    public short getType() {
        return 7;
    }

    public void initProperty(IElement elem, IElement paraElem) {
        this.elem = elem;
        if (this.paint == null) {
            this.paint = new Paint();
        } else {
            this.paint.reset();
        }
        this.paint.setAntiAlias(true);
        if (this.charAttr == null) {
            this.charAttr = new CharAttr();
        }
        AttrManage.instance().fillCharAttr(this.charAttr, paraElem.getAttribute(), elem.getAttribute());
        if (this.charAttr.isBold && this.charAttr.isItalic) {
            this.paint.setTextSkewX(-0.2f);
            this.paint.setFakeBoldText(true);
        } else if (this.charAttr.isBold) {
            this.paint.setFakeBoldText(true);
        } else if (this.charAttr.isItalic) {
            this.paint.setTextSkewX(-0.25f);
        }
        this.paint.setTypeface(FontTypefaceManage.instance().getFontTypeface(this.charAttr.fontIndex));
        if (this.charAttr.subSuperScriptType > 0) {
            this.paint.setTextSize((float)this.charAttr.fontSize * ((float)this.charAttr.fontScale / 100.0f) * 1.3333334f / 2.0f);
        } else {
            this.paint.setTextSize((float)this.charAttr.fontSize * ((float)this.charAttr.fontScale / 100.0f) * 1.3333334f);
        }
        this.paint.setColor(this.charAttr.fontColor);
    }

    public int doLayout(DocAttr docAttr, PageAttr pageAttr, ParaAttr paraAttr, int x, int y, int w, int h, long maxEnd, int flag) {
        int i;
        long start = this.getStartOffset(null);
        long startElem = this.elem.getStartOffset();
        String text = this.elem.getText(null);
        if (start > startElem) {
            text = text.substring((int)(start - startElem), (int)(this.elem.getEndOffset() - startElem));
        }
        float[] widths = new float[text.length()];
        this.paint.getTextWidths(text, widths);
        float tW = 0.0f;
        boolean layoutInTable = ViewKit.instance().getBitValue(flag, 2);
        int breakType = 0;
        boolean keepOne = ViewKit.instance().getBitValue(flag, 0);
        for (i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            tW += widths[i];
            if (ch == '\u0007' || ch == '\n' || ch == '\r') {
                tW -= widths[i];
                ++i;
                breakType = 2;
                break;
            }
            if (!layoutInTable && ch == '\f') {
                ++i;
                breakType = 3;
                break;
            }
            if (ch == '\u000b') {
                ++i;
                breakType = 2;
                break;
            }
            if (!(tW > (float)w)) continue;
            tW -= widths[i];
            breakType = 1;
            if (!keepOne || i != 0) break;
            tW += widths[i];
            ++i;
            breakType = 0;
            break;
        }
        this.setEndOffset((long)i + start);
        this.setSize((int)tW, (int)Math.ceil(this.paint.descent() - this.paint.ascent()));
        return breakType;
    }

    public float getTextWidth() {
        String text = this.elem.getText(null);
        int s = (int)(this.start - this.elem.getStartOffset());
        int e = (int)(this.end - this.elem.getStartOffset());
        text = text.substring(s, e);
        float[] widths = new float[text.length()];
        this.paint.getTextWidths(text, widths);
        float tW = 0.0f;
        for (int i = 0; i < text.length(); ++i) {
            tW += widths[i];
        }
        return tW;
    }

    private String getFieldTextReplacedByPage(String text, int page) {
        if (text != null) {
            char[] chars = text.toCharArray();
            title.delete(0, title.length());
            for (int i = 0; i < chars.length; ++i) {
                if (!Character.isDigit(chars[i])) continue;
                title.append(chars[i]);
            }
            if (title.length() > 0) {
                return text.replace(title.toString(), String.valueOf(page));
            }
        }
        return text;
    }

    public int getPageNumber() {
        try {
            IView view = this.getParentView().getParentView().getParentView();
            if (view instanceof CellView) {
                view = view.getParentView().getParentView().getParentView();
            }
            if (view instanceof PageView) {
                return ((PageView)view).getPageNumber();
            }
            if (view instanceof TitleView) {
                return -1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public synchronized void draw(Canvas canvas, int originX, int originY, float zoom) {
        boolean adjustFieldText;
        int e;
        int s;
        String text;
        float oldFontSize;
        float dY;
        float dX;
        block24: {
            IView line;
            dX = (float)this.x * zoom + (float)originX;
            dY = (float)this.y * zoom + (float)originY;
            int oldColor = this.paint.getColor();
            if (this.charAttr.highlightedColor != -1 && (line = this.getParentView()) != null) {
                this.paint.setColor(this.charAttr.highlightedColor);
                canvas.drawRect(dX, (float)originY, dX + (float)this.getWidth() * zoom, (float)originY + (float)line.getHeight() * zoom, this.paint);
                this.paint.setColor(oldColor);
            }
            oldFontSize = this.paint.getTextSize();
            float newSize = oldFontSize * zoom;
            this.paint.setTextSize(newSize);
            if (this.charAttr.subSuperScriptType == 1) {
                dY -= (float)((int)Math.ceil(this.paint.descent() - this.paint.ascent()));
            }
            text = this.elem.getText(null);
            s = (int)(this.start - this.elem.getStartOffset());
            e = (int)(this.end - this.elem.getStartOffset());
            adjustFieldText = false;
            if (this.charAttr.pageNumberType == 1) {
                try {
                    IView view = this.getParentView().getParentView().getParentView();
                    if (view == null) break block24;
                    PageView pageView = null;
                    while (view != null) {
                        if (view instanceof TitleView && view.getParentView() != null) {
                            pageView = (PageView)view.getParentView();
                            break;
                        }
                        if (view instanceof PageView) {
                            pageView = (PageView)view;
                            break;
                        }
                        if (view instanceof WPSTRoot) {
                            view = view.getParentView().getParentView().getParentView().getParentView();
                            continue;
                        }
                        view = view.getParentView();
                    }
                    if (pageView != null) {
                        adjustFieldText = true;
                        text = this.getFieldTextReplacedByPage(text, pageView.getPageNumber());
                        s = 0;
                        e = text.length();
                    }
                }
                catch (Exception view) {}
            } else if (this.charAttr.pageNumberType == 2 && this.numPages > 0) {
                adjustFieldText = true;
                text = this.getFieldTextReplacedByPage(text, this.numPages);
                s = 0;
                e = text.length();
            }
        }
        float[] widths = new float[text.length()];
        this.paint.getTextWidths(text, widths);
        float extX = 0.0f;
        if (!adjustFieldText && (double)zoom != 1.0) {
            float cw = 0.0f;
            for (int i = s; i < e; ++i) {
                cw += widths[i];
            }
            char ch = text.charAt(e - 1);
            if (ch == '\u0007' || ch == '\n' || ch == '\r') {
                cw -= widths[e - 1];
            }
            float extW = 0.0f;
            IView nextView = this.getNextView();
            if (nextView != null && (nextView.getType() == 7 || nextView.getType() == 13 && ((ShapeView)nextView).isInline())) {
                float nextX = (float)this.getNextView().getX() * zoom;
                extW = cw - (nextX + (float)originX - dX);
            } else {
                extW = cw - (float)this.getLayoutSpan((byte)0) * zoom;
            }
            if (extW != 0.0f) {
                extX = extW / (float)(e - s);
            }
        }
        float drawX = dX;
        float drawY = dY - this.paint.ascent();
        for (int i = s; i < e; ++i) {
            char c = text.charAt(i);
            if (c == '\n' || c == '\r' || c == '\u0007' || c == '\u000b' || c == '\f' || c == '\t' || c == ' ' || c == '\u0002' || c == '\f') {
                drawX += widths[i] - extX;
                continue;
            }
            int skip = 0;
            for (int j = i + 1; j < e && widths[j] == 0.0f; ++j) {
                ++skip;
            }
            canvas.drawText(text, i, i + 1 + skip, drawX, drawY, this.paint);
            drawX += widths[i] - extX;
            i += skip;
        }
        dY += (float)((int)Math.ceil(this.paint.descent() - this.paint.ascent()) / 2);
        if (this.charAttr.isStrikeThrough) {
            canvas.drawRect(dX, dY - 1.0f, dX + (float)this.getWidth() * zoom, dY + 1.0f, this.paint);
        } else if (this.charAttr.isDoubleStrikeThrough) {
            canvas.drawRect(dX, dY - 3.0f, dX + (float)this.getWidth() * zoom, dY - 1.0f, this.paint);
            canvas.drawRect(dX, dY, dX + (float)this.getWidth() * zoom, dY + 2.0f, this.paint);
        }
        this.paint.setTextSize(oldFontSize);
    }

    @Override
    public Rectangle modelToView(long offset, Rectangle rect, boolean isBack) {
        String text = this.elem.getText(null);
        int s = (int)(this.start - this.elem.getStartOffset());
        int e = (int)(offset - this.elem.getStartOffset());
        text = text.substring(s, e);
        rect.x = (int)this.paint.measureText(text);
        rect.x += this.getX();
        rect.y += this.getY();
        rect.height = this.getLayoutSpan((byte)1);
        return rect;
    }

    @Override
    public long viewToModel(int x, int y, boolean isBack) {
        x -= this.x;
        String text = this.elem.getText(null);
        int s = (int)(this.start - this.elem.getStartOffset());
        int e = (int)(this.end - this.elem.getStartOffset());
        text = text.substring(s, e);
        float[] widths = new float[text.length()];
        this.paint.getTextWidths(text, widths);
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            if ((x = (int)((float)x - widths[i])) <= 0) {
                if (!((float)x + widths[i] >= widths[i] / 2.0f)) break;
                ++count;
                break;
            }
            ++count;
        }
        return this.start + (long)count;
    }

    public int getBaseline() {
        if (!"\n".equals(this.elem.getText(null))) {
            return (int)(-this.paint.ascent());
        }
        return 0;
    }

    public int getUnderlinePosition() {
        return (int)((float)(this.getY() + this.getHeight()) - ((float)this.getHeight() - this.paint.getTextSize()));
    }

    public CharAttr getCharAttr() {
        return this.charAttr;
    }

    @Override
    public void free() {
    }

    public boolean hasUpdatedFieldText() {
        return this.charAttr != null && this.charAttr.pageNumberType == 2;
    }

    public void setNumPages(int numPages) {
        if (this.hasUpdatedFieldText()) {
            this.numPages = numPages;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.paint = null;
        this.charAttr = null;
    }
}

