/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.view;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import com.ahmadullahpk.alldocumentreader.xs.common.bulletnumber.ListData;
import com.ahmadullahpk.alldocumentreader.xs.common.bulletnumber.ListKit;
import com.ahmadullahpk.alldocumentreader.xs.common.bulletnumber.ListLevel;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.Style;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.StyleManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.AbstractView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.CharAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.DocAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.PageAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ParagraphView;

public class BNView
extends AbstractView {
    private Object content;
    private Paint paint;
    private CharAttr charAttr = new CharAttr();
    private ListLevel currLevel;

    public BNView() {
        this.paint = new Paint();
        this.paint.setFlags(1);
    }

    @Override
    public short getType() {
        return 13;
    }

    public synchronized int doLayout(IDocument doc, DocAttr docAttr, PageAttr pageAttr, ParaAttr paraAttr, ParagraphView para, int x, int y, int w, int h, int flag) {
        this.setLocation(paraAttr.listAlignIndent + x, y);
        int breakType = 0;
        IElement paraElem = para.getElement();
        IElement leafElem = null;
        String text = "";
        if (paraAttr.listID >= 0) {
            byte preParaLevel;
            Style style2;
            ListData listData = para.getControl().getSysKit().getListManage().getListData(paraAttr.listID);
            if (listData == null) {
                return breakType;
            }
            if (listData.getLinkStyleID() >= 0 && (style2 = StyleManage.instance().getStyle(listData.getLinkStyleID())) != null) {
                int listID = AttrManage.instance().getParaListID(style2.getAttrbuteSet());
                listData = para.getControl().getSysKit().getListManage().getListData(listID);
                if (listData == null || listData.getLevels().length == 0) {
                    return breakType;
                }
            }
            leafElem = doc.getLeaf(paraElem.getEndOffset() - 1L);
            ListLevel listLevel = listData.getLevel(paraAttr.listLevel);
            text = ListKit.instance().getBulletText(listData, listLevel, docAttr, paraAttr.listLevel);
            byte by = preParaLevel = docAttr.rootType == 1 ? listData.getNormalPreParaLevel() : listData.getPreParaLevel();
            if (paraAttr.listLevel < preParaLevel) {
                for (i = paraAttr.listLevel + 1; i < 9; ++i) {
                    if (docAttr.rootType == 1) {
                        listData.getLevel(i).setNormalParaCount(0);
                        continue;
                    }
                    listData.getLevel(i).setParaCount(0);
                }
            } else if (paraAttr.listLevel > preParaLevel) {
                for (i = preParaLevel + 1; i < paraAttr.listLevel; ++i) {
                    ListLevel temp = listData.getLevel(i);
                    if (docAttr.rootType == 1) {
                        temp.setNormalParaCount(temp.getNormalParaCount() + 1);
                        continue;
                    }
                    temp.setParaCount(temp.getParaCount() + 1);
                }
            }
            if (docAttr.rootType == 1) {
                listLevel.setNormalParaCount(listLevel.getNormalParaCount() + 1);
                listData.setNormalPreParaLevel(paraAttr.listLevel);
            } else {
                listLevel.setParaCount(listLevel.getParaCount() + 1);
                listData.setPreParaLevel(paraAttr.listLevel);
            }
            this.currLevel = listLevel;
        } else if (paraAttr.pgBulletID >= 0) {
            leafElem = doc.getLeaf(paraElem.getStartOffset());
            text = para.getControl().getSysKit().getPGBulletText().getBulletText(paraAttr.pgBulletID);
            if (text == null) {
                text = "";
            }
        }
        AttrManage.instance().fillCharAttr(this.charAttr, paraElem.getAttribute(), leafElem.getAttribute());
        if (this.charAttr.isBold && this.charAttr.isItalic) {
            this.paint.setTextSkewX(-0.2f);
            this.paint.setFakeBoldText(true);
        } else if (this.charAttr.isBold) {
            this.paint.setFakeBoldText(true);
        } else if (this.charAttr.isItalic) {
            this.paint.setTextSkewX(-0.25f);
        }
        this.paint.setTypeface(Typeface.create((Typeface)Typeface.SERIF, (int)0));
        this.paint.setTextSize((float)this.charAttr.fontSize * ((float)this.charAttr.fontScale / 100.0f) * 1.3333334f);
        this.paint.setColor(this.charAttr.fontColor);
        float[] widths = new float[text.length()];
        this.paint.getTextWidths(text, widths);
        float tW = 0.0f;
        for (int i = 0; i < widths.length; ++i) {
            tW += widths[i];
        }
        int ex = (int)((tW + (float)this.getX()) % 28.0f);
        if (ex > 0) {
            tW += 28.0f - (float)ex;
        }
        this.setSize((int)tW, (int)Math.ceil(this.paint.descent() - this.paint.ascent()));
        this.content = text;
        return breakType;
    }

    @Override
    public void draw(Canvas canvas, int originX, int originY, float zoom) {
        int dX = (int)((float)this.x * zoom) + originX;
        int dY = (int)((float)this.y * zoom) + originY;
        if (this.content != null && this.content instanceof String) {
            String text = (String)this.content;
            float oldFontSize = this.paint.getTextSize();
            this.paint.setTextSize((this.charAttr.subSuperScriptType > 0 ? oldFontSize / 2.0f : oldFontSize) * zoom);
            canvas.drawText(text, 0, text.length(), (float)dX, (float)dY - this.paint.ascent(), this.paint);
            this.paint.setTextSize(oldFontSize);
        }
    }

    public int getBaseline() {
        return (int)(-this.paint.ascent());
    }

    @Override
    public void free() {
    }

    @Override
    public synchronized void dispose() {
        this.content = null;
        this.paint = null;
        this.charAttr = null;
        if (this.currLevel != null) {
            this.currLevel.setParaCount(this.currLevel.getParaCount() - 1);
        }
    }
}

