/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.control;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import com.ahmadullahpk.alldocumentreader.xs.common.IOfficeToPicture;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.PictureKit;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.IShape;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.FadeAnimation;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.control.Highlight;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.control.IHighlight;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.control.IWord;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IDialogAction;
import com.ahmadullahpk.alldocumentreader.xs.system.SysKit;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist.APageListView;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.PrintWord;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.StatusManage;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.WPDialogAction;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.WPEventManage;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.WPFind;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.WPPageListItem;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LayoutKit;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.NormalRoot;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PageRoot;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PageView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.WPViewKit;

public class Word
extends LinearLayout
implements IWord {
    private int preShowPageIndex = -1;
    private int prePageCount = -1;
    private boolean isExportImageAfterZoom;
    private boolean initFinish;
    private int currentRootType;
    protected int mWidth;
    protected int mHeight;
    protected float zoom = 1.0f;
    private float normalZoom = 1.0f;
    protected IControl control;
    protected IDocument doc;
    protected StatusManage status;
    protected IHighlight highlight;
    protected WPEventManage eventManage;
    private String filePath;
    private IDialogAction dialogAction;
    private PageRoot pageRoot;
    private NormalRoot normalRoot;
    private PrintWord printWord;
    private Paint paint;
    private WPFind wpFind;
    private Rectangle visibleRect;

    public Word(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public Word(Context context, IDocument doc, String filePath, IControl control) {
        super(context);
        this.control = control;
        this.doc = doc;
        byte defaultMode = control.getMainFrame().getWordDefaultView();
        this.setCurrentRootType(defaultMode);
        if (defaultMode == 1) {
            this.normalRoot = new NormalRoot(this);
        } else if (defaultMode == 0) {
            this.pageRoot = new PageRoot(this);
        } else if (defaultMode == 2) {
            this.pageRoot = new PageRoot(this);
            this.printWord = new PrintWord(context, control, this.pageRoot);
            this.addView((View)this.printWord);
        }
        this.dialogAction = new WPDialogAction(control);
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setTypeface(Typeface.SANS_SERIF);
        this.paint.setTextSize(24.0f);
        this.visibleRect = new Rectangle();
        this.initManage();
        if (defaultMode == 2) {
            this.setOnClickListener(null);
        }
    }

    private void initManage() {
        this.eventManage = new WPEventManage(this, this.control);
        this.setOnTouchListener(this.eventManage);
        this.setLongClickable(true);
        this.wpFind = new WPFind(this);
        this.status = new StatusManage();
        this.highlight = new Highlight(this);
    }

    public void init() {
        if (this.normalRoot != null) {
            this.normalRoot.doLayout(0, 0, this.mWidth, this.mHeight, Integer.MAX_VALUE, 0);
        } else {
            this.pageRoot.doLayout(0, 0, this.mWidth, this.mHeight, Integer.MAX_VALUE, 0);
        }
        this.initFinish = true;
        if (this.printWord != null) {
            this.printWord.init();
        }
        if (this.getCurrentRootType() == 2) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                Word.this.control.actionEvent(0x2000000A, null);
            }
        });
    }

    public void onDraw(Canvas canvas) {
        if (!this.initFinish || this.currentRootType == 2) {
            return;
        }
        try {
            if (this.getCurrentRootType() == 0) {
                this.pageRoot.draw(canvas, 0, 0, this.zoom);
                this.drawPageNubmer(canvas, this.zoom);
            } else if (this.getCurrentRootType() == 1) {
                this.normalRoot.draw(canvas, 0, 0, this.normalZoom);
            }
            IOfficeToPicture otp = this.control.getOfficeToPicture();
            if (otp != null && otp.getModeType() == 0) {
                this.toPicture(otp);
            }
        }
        catch (Exception e) {
            this.control.getSysKit().getErrorKit().writerLog(e);
        }
    }

    public void createPicture() {
        IOfficeToPicture otp = this.control.getOfficeToPicture();
        if (otp != null && otp.getModeType() == 1) {
            try {
                this.toPicture(otp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void toPicture(IOfficeToPicture otp) {
        if (this.getCurrentRootType() == 2) {
            WPPageListItem item = (WPPageListItem)this.printWord.getListView().getCurrentPageView();
            item.addRepaintImageView(null);
            return;
        }
        boolean b = PictureKit.instance().isDrawPictrue();
        PictureKit.instance().setDrawPictrue(true);
        Bitmap bitmap = otp.getBitmap(this.getWidth(), this.getHeight());
        if (bitmap == null) {
            return;
        }
        float paintZoom = this.getZoom();
        float tX = -this.getScrollX();
        float tY = -this.getScrollY();
        if (bitmap.getWidth() != this.getWidth() || bitmap.getHeight() != this.getHeight()) {
            float newZoom = Math.min((float)bitmap.getWidth() / (float)this.getWidth(), (float)bitmap.getHeight() / (float)this.getHeight()) * this.getZoom();
            float pageWidth = this.pageRoot != null ? (float)this.pageRoot.getChildView().getWidth() * newZoom : 0.0f;
            float x = 0.0f;
            if (pageWidth > (float)bitmap.getWidth() || this.getCurrentRootType() == 1) {
                x = (float)this.getScrollX() / paintZoom * newZoom;
                x = Math.min(x, (float)this.getWordWidth() * newZoom - (float)bitmap.getWidth());
            }
            float y = (float)this.getScrollY() / paintZoom * newZoom;
            y = Math.min(y, (float)this.getWordHeight() * newZoom - (float)this.getHeight());
            tX = -Math.max(0.0f, x);
            tY = -Math.max(0.0f, y);
            paintZoom = newZoom;
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.translate(tX, tY);
        canvas.drawColor(-7829368);
        if (this.getCurrentRootType() == 0) {
            this.pageRoot.draw(canvas, 0, 0, paintZoom);
        } else if (this.getCurrentRootType() == 1) {
            this.normalRoot.draw(canvas, 0, 0, paintZoom);
        }
        otp.callBack(bitmap);
        PictureKit.instance().setDrawPictrue(b);
    }

    public Bitmap getSnapshot(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        if (this.getCurrentRootType() == 2 && this.printWord != null) {
            return this.printWord.getSnapshot(bitmap);
        }
        boolean b = PictureKit.instance().isDrawPictrue();
        PictureKit.instance().setDrawPictrue(true);
        float paintZoom = this.getZoom();
        float tX = -this.getScrollX();
        float tY = -this.getScrollY();
        if (bitmap.getWidth() != this.getWidth() || bitmap.getHeight() != this.getHeight()) {
            float newZoom = Math.min((float)bitmap.getWidth() / (float)this.getWidth(), (float)bitmap.getHeight() / (float)this.getHeight()) * this.getZoom();
            float pageWidth = this.pageRoot != null ? (float)this.pageRoot.getChildView().getWidth() * newZoom : 0.0f;
            float x = 0.0f;
            if (pageWidth > (float)bitmap.getWidth() || this.getCurrentRootType() == 1) {
                x = (float)this.getScrollX() / paintZoom * newZoom;
                x = Math.min(x, (float)this.getWordWidth() * newZoom - (float)bitmap.getWidth());
            }
            float y = (float)this.getScrollY() / paintZoom * newZoom;
            y = Math.min(y, (float)this.getWordHeight() * newZoom - (float)this.getHeight());
            tX = -Math.max(0.0f, x);
            tY = -Math.max(0.0f, y);
            paintZoom = newZoom;
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.translate(tX, tY);
        canvas.drawColor(-7829368);
        if (this.getCurrentRootType() == 0) {
            this.pageRoot.draw(canvas, 0, 0, paintZoom);
        } else if (this.getCurrentRootType() == 1) {
            this.normalRoot.draw(canvas, 0, 0, paintZoom);
        }
        PictureKit.instance().setDrawPictrue(b);
        return bitmap;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (!this.initFinish) {
            return;
        }
        this.eventManage.stopFling();
        LayoutKit.instance().layoutAllPage(this.pageRoot, this.zoom);
        if (this.currentRootType == 0) {
            Rectangle r = this.getVisibleRect();
            int sX = r.x;
            int sY = r.y;
            int wW = (int)((float)this.getWordWidth() * this.zoom);
            int wH = (int)((float)this.getWordHeight() * this.zoom);
            if (r.x + r.width > wW) {
                sX = wW - r.width;
            }
            if (r.y + r.height > wH) {
                sY = wH - r.height;
            }
            if (sX != r.x || sY != r.y) {
                this.scrollTo(Math.max(0, sX), Math.max(0, sY));
            }
        }
        if (w != oldw && this.control.getMainFrame().isZoomAfterLayoutForWord()) {
            this.layoutNormal();
            this.setExportImageAfterZoom(true);
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                Word.this.control.actionEvent(0x2000000A, null);
            }
        });
    }

    public void layoutNormal() {
        if (this.normalRoot != null) {
            this.normalRoot.stopBackLayout();
            this.post(new Runnable(){

                @Override
                public void run() {
                    if (Word.this.currentRootType == 1) {
                        Word.this.scrollTo(0, Word.this.getScrollY());
                    }
                    Word.this.normalRoot.layoutAll();
                    Word.this.postInvalidate();
                }
            });
        }
    }

    public void layoutPrintMode() {
        this.post(new Runnable(){

            @Override
            public void run() {
                APageListView listView;
                if (Word.this.currentRootType == 2 && Word.this.printWord != null && (listView = Word.this.printWord.getListView()) != null && listView.getChildCount() == 1) {
                    listView.requestLayout();
                }
            }
        });
    }

    public void computeScroll() {
        if (this.getCurrentRootType() == 2) {
            return;
        }
        this.eventManage.computeScroll();
    }

    public void switchView(int rootType) {
        if (rootType == this.getCurrentRootType()) {
            return;
        }
        this.eventManage.stopFling();
        this.setCurrentRootType(rootType);
        PictureKit.instance().setDrawPictrue(true);
        if (this.getCurrentRootType() == 1) {
            if (this.normalRoot == null) {
                this.normalRoot = new NormalRoot(this);
                this.normalRoot.doLayout(0, 0, this.mWidth, this.mHeight, Integer.MAX_VALUE, 0);
            }
            this.setOnTouchListener(this.eventManage);
            if (this.printWord != null) {
                this.printWord.setVisibility(4);
            }
        } else if (this.getCurrentRootType() == 0) {
            if (this.pageRoot == null) {
                this.pageRoot = new PageRoot(this);
                this.pageRoot.doLayout(0, 0, this.mWidth, this.mHeight, Integer.MAX_VALUE, 0);
            } else {
                LayoutKit.instance().layoutAllPage(this.pageRoot, this.zoom);
            }
            this.setOnTouchListener(this.eventManage);
            if (this.printWord != null) {
                this.printWord.setVisibility(4);
            }
        } else if (this.getCurrentRootType() == 2) {
            if (this.pageRoot == null) {
                this.pageRoot = new PageRoot(this);
                this.pageRoot.doLayout(0, 0, this.mWidth, this.mHeight, Integer.MAX_VALUE, 0);
            }
            if (this.printWord == null) {
                this.printWord = new PrintWord(this.getContext(), this.control, this.pageRoot);
                Object bg = this.control.getMainFrame().getViewBackground();
                if (bg != null) {
                    if (bg instanceof Integer) {
                        this.printWord.setBackgroundColor((Integer)bg);
                    } else if (bg instanceof Drawable) {
                        this.printWord.setBackgroundDrawable((Drawable)bg);
                    }
                }
                this.addView((View)this.printWord);
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        Word.this.printWord.init();
                        Word.this.printWord.postInvalidate();
                    }
                });
            } else {
                this.printWord.setVisibility(0);
            }
            this.scrollTo(0, 0);
            this.setOnClickListener(null);
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                Word.this.scrollTo(0, Word.this.getScrollY());
                Word.this.postInvalidate();
            }
        });
    }

    public Rectangle getVisibleRect() {
        this.visibleRect.x = this.getScrollX();
        this.visibleRect.y = this.getScrollY();
        this.visibleRect.width = this.getWidth();
        this.visibleRect.height = this.getHeight();
        return this.visibleRect;
    }

    public void setZoom(float zoom, int pointX, int pointY) {
        float oldZoom = 1.0f;
        if (this.currentRootType == 0) {
            oldZoom = this.zoom;
            this.zoom = zoom;
            LayoutKit.instance().layoutAllPage(this.pageRoot, zoom);
        } else {
            if (this.currentRootType == 2) {
                this.printWord.setZoom(zoom, pointX, pointY);
                return;
            }
            if (this.currentRootType == 1) {
                oldZoom = this.normalZoom;
                this.normalZoom = zoom;
            }
        }
        this.scrollToFocusXY(zoom, oldZoom, pointX, pointY);
    }

    public void setFitSize(int value) {
        if (this.currentRootType == 2) {
            this.printWord.setFitSize(value);
        }
    }

    public int getFitSizeState() {
        if (this.currentRootType == 2) {
            return this.printWord.getFitSizeState();
        }
        return 0;
    }

    private void scrollToFocusXY(float newScale, float oldScale, int focusScreenX, int focusScreenY) {
        if (focusScreenX == Integer.MIN_VALUE && focusScreenY == Integer.MIN_VALUE) {
            focusScreenX = this.getWidth() / 2;
            focusScreenY = this.getHeight() / 2;
        }
        float viewpageWidth = 0.0f;
        float viewpageHeight = 0.0f;
        if (this.getCurrentRootType() == 0 && this.pageRoot != null && this.pageRoot.getChildView() != null) {
            viewpageWidth = this.pageRoot.getChildView().getWidth();
            viewpageHeight = this.pageRoot.getChildView().getHeight();
        } else {
            viewpageWidth = this.getWidth();
            viewpageHeight = this.getHeight();
        }
        int lastpageHeight = (int)(viewpageHeight * oldScale);
        float ratioY = 1.0f * (float)(this.getScrollY() + focusScreenY) / (float)lastpageHeight;
        int lastpageWidth = (int)(viewpageWidth * oldScale);
        float ratioX = 1.0f * (float)(this.getScrollX() + focusScreenX) / (float)lastpageWidth;
        int pageHeight = (int)(viewpageHeight * newScale);
        int pageWidth = (int)(viewpageWidth * newScale);
        this.scrollBy((int)((float)(pageWidth - lastpageWidth) * ratioX), (int)((float)(pageHeight - lastpageHeight) * ratioY));
    }

    public void scrollTo(int x, int y) {
        x = Math.min(Math.max(x, 0), (int)((float)this.getWordWidth() * this.getZoom() - (float)this.getWidth()));
        y = Math.min(Math.max(y, 0), (int)((float)this.getWordHeight() * this.getZoom() - (float)this.getHeight()));
        super.scrollTo(Math.max(x, 0), Math.max(y, 0));
    }

    public int getCurrentPageNumber() {
        if (this.currentRootType == 1 || this.pageRoot == null) {
            return 1;
        }
        if (this.getCurrentRootType() == 2) {
            return this.printWord.getCurrentPageNumber();
        }
        PageView pv = WPViewKit.instance().getPageView(this.pageRoot, (int)((float)this.getScrollX() / this.zoom), (int)((float)this.getScrollY() / this.zoom) + this.getHeight() / 3);
        if (pv == null) {
            return 1;
        }
        return pv.getPageNumber();
    }

    public Rectangle getPageSize(int pageIndex) {
        if (this.pageRoot == null || this.currentRootType == 1) {
            return new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        if (pageIndex < 0 || pageIndex > this.pageRoot.getChildCount()) {
            return null;
        }
        PageView pv = WPViewKit.instance().getPageView(this.pageRoot, (int)((float)this.getScrollX() / this.zoom), (int)((float)this.getScrollY() / this.zoom) + this.getHeight() / 5);
        if (pv == null) {
            IAttributeSet attr = this.doc.getSection(0L).getAttribute();
            int pageWidth = (int)((float)AttrManage.instance().getPageWidth(attr) * 0.06666667f);
            int pageHeight = (int)((float)AttrManage.instance().getPageHeight(attr) * 0.06666667f);
            return new Rectangle(0, 0, pageWidth, pageHeight);
        }
        return new Rectangle(0, 0, pv.getWidth(), pv.getHeight());
    }

    private void drawPageNubmer(Canvas canvas, float zoom) {
        int currentNumber = this.getCurrentPageNumber();
        if (this.control.getMainFrame().isDrawPageNumber() && this.pageRoot != null) {
            Rect rect = canvas.getClipBounds();
            if (rect.width() != this.getWidth() || rect.height() != this.getHeight()) {
                return;
            }
            String pn = String.valueOf(currentNumber) + " / " + String.valueOf(this.pageRoot.getPageCount());
            int w = (int)this.paint.measureText(pn);
            int h = (int)(this.paint.descent() - this.paint.ascent());
            int x = (rect.right + this.getScrollX() - w) / 2;
            int y = rect.bottom - h - 20;
            Drawable drawable2 = SysKit.getPageNubmerDrawable();
            drawable2.setBounds(x - 10, y - 10, x + w + 10, y + h + 10);
            drawable2.draw(canvas);
            y = (int)((float)y - this.paint.ascent());
            canvas.drawText(pn, (float)x, (float)y, this.paint);
        }
        if (this.preShowPageIndex != currentNumber || this.prePageCount != this.getPageCount()) {
            this.control.getMainFrame().changePage();
            this.preShowPageIndex = currentNumber;
            this.prePageCount = this.getPageCount();
        }
    }

    @Override
    public long viewToModel(int x, int y, boolean isBack) {
        if (this.getCurrentRootType() == 0) {
            return this.pageRoot.viewToModel(x, y, isBack);
        }
        if (this.getCurrentRootType() == 1) {
            return this.normalRoot.viewToModel(x, y, isBack);
        }
        if (this.getCurrentRootType() == 2) {
            return this.printWord.viewToModel(x, y, isBack);
        }
        return 0L;
    }

    @Override
    public Rectangle modelToView(long offset, Rectangle rect, boolean isBack) {
        if (this.getCurrentRootType() == 0) {
            return this.pageRoot.modelToView(offset, rect, isBack);
        }
        if (this.getCurrentRootType() == 1) {
            return this.normalRoot.modelToView(offset, rect, isBack);
        }
        if (this.getCurrentRootType() == 2) {
            return this.printWord.modelToView(offset, rect, isBack);
        }
        return rect;
    }

    public IView getRoot(int rootType) {
        if (rootType == 0) {
            return this.pageRoot;
        }
        if (rootType == 1) {
            return this.normalRoot;
        }
        return null;
    }

    @Override
    public String getText(long start, long end) {
        return this.doc.getText(start, end);
    }

    public IDialogAction getDialogAction() {
        return this.dialogAction;
    }

    public WPFind getFind() {
        return this.wpFind;
    }

    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public IHighlight getHighlight() {
        return this.highlight;
    }

    @Override
    public IDocument getDocument() {
        return this.doc;
    }

    @Override
    public IControl getControl() {
        return this.control;
    }

    public StatusManage getStatus() {
        return this.status;
    }

    public WPEventManage getEventManage() {
        return this.eventManage;
    }

    public void setWordWidth(int mWidth) {
        this.mWidth = mWidth;
    }

    public void setWordHeight(int mHeight) {
        this.mHeight = mHeight;
    }

    public void setSize(int w, int h) {
        this.mWidth = w;
        this.mHeight = h;
    }

    public int getWordHeight() {
        if (this.getCurrentRootType() == 0) {
            return this.mHeight;
        }
        if (this.getCurrentRootType() == 1) {
            return this.normalRoot.getHeight();
        }
        return this.getHeight();
    }

    public int getWordWidth() {
        if (this.getCurrentRootType() == 0) {
            return this.mWidth;
        }
        if (this.getCurrentRootType() == 1) {
            return this.normalRoot.getWidth();
        }
        return this.getWidth();
    }

    protected void showPage(int index, int direction) {
        if (index < 0 || index >= this.getPageCount() || this.getCurrentRootType() == 1) {
            return;
        }
        if (this.getCurrentRootType() == 2) {
            if (direction == 0x2000000D) {
                this.printWord.previousPageview();
            } else if (direction == 0x2000000E) {
                this.printWord.nextPageView();
            } else {
                this.printWord.showPDFPageForIndex(index);
            }
            return;
        }
        PageView view = this.pageRoot.getPageView(index);
        if (view != null) {
            this.scrollTo(this.getScrollX(), (int)((float)view.getY() * this.zoom));
        }
    }

    public Bitmap pageToImage(int pageNumber) {
        if (pageNumber <= 0 || pageNumber > this.getPageCount() || this.pageRoot == null || this.pageRoot.getChildView() == null || this.getCurrentRootType() == 1) {
            return null;
        }
        PageView view = this.pageRoot.getPageView(pageNumber - 1);
        if (view == null) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.translate((float)(-view.getX()), (float)(-view.getY()));
        canvas.drawColor(-1);
        view.draw(canvas, 0, 0, 1.0f);
        return bitmap;
    }

    public Bitmap pageAreaToImage(int pageNumber, int srcLeft, int srcTop, int srcWidth, int srcHeight, int desWidth, int desHeight) {
        if (pageNumber <= 0 || pageNumber > this.getPageCount() || this.pageRoot == null || this.pageRoot.getChildView() == null || this.getCurrentRootType() == 1) {
            return null;
        }
        PageView view = this.pageRoot.getPageView(pageNumber - 1);
        if (view != null && SysKit.isValidateRect(view.getWidth(), view.getHeight(), srcLeft, srcTop, srcWidth, srcHeight)) {
            boolean b = PictureKit.instance().isDrawPictrue();
            PictureKit.instance().setDrawPictrue(true);
            float paintZoom = Math.min((float)desWidth / (float)srcWidth, (float)desHeight / (float)srcHeight);
            Bitmap bitmap = null;
            try {
                bitmap = Bitmap.createBitmap((int)((int)((float)srcWidth * paintZoom)), (int)((int)((float)srcHeight * paintZoom)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            catch (OutOfMemoryError e) {
                return null;
            }
            if (bitmap == null) {
                return null;
            }
            float tX = (float)(-(srcLeft + view.getX())) * paintZoom;
            float tY = (float)(-(srcTop + view.getY())) * paintZoom;
            Canvas canvas = new Canvas(bitmap);
            canvas.translate(tX, tY);
            canvas.drawColor(-1);
            view.draw(canvas, 0, 0, paintZoom);
            PictureKit.instance().setDrawPictrue(b);
            return bitmap;
        }
        return null;
    }

    public Bitmap getThumbnail(float zoom) {
        Rectangle size = this.getPageSize(1);
        if (size != null) {
            int thumbnailWidth = Math.round((float)size.width * zoom);
            int thumbnailHeight = Math.round((float)size.height * zoom);
            return this.pageAreaToImage(1, 0, 0, size.width, size.height, thumbnailWidth, thumbnailHeight);
        }
        return null;
    }

    public int getPageCount() {
        if (this.currentRootType == 1 || this.pageRoot == null) {
            return 1;
        }
        return this.pageRoot.getPageCount();
    }

    public int getCurrentRootType() {
        return this.currentRootType;
    }

    public void setCurrentRootType(int currentRootType) {
        this.currentRootType = currentRootType;
    }

    public float getZoom() {
        if (this.currentRootType == 1) {
            return this.normalZoom;
        }
        if (this.currentRootType == 0) {
            return this.zoom;
        }
        if (this.currentRootType == 2) {
            if (this.printWord != null) {
                return this.printWord.getZoom();
            }
            return this.zoom;
        }
        return this.zoom;
    }

    public float getFitZoom() {
        if (this.currentRootType == 1) {
            return 0.5f;
        }
        if (this.pageRoot == null) {
            return 1.0f;
        }
        float z = 1.0f;
        if (this.currentRootType == 2) {
            return this.printWord.getFitZoom();
        }
        if (this.currentRootType == 0) {
            int viewWidth;
            int pageWidth;
            IView view = this.pageRoot.getChildView();
            int n = pageWidth = view == null ? 0 : view.getWidth();
            if (pageWidth == 0) {
                pageWidth = (int)((float)AttrManage.instance().getPageWidth(this.doc.getSection(0L).getAttribute()) * 0.06666667f);
            }
            if ((viewWidth = this.getWidth()) == 0) {
                viewWidth = ((View)this.getParent()).getWidth();
            }
            z = (float)(viewWidth - 5) / (float)pageWidth;
        }
        return Math.min(z, 1.0f);
    }

    @Override
    public byte getEditType() {
        return 2;
    }

    public boolean isExportImageAfterZoom() {
        return this.isExportImageAfterZoom;
    }

    public void setExportImageAfterZoom(boolean isExportImageAfterZoom) {
        this.isExportImageAfterZoom = isExportImageAfterZoom;
    }

    @Override
    public FadeAnimation getParagraphAnimation(int pargraphID) {
        return null;
    }

    @Override
    public IShape getTextBox() {
        return null;
    }

    public void setBackgroundColor(int color2) {
        super.setBackgroundColor(color2);
        if (this.printWord != null) {
            this.printWord.setBackgroundColor(color2);
        }
    }

    public void setBackgroundResource(int resid) {
        super.setBackgroundResource(resid);
        if (this.printWord != null) {
            this.printWord.setBackgroundResource(resid);
        }
    }

    public void setBackgroundDrawable(Drawable d) {
        super.setBackgroundDrawable(d);
        if (this.printWord != null) {
            this.printWord.setBackgroundDrawable(d);
        }
    }

    public PrintWord getPrintWord() {
        return this.printWord;
    }

    public void updateFieldText() {
        if (this.pageRoot != null && this.pageRoot.checkUpdateHeaderFooterFieldText()) {
            this.control.actionEvent(0x2000000A, null);
        }
    }

    @Override
    public void dispose() {
        this.control = null;
        if (this.status != null) {
            this.status.dispose();
            this.status = null;
        }
        if (this.highlight != null) {
            this.highlight.dispose();
            this.highlight = null;
        }
        if (this.eventManage != null) {
            this.eventManage.dispose();
            this.eventManage = null;
        }
        if (this.pageRoot != null) {
            this.pageRoot.dispose();
            this.pageRoot = null;
        }
        if (this.normalRoot != null) {
            this.normalRoot.dispose();
            this.normalRoot = null;
        }
        if (this.dialogAction != null) {
            this.dialogAction.dispose();
            this.dialogAction = null;
        }
        if (this.wpFind != null) {
            this.wpFind.dispose();
            this.wpFind = null;
        }
        if (this.doc != null) {
            this.doc.dispose();
            this.doc = null;
        }
        if (this.printWord != null) {
            this.printWord.dispose();
        }
        this.setOnClickListener(null);
        this.doc = null;
        this.paint = null;
        this.visibleRect = null;
    }
}

