/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.control;

import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.system.IFind;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.Word;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PageRoot;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PageView;

public class WPFind
implements IFind {
    private boolean isSetPointToVisible;
    protected int pageIndex;
    protected int relativeParaIndex;
    protected String findString;
    protected String query;
    protected IElement findElement;
    protected Word word;
    protected Rectangle rect;

    public WPFind(Word word) {
        this.word = word;
        this.rect = new Rectangle();
    }

    @Override
    public boolean find(String query) {
        if (query == null) {
            return false;
        }
        this.isSetPointToVisible = false;
        this.query = query;
        float zoom = this.word.getZoom();
        long offset = 0L;
        if (this.word.getCurrentRootType() == 2) {
            IView view;
            for (view = this.word.getPrintWord().getCurrentPageView(); view != null && view.getType() != 5; view = view.getChildView()) {
            }
            if (view != null) {
                offset = view.getStartOffset(null);
            }
        } else {
            offset = this.word.viewToModel((int)((float)this.word.getScrollX() / zoom), (int)((float)this.word.getScrollY() / zoom), false);
        }
        IDocument doc = this.word.getDocument();
        this.findElement = doc.getParagraph(offset);
        while (this.findElement != null) {
            this.findString = this.findElement.getText(doc);
            int index = this.findString.indexOf(query);
            if (index >= 0) {
                this.addHighlight(index, query.length());
                return true;
            }
            this.findElement = doc.getParagraph(this.findElement.getEndOffset());
        }
        this.findString = null;
        return false;
    }

    @Override
    public boolean findBackward() {
        int index;
        if (this.query == null) {
            return false;
        }
        this.isSetPointToVisible = false;
        IDocument doc = this.word.getDocument();
        if (this.findString != null && (index = this.findString.lastIndexOf(this.query, this.relativeParaIndex - this.query.length() * 2)) >= 0) {
            this.addHighlight(index, this.query.length());
            return true;
        }
        this.findElement = doc.getParagraph(this.findElement == null ? doc.getLength(0L) - 1L : this.findElement.getStartOffset() - 1L);
        while (this.findElement != null) {
            this.findString = this.findElement.getText(doc);
            index = this.findString.lastIndexOf(this.query);
            if (index >= 0 && this.isSameSelectPosition(index)) {
                index = this.findString.lastIndexOf(this.query, index - this.query.length());
            }
            if (index >= 0) {
                this.addHighlight(index, this.query.length());
                return true;
            }
            this.findElement = doc.getParagraph(this.findElement.getStartOffset() - 1L);
        }
        this.findString = null;
        return false;
    }

    @Override
    public boolean findForward() {
        int index;
        if (this.query == null) {
            return false;
        }
        this.isSetPointToVisible = false;
        IDocument doc = this.word.getDocument();
        if (this.findString != null && (index = this.findString.indexOf(this.query, this.relativeParaIndex)) >= 0) {
            this.addHighlight(index, this.query.length());
            return true;
        }
        this.findElement = doc.getParagraph(this.findElement == null ? 0L : this.findElement.getEndOffset());
        while (this.findElement != null) {
            this.findString = this.findElement.getText(doc);
            index = this.findString.indexOf(this.query);
            if (index >= 0 && this.isSameSelectPosition(index)) {
                index = this.findString.indexOf(this.query, index + this.query.length());
            }
            if (index >= 0) {
                this.addHighlight(index, this.query.length());
                return true;
            }
            this.findElement = doc.getParagraph(this.findElement.getEndOffset());
        }
        this.findString = null;
        return false;
    }

    private void addHighlight(int index, int queryLen) {
        this.relativeParaIndex = index;
        long findCurrentOffset = this.findElement.getStartOffset() + (long)index;
        this.word.getHighlight().addHighlight(findCurrentOffset, findCurrentOffset + (long)queryLen);
        this.relativeParaIndex += queryLen;
        if (this.word.getCurrentRootType() == 2) {
            IView root = this.word.getRoot(0);
            boolean invalidate = true;
            if (root != null && root.getType() == 0) {
                IView pv;
                for (pv = ((PageRoot)root).getViewContainer().getParagraph(findCurrentOffset, false); pv != null && pv.getType() != 4; pv = pv.getParentView()) {
                }
                if (pv != null) {
                    this.pageIndex = ((PageView)pv).getPageNumber() - 1;
                    if (this.pageIndex != this.word.getCurrentPageNumber() - 1) {
                        this.word.showPage(this.pageIndex, -1);
                        this.isSetPointToVisible = true;
                        invalidate = false;
                    } else {
                        this.rect.setBounds(0, 0, 0, 0);
                        this.word.modelToView(findCurrentOffset, this.rect, false);
                        this.rect.x -= pv.getX();
                        this.rect.y -= pv.getY();
                        if (!this.word.getPrintWord().getListView().isPointVisibleOnScreen(this.rect.x, this.rect.y)) {
                            this.word.getPrintWord().getListView().setItemPointVisibleOnScreen(this.rect.x, this.rect.y);
                            invalidate = false;
                        } else {
                            this.word.getPrintWord().exportImage(this.word.getPrintWord().getListView().getCurrentPageView(), null);
                        }
                    }
                }
            }
            if (invalidate) {
                this.word.postInvalidate();
            }
            return;
        }
        this.rect.setBounds(0, 0, 0, 0);
        this.word.modelToView(findCurrentOffset, this.rect, false);
        Rectangle vRect = this.word.getVisibleRect();
        float zoom = this.word.getZoom();
        int x = (int)((float)this.rect.x * zoom);
        int y = (int)((float)this.rect.y * zoom);
        if (!vRect.contains(x, y)) {
            if ((float)(x + vRect.width) > (float)this.word.getWordWidth() * zoom) {
                x = (int)((float)this.word.getWordWidth() * zoom) - vRect.width;
            }
            if ((float)(y + vRect.height) > (float)this.word.getWordHeight() * zoom) {
                y = (int)((float)this.word.getWordHeight() * zoom) - vRect.height;
            }
            this.word.scrollTo(x, y);
        } else {
            this.word.postInvalidate();
        }
        this.word.getControl().actionEvent(20, null);
        if (this.word.getCurrentRootType() != 2) {
            this.word.getControl().actionEvent(0x2000000A, null);
        }
    }

    @Override
    public void resetSearchResult() {
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    private boolean isSameSelectPosition(int index) {
        return this.word.getHighlight().isSelectText() && this.findElement.getStartOffset() + (long)index == this.word.getHighlight().getSelectStart();
    }

    public boolean isSetPointToVisible() {
        return this.isSetPointToVisible;
    }

    public void setSetPointToVisible(boolean isSetPointToVisible) {
        this.isSetPointToVisible = isSetPointToVisible;
    }

    @Override
    public void dispose() {
        this.findElement = null;
        this.word = null;
        this.rect = null;
    }
}

