/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.control;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.text.ClipboardManager;
import android.view.View;
import com.ahmadullahpk.alldocumentreader.xs.common.ICustomDialog;
import com.ahmadullahpk.alldocumentreader.xs.common.IOfficeToPicture;
import com.ahmadullahpk.alldocumentreader.xs.common.bookmark.Bookmark;
import com.ahmadullahpk.alldocumentreader.xs.common.hyperlink.Hyperlink;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.system.AbstractControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IFind;
import com.ahmadullahpk.alldocumentreader.xs.system.IMainFrame;
import com.ahmadullahpk.alldocumentreader.xs.system.SysKit;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.ControlKit;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.Word;
import com.ahmadullahpk.alldocumentreader.xs.wp.dialog.TXTEncodingDialog;
import java.util.List;
import java.util.Vector;

public class WPControl
extends AbstractControl {
    private boolean isDispose;
    private IControl mainControl;
    private Word wpView;

    public WPControl(IControl mainControl, IDocument doc, String filePath) {
        this.mainControl = mainControl;
        this.wpView = new Word(mainControl.getMainFrame().getActivity().getApplicationContext(), doc, filePath, this);
    }

    @Override
    public void layoutView(int x, int y, int w, int h) {
    }

    @Override
    public void actionEvent(int actionID, final Object obj) {
        switch (actionID) {
            case 0x30000002: {
                this.wpView.showPage((Integer)obj, 0x30000002);
                if (this.wpView.getCurrentRootType() == 2) {
                    return;
                }
                this.updateStatus();
                this.exportImage();
                break;
            }
            case 26: {
                if (this.wpView.getParent() == null) break;
                this.wpView.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!WPControl.this.isDispose) {
                            WPControl.this.mainControl.getMainFrame().showProgressBar((Boolean)obj);
                        }
                    }
                });
                break;
            }
            case 27: {
                if (this.wpView.getParent() != null) {
                    this.wpView.post(new Runnable(){

                        @Override
                        public void run() {
                            if (!WPControl.this.isDispose) {
                                WPControl.this.mainControl.getMainFrame().updateViewImages((List)obj);
                            }
                        }
                    });
                    break;
                }
                new Thread(){

                    @Override
                    public void run() {
                        if (!WPControl.this.isDispose) {
                            WPControl.this.mainControl.getMainFrame().updateViewImages((List)obj);
                        }
                    }
                }.start();
                break;
            }
            case 19: {
                this.wpView.init();
                break;
            }
            case -268435456: {
                this.wpView.postInvalidate();
                break;
            }
            case 0x30000007: {
                if (this.wpView.getCurrentRootType() == 2) {
                    return;
                }
                this.wpView.switchView(2);
                this.updateStatus();
                break;
            }
            case 0x30000001: {
                int rootType;
                rootType = obj != null ? (Integer)obj : ((rootType = this.wpView.getCurrentRootType()) == 0 ? 1 : 0);
                this.wpView.switchView(rootType);
                this.updateStatus();
                if (rootType == 2) break;
                this.exportImage();
                break;
            }
            case 0x20000005: {
                int[] params = (int[])obj;
                this.wpView.setZoom((float)params[0] / 10000.0f, params[1], params[2]);
                this.wpView.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!WPControl.this.isDispose) {
                            WPControl.this.getMainFrame().changeZoom();
                        }
                    }
                });
                break;
            }
            case 20: {
                this.updateStatus();
                break;
            }
            case 0x30000000: {
                this.wpView.getStatus().setSelectTextStatus(!this.wpView.getStatus().isSelectTextStatus());
                break;
            }
            case 0x20000002: {
                ControlKit.instance().internetSearch(this.wpView);
                break;
            }
            case 0x10000002: {
                ClipboardManager clip = (ClipboardManager)this.getActivity().getSystemService("clipboard");
                clip.setText((CharSequence)this.wpView.getHighlight().getSelectText());
                break;
            }
            case 22: {
                this.wpView.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!WPControl.this.isDispose) {
                            WPControl.this.mainControl.getMainFrame().showProgressBar(false);
                        }
                    }
                });
                if (!this.isAutoTest()) break;
                this.getMainFrame().getActivity().onBackPressed();
                break;
            }
            case 0x2000000A: {
                this.exportImage();
                break;
            }
            case 0x2000000D: {
                if (this.wpView.getCurrentRootType() == 1) {
                    if (this.wpView.getEventManage() != null) {
                        this.wpView.getEventManage().onScroll(null, null, 0.0f, -this.wpView.getHeight() + 10);
                    }
                } else {
                    this.wpView.showPage(this.wpView.getCurrentPageNumber() - 2, 0x2000000D);
                }
                if (this.wpView.getCurrentRootType() == 2) {
                    return;
                }
                this.updateStatus();
                this.exportImage();
                break;
            }
            case 0x2000000E: {
                if (this.wpView.getCurrentRootType() == 1) {
                    if (this.wpView.getEventManage() != null) {
                        this.wpView.getEventManage().onScroll(null, null, 0.0f, this.wpView.getHeight() + 10);
                    }
                } else {
                    this.wpView.showPage(this.wpView.getCurrentPageNumber(), 0x2000000E);
                }
                if (this.wpView.getCurrentRootType() == 2) {
                    return;
                }
                this.updateStatus();
                this.exportImage();
                break;
            }
            case 0x20000008: {
                Hyperlink link = (Hyperlink)obj;
                if (link == null) break;
                try {
                    if (link.getLinkType() == 5) {
                        Bookmark bm = this.getSysKit().getBookmarkManage().getBookmark(link.getAddress());
                        if (bm == null) break;
                        ControlKit.instance().gotoOffset(this.wpView, bm.getStart());
                        break;
                    }
                    Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)link.getAddress()));
                    this.getMainFrame().getActivity().startActivity(intent);
                }
                catch (Exception exception) {}
                break;
            }
            case 0x30000005: {
                if (this.wpView.getCurrentRootType() != 1) break;
                this.wpView.setExportImageAfterZoom(true);
                this.wpView.layoutNormal();
                break;
            }
            case 0x30000008: {
                if (this.wpView == null) break;
                this.wpView.updateFieldText();
                if (this.wpView.getParent() == null) {
                    this.getMainFrame().completeLayout();
                    break;
                }
                this.wpView.post(new Runnable(){

                    @Override
                    public void run() {
                        WPControl.this.getMainFrame().completeLayout();
                    }
                });
                break;
            }
            case 536870933: {
                this.wpView.setFitSize((Integer)obj);
                break;
            }
            case 536870942: {
                this.wpView.getPrintWord().getListView().getCurrentPageView().initCalloutView();
                break;
            }
        }
    }

    @Override
    public Object getActionValue(int actionID, Object obj) {
        switch (actionID) {
            case 0x20000005: {
                return Float.valueOf(this.wpView.getZoom());
            }
            case 0x30000000: {
                return this.wpView.getStatus().isSelectTextStatus();
            }
            case 0x20000006: {
                return Float.valueOf(this.wpView.getFitZoom());
            }
            case 0x2000000B: {
                return this.wpView.getPageCount();
            }
            case 0x2000000C: {
                return this.wpView.getCurrentPageNumber();
            }
            case 0x30000003: {
                return this.wpView.pageToImage((Integer)obj);
            }
            case 536870931: {
                int[] paraArr;
                if (!(obj instanceof int[]) || (paraArr = (int[])obj) == null || paraArr.length != 7) break;
                return this.wpView.pageAreaToImage(paraArr[0], paraArr[1], paraArr[2], paraArr[3], paraArr[4], paraArr[5], paraArr[6]);
            }
            case 0x20000010: {
                if (!(obj instanceof Integer)) break;
                return this.wpView.getThumbnail((float)((Integer)obj).intValue() / 10000.0f);
            }
            case 0x30000004: {
                return this.wpView.getPageSize((Integer)obj - 1);
            }
            case 0x30000006: {
                return this.wpView.getCurrentRootType();
            }
            case 536870934: {
                if (this.wpView == null) break;
                return this.wpView.getFitSizeState();
            }
            case 536870936: {
                if (this.wpView == null) break;
                return this.wpView.getSnapshot((Bitmap)obj);
            }
        }
        return null;
    }

    private void exportImage() {
        this.wpView.post(new Runnable(){

            @Override
            public void run() {
                if (!WPControl.this.isDispose) {
                    WPControl.this.wpView.createPicture();
                }
            }
        });
    }

    private void updateStatus() {
        this.wpView.post(new Runnable(){

            @Override
            public void run() {
                if (!WPControl.this.isDispose) {
                    WPControl.this.getMainFrame().updateToolsbarStatus();
                }
            }
        });
    }

    @Override
    public int getCurrentViewIndex() {
        return this.wpView.getCurrentPageNumber();
    }

    @Override
    public View getView() {
        return this.wpView;
    }

    @Override
    public Dialog getDialog(Activity activity, int id2) {
        switch (id2) {
            case 1: {
                Vector<Object> vector = new Vector<Object>();
                vector.add(this.wpView.getFilePath());
                new TXTEncodingDialog(this, (Context)activity, this.wpView.getDialogAction(), vector, id2).show();
                break;
            }
        }
        return null;
    }

    @Override
    public IMainFrame getMainFrame() {
        return this.mainControl.getMainFrame();
    }

    @Override
    public Activity getActivity() {
        return this.getMainFrame().getActivity();
    }

    @Override
    public IFind getFind() {
        return this.wpView.getFind();
    }

    @Override
    public boolean isAutoTest() {
        return this.mainControl.isAutoTest();
    }

    @Override
    public IOfficeToPicture getOfficeToPicture() {
        return this.mainControl.getOfficeToPicture();
    }

    @Override
    public ICustomDialog getCustomDialog() {
        return this.mainControl.getCustomDialog();
    }

    @Override
    public byte getApplicationType() {
        return 0;
    }

    @Override
    public SysKit getSysKit() {
        return this.mainControl.getSysKit();
    }

    @Override
    public void dispose() {
        this.isDispose = true;
        this.wpView.dispose();
        this.wpView = null;
        this.mainControl = null;
    }
}

