/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data;

import android.graphics.Point;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.GeneralPath;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFInputStream;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFTag;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.AbstractPolygon;
import java.io.IOException;

public class Polyline
extends AbstractPolygon {
    public Polyline() {
        super(4, 1, null, 0, null);
    }

    public Polyline(Rectangle bounds, int numberOfPoints, Point[] points) {
        super(4, 1, bounds, numberOfPoints, points);
    }

    protected Polyline(int id2, int version, Rectangle bounds, int numberOfPoints, Point[] points) {
        super(id2, version, bounds, numberOfPoints, points);
    }

    @Override
    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        Rectangle r = emf.readRECTL();
        int n = emf.readDWORD();
        return new Polyline(r, n, emf.readPOINTL(n));
    }

    @Override
    public void render(EMFRenderer renderer) {
        Point[] points = this.getPoints();
        int numberOfPoints = this.getNumberOfPoints();
        if (points != null && points.length > 0) {
            GeneralPath gp = new GeneralPath(renderer.getWindingRule());
            for (int point = 0; point < numberOfPoints; ++point) {
                Point p = points[point];
                if (point > 0) {
                    gp.lineTo(p.x, p.y);
                    continue;
                }
                gp.moveTo(p.x, p.y);
            }
            renderer.drawOrAppend(gp);
        }
    }
}

