/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data;

import android.graphics.Point;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.GeneralPath;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFInputStream;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFTag;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.AbstractPolygon;
import java.io.IOException;

public class PolyBezierTo
extends AbstractPolygon {
    public PolyBezierTo() {
        super(5, 1, null, 0, null);
    }

    public PolyBezierTo(Rectangle bounds, int numberOfPoints, Point[] points) {
        super(5, 1, bounds, numberOfPoints, points);
    }

    protected PolyBezierTo(int id2, int version, Rectangle bounds, int numberOfPoints, Point[] points) {
        super(id2, version, bounds, numberOfPoints, points);
    }

    @Override
    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        Rectangle r = emf.readRECTL();
        int n = emf.readDWORD();
        return new PolyBezierTo(r, n, emf.readPOINTL(n));
    }

    @Override
    public void render(EMFRenderer renderer) {
        Point[] points = this.getPoints();
        int numberOfPoints = this.getNumberOfPoints();
        GeneralPath currentFigure = renderer.getFigure();
        if (points != null && points.length > 0) {
            for (int point = 0; point < numberOfPoints; point += 3) {
                Point p1 = points[point];
                Point p2 = points[point + 1];
                Point p3 = points[point + 2];
                currentFigure.curveTo(p1.x, p1.y, p2.x, p2.y, p3.x, p3.y);
            }
        }
    }
}

