/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data;

import com.ahmadullahpk.alldocumentreader.xs.simpletext.font.Font;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFConstants;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFInputStream;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.GDIObject;
import java.io.IOException;

public class LogFontW
implements EMFConstants,
GDIObject {
    private int height;
    private int width;
    private int escapement;
    private int orientation;
    private int weight;
    private boolean italic;
    private boolean underline;
    private boolean strikeout;
    private int charSet;
    private int outPrecision;
    private int clipPrecision;
    private int quality;
    private int pitchAndFamily;
    private String faceFamily;
    private Font font;

    public LogFontW(int height, int width, int escapement, int orientation, int weight, boolean italic, boolean underline, boolean strikeout, int charSet, int outPrecision, int clipPrecision, int quality, int pitchAndFamily, String faceFamily) {
        this.height = height;
        this.width = width;
        this.escapement = escapement;
        this.orientation = orientation;
        this.weight = weight;
        this.italic = italic;
        this.underline = underline;
        this.strikeout = strikeout;
        this.charSet = charSet;
        this.outPrecision = outPrecision;
        this.clipPrecision = clipPrecision;
        this.quality = quality;
        this.pitchAndFamily = pitchAndFamily;
        this.faceFamily = faceFamily;
    }

    public LogFontW(Font font) {
        this.height = (int)(-font.getFontSize());
        this.width = 0;
        this.escapement = 0;
        this.orientation = 0;
        this.weight = font.isBold() ? 700 : 400;
        this.italic = font.isItalic();
        this.underline = false;
        this.strikeout = false;
        this.charSet = 0;
        this.outPrecision = 0;
        this.clipPrecision = 0;
        this.quality = 4;
        this.pitchAndFamily = 0;
        this.faceFamily = font.getName();
    }

    public LogFontW(EMFInputStream emf) throws IOException {
        this.height = emf.readLONG();
        this.width = emf.readLONG();
        this.escapement = emf.readLONG();
        this.orientation = emf.readLONG();
        this.weight = emf.readLONG();
        this.italic = emf.readBOOLEAN();
        this.underline = emf.readBOOLEAN();
        this.strikeout = emf.readBOOLEAN();
        this.charSet = emf.readBYTE();
        this.outPrecision = emf.readBYTE();
        this.clipPrecision = emf.readBYTE();
        this.quality = emf.readBYTE();
        this.pitchAndFamily = emf.readBYTE();
        this.faceFamily = emf.readWCHAR(32);
    }

    public Font getFont() {
        if (this.font == null) {
            int style2 = 0;
            if (this.italic) {
                style2 |= 2;
            }
            if (this.weight > 400) {
                style2 |= 1;
            }
            int size = Math.abs(this.height);
            this.font = new Font(this.faceFamily, style2, size);
        }
        return this.font;
    }

    public int getEscapement() {
        return this.escapement;
    }

    public String toString() {
        return "  LogFontW\n    height: " + this.height + "\n    width: " + this.width + "\n    orientation: " + this.orientation + "\n    weight: " + this.weight + "\n    italic: " + this.italic + "\n    underline: " + this.underline + "\n    strikeout: " + this.strikeout + "\n    charSet: " + this.charSet + "\n    outPrecision: " + this.outPrecision + "\n    clipPrecision: " + this.clipPrecision + "\n    quality: " + this.quality + "\n    pitchAndFamily: " + this.pitchAndFamily + "\n    faceFamily: " + this.faceFamily;
    }

    @Override
    public void render(EMFRenderer renderer) {
        renderer.setFont(this.font);
    }
}

