/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data;

import android.graphics.Point;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.GeneralPath;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFInputStream;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFTag;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.AbstractPolygon;
import java.io.IOException;

public class EMFPolygon
extends AbstractPolygon {
    public EMFPolygon() {
        super(3, 1, null, 0, null);
    }

    public EMFPolygon(Rectangle bounds, int numberOfPoints, Point[] points) {
        super(3, 1, bounds, numberOfPoints, points);
    }

    protected EMFPolygon(int id2, int version, Rectangle bounds, int numberOfPoints, Point[] points) {
        super(id2, version, bounds, numberOfPoints, points);
    }

    @Override
    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        Rectangle r = emf.readRECTL();
        int n = emf.readDWORD();
        return new EMFPolygon(r, n, emf.readPOINTL(n));
    }

    @Override
    public void render(EMFRenderer renderer) {
        Point[] points = this.getPoints();
        if (points.length > 1) {
            GeneralPath path = new GeneralPath(renderer.getWindingRule());
            path.moveTo(points[0].x, points[0].y);
            for (int i = 1; i < points.length; ++i) {
                path.lineTo(points[i].x, points[i].y);
            }
            path.closePath();
            renderer.fillAndDrawOrAppend(path);
        }
    }
}

