/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data;

import android.graphics.Bitmap;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Color;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.AffineTransform;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFConstants;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFImageLoader;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFInputStream;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFTag;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.BitmapInfo;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.BlendFunction;
import java.io.IOException;

public class AlphaBlend
extends EMFTag
implements EMFConstants {
    private static final int size = 108;
    private Rectangle bounds;
    private int x;
    private int y;
    private int width;
    private int height;
    private BlendFunction dwROP;
    private int xSrc;
    private int ySrc;
    private AffineTransform transform;
    private Color bkg;
    private int usage;
    private BitmapInfo bmi;
    private Bitmap image;

    public AlphaBlend() {
        super(114, 1);
    }

    public AlphaBlend(Rectangle bounds, int x, int y, int width, int height, AffineTransform transform, Bitmap image, Color bkg) {
        this();
        this.bounds = bounds;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.dwROP = new BlendFunction(0, 0, 255, 1);
        this.xSrc = 0;
        this.ySrc = 0;
        this.transform = transform;
        this.bkg = bkg == null ? new Color(0, 0, 0, 0) : bkg;
        this.usage = 0;
        this.image = image;
        this.bmi = null;
    }

    @Override
    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        AlphaBlend tag = new AlphaBlend();
        tag.bounds = emf.readRECTL();
        tag.x = emf.readLONG();
        tag.y = emf.readLONG();
        tag.width = emf.readLONG();
        tag.height = emf.readLONG();
        tag.dwROP = new BlendFunction(emf);
        tag.xSrc = emf.readLONG();
        tag.ySrc = emf.readLONG();
        tag.transform = emf.readXFORM();
        tag.bkg = emf.readCOLORREF();
        tag.usage = emf.readDWORD();
        emf.readDWORD();
        int bmiSize = emf.readDWORD();
        emf.readDWORD();
        int bitmapSize = emf.readDWORD();
        emf.readLONG();
        emf.readLONG();
        tag.bmi = bmiSize > 0 ? new BitmapInfo(emf) : null;
        tag.image = EMFImageLoader.readImage(tag.bmi.getHeader(), tag.width, tag.height, emf, len - 100 - 40, tag.dwROP);
        return tag;
    }

    @Override
    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds + "\n  x, y, w, h: " + this.x + " " + this.y + " " + this.width + " " + this.height + "\n  dwROP: " + this.dwROP + "\n  xSrc, ySrc: " + this.xSrc + " " + this.ySrc + "\n  transform: " + this.transform + "\n  bkg: " + this.bkg + "\n  usage: " + this.usage + "\n" + (this.bmi != null ? this.bmi.toString() : "  bitmap: null");
    }

    @Override
    public void render(EMFRenderer renderer) {
        if (this.image != null) {
            renderer.drawImage(this.image, this.x, this.y, this.width, this.height);
        }
    }
}

