/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data;

import android.graphics.Point;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.GeneralPath;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFTag;

public abstract class AbstractPolyPolygon
extends EMFTag {
    private Rectangle bounds;
    private int[] numberOfPoints;
    private Point[][] points;

    protected AbstractPolyPolygon(int id2, int version, Rectangle bounds, int[] numberOfPoints, Point[][] points) {
        super(id2, version);
        this.bounds = bounds;
        this.numberOfPoints = numberOfPoints;
        this.points = points;
    }

    @Override
    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds + "\n  #polys: " + this.numberOfPoints.length;
    }

    protected Rectangle getBounds() {
        return this.bounds;
    }

    protected int[] getNumberOfPoints() {
        return this.numberOfPoints;
    }

    protected Point[][] getPoints() {
        return this.points;
    }

    @Override
    public void render(EMFRenderer renderer) {
        this.render(renderer, true);
    }

    protected void render(EMFRenderer renderer, boolean closePath) {
        GeneralPath path = new GeneralPath(renderer.getWindingRule());
        for (int polygon = 0; polygon < this.numberOfPoints.length; ++polygon) {
            GeneralPath gp = new GeneralPath(renderer.getWindingRule());
            for (int point = 0; point < this.numberOfPoints[polygon]; ++point) {
                Point p = this.points[polygon][point];
                if (point > 0) {
                    gp.lineTo(p.x, p.y);
                    continue;
                }
                gp.moveTo(p.x, p.y);
            }
            if (closePath) {
                gp.closePath();
            }
            path.append(gp, false);
        }
        if (closePath) {
            renderer.fillAndDrawOrAppend(path);
        } else {
            renderer.drawOrAppend(path);
        }
    }
}

