/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data;

import android.graphics.Point;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Shape;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.Arc2D;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFTag;

public abstract class AbstractArc
extends EMFTag {
    private Rectangle bounds;
    private Point start;
    private Point end;

    protected AbstractArc(int id2, int version, Rectangle bounds, Point start, Point end) {
        super(id2, version);
        this.bounds = bounds;
        this.start = start;
        this.end = end;
    }

    @Override
    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds + "\n  start: " + this.start + "\n  end: " + this.end;
    }

    protected double getAngle(Point point) {
        double circleX = this.bounds.getX() + this.bounds.getWidth() / 2.0;
        double circleY = this.bounds.getY() + this.bounds.getHeight() / 2.0;
        double x = point.x;
        double y = point.y;
        double alpha = 0.0;
        if (x > circleX) {
            double nx = Math.abs(y - circleY) / (x - circleX);
            alpha = Math.atan(nx) / Math.PI * 180.0;
            if (y > circleY) {
                alpha = 360.0 - alpha;
            }
        } else if (x == circleX) {
            alpha = y < circleY ? 90.0 : 270.0;
        } else {
            double nx = Math.abs(y - circleY) / (circleX - x);
            alpha = Math.atan(nx) / Math.PI * 180.0;
            alpha = y < circleY ? 180.0 - alpha : (alpha += 180.0);
        }
        return alpha;
    }

    protected Shape getShape(EMFRenderer renderer, int arcType) {
        double alpha1;
        double alpha0;
        if (renderer.getArcDirection() == 2) {
            alpha0 = this.getAngle(this.end);
            alpha1 = this.getAngle(this.start);
        } else {
            alpha0 = this.getAngle(this.start);
            alpha1 = this.getAngle(this.end);
        }
        double extent = 0.0;
        extent = alpha1 > alpha0 ? alpha1 - alpha0 : 360.0 - (alpha0 - alpha1);
        return new Arc2D.Double(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight(), alpha0, extent, arcType);
    }
}

