/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.tools;

import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.AbstractChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.RoundChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.XYChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.DefaultRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.tools.AbstractTool;

public class Zoom
extends AbstractTool {
    private boolean mZoomIn;
    private float mZoomRate;

    public Zoom(AbstractChart chart, boolean in, float rate) {
        super(chart);
        this.mZoomIn = in;
        this.setZoomRate(rate);
    }

    public void setZoomRate(float rate) {
        this.mZoomRate = rate;
    }

    public void apply() {
        if (this.mChart instanceof XYChart) {
            int scales = this.mRenderer.getScalesCount();
            for (int i = 0; i < scales; ++i) {
                double[] range = this.getRange(i);
                this.checkRange(range, i);
                double[] limits = this.mRenderer.getZoomLimits();
                boolean limited = limits != null && limits.length == 4;
                double centerX = (range[0] + range[1]) / 2.0;
                double centerY = (range[2] + range[3]) / 2.0;
                double newWidth = range[1] - range[0];
                double newHeight = range[3] - range[2];
                if (this.mZoomIn) {
                    if (this.mRenderer.isZoomXEnabled()) {
                        newWidth /= (double)this.mZoomRate;
                    }
                    if (this.mRenderer.isZoomYEnabled()) {
                        newHeight /= (double)this.mZoomRate;
                    }
                } else {
                    if (this.mRenderer.isZoomXEnabled()) {
                        newWidth *= (double)this.mZoomRate;
                    }
                    if (this.mRenderer.isZoomYEnabled()) {
                        newHeight *= (double)this.mZoomRate;
                    }
                }
                if (this.mRenderer.isZoomXEnabled()) {
                    double newXMin = centerX - newWidth / 2.0;
                    double newXMax = centerX + newWidth / 2.0;
                    if (!limited || limits[0] <= newXMin && limits[1] >= newXMax) {
                        this.setXRange(newXMin, newXMax, i);
                    }
                }
                if (!this.mRenderer.isZoomYEnabled()) continue;
                double newYMin = centerY - newHeight / 2.0;
                double newYMax = centerY + newHeight / 2.0;
                if (limited && (!(limits[2] <= newYMin) || !(limits[3] >= newYMax))) continue;
                this.setYRange(newYMin, newYMax, i);
            }
        } else {
            DefaultRenderer renderer = ((RoundChart)this.mChart).getRenderer();
            if (this.mZoomIn) {
                renderer.setScale(renderer.getScale() * this.mZoomRate);
            } else {
                renderer.setScale(renderer.getScale() / this.mZoomRate);
            }
        }
    }
}

