/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.XYChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.XYMultipleSeriesDataset;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.SimpleSeriesRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.XYMultipleSeriesRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.XYSeriesRenderer;

public class ScatterChart
extends XYChart {
    public static final String TYPE = "Scatter";
    private static final float SIZE = 3.0f;
    private float size = 3.0f;
    private boolean drawFrame = true;

    ScatterChart() {
    }

    public ScatterChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super(dataset, renderer);
        this.size = renderer.getPointSize();
    }

    @Override
    protected void setDatasetRenderer(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super.setDatasetRenderer(dataset, renderer);
        this.size = renderer.getPointSize();
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] points, SimpleSeriesRenderer seriesRenderer, float yAxisValue, int seriesIndex) {
        XYSeriesRenderer renderer = (XYSeriesRenderer)seriesRenderer;
        paint.setColor(renderer.getColor());
        if (renderer.isFillPoints()) {
            paint.setStyle(Paint.Style.FILL);
        } else {
            paint.setStyle(Paint.Style.STROKE);
        }
        int length = points.length;
        switch (renderer.getPointStyle()) {
            case X: {
                for (int i = 0; i < length; i += 2) {
                    this.drawX(canvas, paint, points[i], points[i + 1]);
                }
                break;
            }
            case CIRCLE: {
                for (int i = 0; i < length; i += 2) {
                    this.drawCircle(canvas, paint, points[i], points[i + 1]);
                }
                break;
            }
            case TRIANGLE: {
                float[] path = new float[6];
                for (int i = 0; i < length; i += 2) {
                    this.drawTriangle(canvas, paint, path, points[i], points[i + 1]);
                }
                break;
            }
            case SQUARE: {
                for (int i = 0; i < length; i += 2) {
                    this.drawSquare(canvas, paint, points[i], points[i + 1]);
                }
                break;
            }
            case DIAMOND: {
                float[] path = new float[8];
                for (int i = 0; i < length; i += 2) {
                    this.drawDiamond(canvas, paint, path, points[i], points[i + 1]);
                }
                break;
            }
            case POINT: {
                canvas.drawPoints(points, paint);
            }
        }
    }

    @Override
    public int getLegendShapeWidth(int seriesIndex) {
        return (int)this.getRenderer().getLegendTextSize();
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer renderer, float x, float y, int seriesIndex, Paint paint) {
        if (((XYSeriesRenderer)renderer).isFillPoints()) {
            paint.setStyle(Paint.Style.FILL);
        } else {
            paint.setStyle(Paint.Style.STROKE);
        }
        float shapeWidth = (float)((int)this.getRenderer().getLegendTextSize()) * this.mRenderer.getZoomRate();
        x += shapeWidth / 2.0f;
        switch (((XYSeriesRenderer)renderer).getPointStyle()) {
            case X: {
                this.drawX(canvas, paint, x, y);
                break;
            }
            case CIRCLE: {
                this.drawCircle(canvas, paint, x, y);
                break;
            }
            case TRIANGLE: {
                this.drawTriangle(canvas, paint, new float[6], x, y);
                break;
            }
            case SQUARE: {
                this.drawSquare(canvas, paint, x, y);
                break;
            }
            case DIAMOND: {
                this.drawDiamond(canvas, paint, new float[8], x, y);
                break;
            }
            case POINT: {
                canvas.drawPoint(x, y, paint);
            }
        }
    }

    private void drawX(Canvas canvas, Paint paint, float x, float y) {
        float temSize = this.size * this.mRenderer.getZoomRate();
        canvas.drawLine(x - temSize, y - temSize, x + temSize, y + temSize, paint);
        canvas.drawLine(x + temSize, y - temSize, x - temSize, y + temSize, paint);
    }

    private void drawCircle(Canvas canvas, Paint paint, float x, float y) {
        float temSize = this.size * this.mRenderer.getZoomRate();
        canvas.drawCircle(x, y, temSize, paint);
    }

    private void drawTriangle(Canvas canvas, Paint paint, float[] path, float x, float y) {
        float temSize = this.size * this.mRenderer.getZoomRate();
        path[0] = x;
        path[1] = y - temSize - temSize / 2.0f;
        path[2] = x - temSize;
        path[3] = y + temSize;
        path[4] = x + temSize;
        path[5] = path[3];
        this.drawPath(canvas, path, paint, true);
    }

    private void drawSquare(Canvas canvas, Paint paint, float x, float y) {
        float temSize = this.size * this.mRenderer.getZoomRate();
        canvas.drawRect(x - temSize, y - temSize, x + temSize, y + temSize, paint);
    }

    private void drawDiamond(Canvas canvas, Paint paint, float[] path, float x, float y) {
        float temSize = this.size * this.mRenderer.getZoomRate();
        path[0] = x;
        path[1] = y - temSize;
        path[2] = x - temSize;
        path[3] = y;
        path[4] = x;
        path[5] = y + temSize;
        path[6] = x + temSize;
        path[7] = y;
        this.drawPath(canvas, path, paint, true);
    }

    @Override
    public String getChartType() {
        return TYPE;
    }

    public void setDrawFrameFlag(boolean drawFrame) {
        this.drawFrame = drawFrame;
    }

    public boolean isDrawFrame() {
        return this.drawFrame;
    }
}

